// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// diapatrn.hh --- header file that defines diapattern class
// -----
// ChangeLog:
// 2007. 11. 16
//  Changed style.
// -----

#include "globvar.hh"
#include "enumerat.hh"
#include "nextsta.hh"

#include <iostream>
#include <string>
#include <vector>
#include <stdexcept>

using std :: cerr ;
using std :: endl ;
using std :: string ;
using std :: vector ;



#ifndef ___DIAPATRN_HH
#define ___DIAPATRN_HH		// Ƥ2٥󥯥롼ɤƤס


// -----
// Nextsta pointer container
// nextsta 饹Υݥ󥿤Υƥ
// -----
class _NextstaPtrs
  : private vector < nextsta * >
{
public :
  typedef size_type np_size_type ;
  typedef iterator np_iterator ;

  np_iterator np_begin () { return begin () ; }
  np_iterator np_end () { return end () ; }
  np_size_type np_size () { return size () ; }
  void np_push_back ( nextsta * x ) { push_back ( x ) ; }

  nextsta * & getElement ( np_size_type i )
  { try { return at ( i ) ; } catch ( std :: out_of_range )
    { cerr << "Error: subscript out of range (_NextstaPtrs)" << endl ;
      exit ( 26 ) ; } }

  _NextstaPtrs () : vector < nextsta * > () {}
  _NextstaPtrs ( const _NextstaPtrs & x ) : vector < nextsta * > ( x ) {}
  ~_NextstaPtrs () ;

} ;



// -----
// The class holding a train schedule "pattern"
// ѥǡ򤢤魯饹
// -----
class diapattern
  : public _NextstaPtrs ,
    public readdata
{

private :
//   void error26_name ()
//   {
//     cerr << "Error: subscript out of range in diapattern object "
//          << "nextsta data call" << endl ;
//   }

  int ndpt ;		// Υѥֹ
  double twhole ;	// ֡á
  int cars ;    	// ֿ
  double phase ;	// ַΰ
  int dptm ;   // ѥܿ, twhole / cars * dptm = const. for all dpt's
  double addphase ;	// ­Ǥ

  // 5ѿtrain ֥Ȥν
  double pos ;
  double vel ;
  car_stat stat ;
  double tdept ;
  double taudx ;

  dp_command dcmd ;	// nextsta ֥ȤϤޥѿ
  bool bufss ;		// setbuf ټ¹Ԥ true
  bool bufset ; 	// setbuf ټ¹Ԥ true

  string train_type_key ;

  void membercopy ( diapattern & ) ;	// Хԡ

  void setnxx () ;		// nextsta object Υå
  void nextnxx () ;		// nextsta object  nxx 򥻥å

  void realphase_cal () ;	// phase ֤­碌褦׻

public :

  diapattern () ;			// empty constructor
  // destructor ʤġ reftable ΤΤǽʬ

  diapattern & operator= ( diapattern & ) ;	// 黻Ҥ overload
  diapattern ( diapattern & ) ;        	// X(X&)

  // train obj. ν
  void settrain ( double p , double v , car_stat s , double td )
  { pos = p ; vel = v ; stat = s ; tdept = 0.0 ; taudx = td ; }
  void settdept ( double td ) { tdept = td ; }

  diapattern & operator+= ( nextsta & ) ;	// nextsta obj. ä

  // ե꡼
  int readfile ( FILE * , char * ) ;
  bool readfile_xml ( TiXmlNode const * ) ;

  int car_number () { return cars ; }	// ξ
  double wholetime () { return twhole ; }

  // ߥ졼ѥΣ֤֤
  double ptntime () { return twhole / cars * dptm ; }

  // nextsta object  dcmd 򥻥å
  void setdc ( dp_command ) ;

  // ndpt Υå
  void set_ndpt ( int x ) { ndpt = x ; }

  void prtinit () ;
  void prtreset () ;
  bool setbuf () ;

  // ֽ extraction
  double phasevalue () { return addphase ;}
  double initpos () { return pos ; }
  double initvel () { return vel ; }
  car_stat carstat () { return stat ; }
  double departuretime () { return tdept ; }
  double delaytime () { return taudx ; }
  nextsta * initnxx () { return * np_begin () ; }

  string const * getTrainTypeKey () const { return & train_type_key ; }
  
} ;

#endif /* ! ___DIAPATRN_HH */
