// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// elecchar.hh --- defines class elecchar and related classes
// -----
// ChangeLog:
// 2008. 1. 18
//  Added elecchar::writeToCSV(), elecchar::writeHeaderToCSV() functions.
// 2008. 1. 17
//  Added variable elecchar::suppress_csv.
// 2007. 12. 5
//  Added variables a_conv and di_conv in class elecchar.
//  Added teta_vi_core() and teta_vi_ESS() in class elecchar.
// 2007. 12. 4
//  Added classes ESS_Substation and No_ESS_Substation.
//  Added elecchar::sub_ess.
// 2007. 11. 20
//  Added elecchar::scvits.
// 2007. 11. 16
//  Class sscon now derived from vector<ssfeedconnect>. Use of RefTable.hh
//  eliminated.
// 2007. 11. 8
//  Added functions elecchar::readfile_xml(), sschar::readxml_vichars().
//  These functions will be used to parse XML-based S files.
// -----

#include "globvar.hh"
#include "enumerat.hh"
#include "readdata.hh"
#include "EnergyStorage.hh"
#include "ElectricChars.hh"

#include <iostream>
#include <stdexcept>
#include <string>
#include <vector>

#include "tinyxml.h"
#include "Substation_Control_VI_TS.hh"

using std :: cerr ;
using std :: endl ;
using std :: string ;
using std :: vector ;
using std :: ostream ;

#ifndef ___ELECCHAR_HH
#define ___ELECCHAR_HH		// Ƥ2٥󥯥롼ɤƤס


// -----
// The vertex of the substation V-I characteristics curve.
// ŽޤޤʤΥǡ.
// -----
struct subchar
{
  double teta ; 	// ޲ѿ
  double volt ; 	// Ű
  double ampere ;	// ή

  double voltlow ;	// ȥѿΤȤŰ
  double amplow ;	// ȥѿΤȤή

  subchar () ;
  subchar ( const TiXmlNode * ) ;
} ;


// Žǡ
class sschar
  : public vector < subchar > ,
    public readdata
{

public :

// ѿ

// ʲѿ cs_command = Ea_cvauto0 ξˤΤͭ
// ɬǡեˤϵ롣ϥץԹ
  double ar ;  	// Žή
  double isl ;  	// Žήʲʤ[pu]
  double isc ;  	// Žήʾʤ׷ٲ[pu]
  double ism ;  	// Žή[pu]

  bool already_set ;

// ؿ

private :
  void membercopy ( const sschar & ) ;		// Хԡ

public :

  // 󥹥ȥ饯
  sschar () : vector < subchar > ()
  { ar = isl = isc = ism = 0 ;	already_set = false ; }

  // destructor ϰۤѰդΤѤʤ

  sschar ( const sschar & ) ;      	// X(X&)
  sschar & operator= ( const sschar & ) ; 	// 

  // եɤ߹
  int readfile ( FILE * , char * ) ;
  int readxml_vichars ( const TiXmlNode * ) ;
  int readxml_ratedcurrent ( const TiXmlNode * ) ;

  const subchar & operator[] ( sschar :: size_type i ) const {
    try
    {
      return at ( i ) ;
    }
    catch ( std :: out_of_range )
    {
      cerr << "Error: subscript out of range (sschar)" << endl ;
      exit ( 26 ) ;
    }
  }

  subchar & operator[] ( sschar :: size_type i ) {
    return const_cast < subchar & >
      ( static_cast < const sschar * > ( this ) -> operator[] ( i ) ) ;
  }
} ;


// Ž³ǡ
struct feedpos
{
  int nfline ;	// ֹ
  int csno ;	// Ž꡿ξֹ
  double pos ;	// ΰ
  double sttimp ;	// ¦(pos )ԡ
  double endimp ;	// ¦(pos 礭)ԡ
} ;


// Ž³ǡŽ¦ͭ
struct ssfeedconnect
{
  int nfline ;	// ֹ
  int csno ;	// Ž꡿ξֹ
  double pos ;	// Position of the connection
  double sttcurr ;	// ¦(pos )ή
  double sttenrgy ;	// ¦(pos )Υͥ륮
  double sttpeak ;	// ¦(pos )Υԡή
  double sttnpeak ;	// ¦(pos )Υԡή
  double sttpower [ 2 ] ;
  double endcurr ;	// ¦(pos 礭)ή
  double endenrgy ;	// ¦(pos 礭)ؤΥͥ륮
  double endpeak ;	// ¦(pos 礭)Υԡή
  double endnpeak ;	// ¦(pos 礭)Υԡή
  double endpower [ 2 ] ;

  ssfeedconnect () ;	// 󥹥ȥ饯ǥեͤ
  ~ssfeedconnect () {}	// destructor
  ssfeedconnect ( ssfeedconnect const & ) ;	// X(X&)
  ssfeedconnect & operator= ( ssfeedconnect const & ) ;	// Ʊ͡
  ssfeedconnect ( feedpos const & ) ;	// ΤʤΤ
  ssfeedconnect & operator= ( feedpos const & ) ;	// Ʊ

private :
  void membercopy ( ssfeedconnect const & ) ;

} ;



// Ž³ǡ
// readdata ɬפʤ
class sscon
  : public vector < ssfeedconnect >
{
public :

  sscon () : vector < ssfeedconnect > () {}	// 󥹥ȥ饯
  // destructor ϰۤѰդΤѤʤ

  sscon ( const sscon & x ) : vector < ssfeedconnect > ( x ) {}	// X(X&)

  const ssfeedconnect & operator[] ( sscon :: size_type i ) const {
    try
    {
      return at ( i ) ;
    }
    catch ( std :: out_of_range )
    {
      cerr << "Error: subscript out of range (sscon)" << endl ;
      exit ( 26 ) ;
    }
  }

  ssfeedconnect & operator[] ( sscon :: size_type i ) {
    return const_cast < ssfeedconnect & >
      ( static_cast < const sscon * > ( this ) -> operator[] ( i ) ) ;
  }

  sscon :: size_type number () const { return size () ; }
  sscon & operator+= ( ssfeedconnect const & x )
  { push_back ( x ) ; return * this ; }
} ;



// -----
// Class expressing electric characteristics
// As base class, it is a substation.
// ŵŪǡȴؿʴܥ饹
// ƳФʤСŽǡ
// -----
class elecchar
  : public ElectricChars
{
                	
// ѿ

private :

  sschar subc ; 	// Žǡ
  sscon ssfeedcon ;	// Ž³ǡ

  double subcntl ;	// Žѿ01δ֤ͤȤ餻

  // -----
  // Store substation control variable. Used by the tag <subchar_vi_file>
  // upon initialisation. Defaults to zero.
  // Žѿ¸롣 <subchar_vi_file> ˤ
  // . ǥեȤϥ.
  // -----
  Substation_Control_VI_TS * scvits ;

  // -----
  // Energy storage system at a substation. Defaulted to an instance of class
  // No_ESS_Substation.
  // Ž֤Υͥ륮֡ǥեȤ No_ESS_Substation
  // 饹Υ󥹥󥹡
  // -----
  ESS_Substation * sub_ess ;

  string name_utf8 ;
  string name_sjis ;

  // -----
  // If true then suppress output to CSV file.
  // ⤷ʤ CSV եؤνϤ롣
  // -----
  bool suppress_csv ;

protected :

// ׻ˤ
  double ccv ;		// Cc
  double clv ;		// Cl

  cs_mode mode ; 	// ֥⡼
  double tt ;   	// ޲ѿ
  double v ;    	// ³Ű
  double a ;    	// ³ή
  double a_conv ;    	// ³ήΤѴʬŽΤߡ
  double aax ;  	// ³ήΤ䵡ʬ
  double v_old ;	// ³ŰθŤ
  double a_old ;	// ³ήθŤ
  double a_conv_old ;	// ³ѴʬήθŤ͡ŽΤߡ
  double tt_old ;	// ޲ѿθŤ
  double dv ;   	// Űʬ
  double di ;   	// ήʬ
  double di_conv ;   	// ήʬͤΤѴʬŽΤߡ
  double diax ; 	// ήʬͤΤ䵡ʬ
  double cmd_main ;	// ϩ
  double amx ;  	// ԡή ()
  double amy ;  	// ԡή ()
  double voltpeak ;	// Űԡʺǹ
  double voltbottom ;	// Űܥȥʺ
  bool sw_voltpeak ;	// ŰԡܥȥͤνͥåȤ false
  double enrgy ;	// Žϥͥ륮
  double renrgy ;	// Žβͥ륮
  double pwr [ 2 ] ;	// enrgy б
  double rpwr [ 2 ] ;	// renrgy б

// ʸѹʤ
  cs_command ccmd ; 	// ͤμ
  int csno ;    	// Žֹġĳ

// ؿ

private :

  // -----
  // Copying members.
  // Хԡ
  // -----
  void membercopy ( const elecchar & ) ;

  // -----
  // The subprogram of teta_vi, which actually is the "original" part of the
  // function that processes the "core" jobs.
  // teta_vi Υ֥ץࡣΡ֥ꥸʥʡץѡȤǡλŻ
  // ʬ
  // -----
  void teta_vi_core () ;

  // -----
  // The subprogram of teta_vi, which does ESS-related tasks.
  // teta_vi Υ֥ץࡣͥ륮֤ߤλŻ򤹤롣
  // -----
  void teta_vi_ESS () ;

public :
  elecchar () ;	// Default constructor

  elecchar ( const elecchar & ) ;	// X(X&)
  elecchar & operator= ( const elecchar & ) ;	// 

  double cc () { return ccv ; }	// Cc
  double cl () { return clv ; }	// Cl
  double & teta () { return tt ; }	// ޲ѿؤλ
  double & volt () { return v ; }	// Űؤλ
  double & ampere () { return a ; }	// ήؤλ
  double & dvi () { return dv ; }	// Űʬͤؤλ
  double & dii () { return di ; }	// ήʬͤؤλ
  virtual double & gva () { return v ; }	// ¦ѿŰ
  virtual double & uva () { return a ; }	// ̤¦ѿή
  virtual double & dgva () { return dv ; }	// ¦ʬ͡Ű
  virtual double & duva () { return di ; }	// ̤¦ʬ͡ή

  const double volt () const { return v ; }	// Űؤλ
  const double ampere () const { return a ; }	// ήؤλ

  virtual bool getSuppressCSVFlag () const { return suppress_csv ; }

  // -----
  // Output to CSV file. Boolean argument: suppress leading comma if false.
  // CSVեؤν. Ͱ: ʤ饫ޤνϤ
  // -----
  virtual bool writeHeaderToCSV ( ostream & , bool = true ) const ;
  virtual bool writeToCSV ( ostream & , bool = true ) const ;

  const string & getNameInUTF8 () const { return name_utf8 ; }
  const string & getNameInSJIS () const { return name_sjis ; }

  double & energy () { return enrgy ; }
  double & renergy () { return renrgy ; }
  double * power () { return pwr ; }
  double * rpower () { return rpwr ; }

  void setcsno ( int x ) { csno = x ; }	// ŽֹΥå

  // -----
  // Renew the electrical state variables.
  // ŵŪѿ򹹿
  // -----
  void renewElectricalStates () ;


  // -----
  // Calculate voltage and current of the ESD
  // -----
  void calculateESDVoltageAndCurrent () ;

  // -----
  // SOC-related initialisation upon start of the simulation cycle.
  // -----
  void setStartSOC () { sub_ess -> setStartSOC () ; }

  // -----
  // Typing out SOC-related data to the RES file.
  // -----
  void printSOCStoredResults
  ( ostream & x , ostringstream & y , ostringstream & z ) const
  { sub_ess -> printSOCStoredResults ( x , y , z ) ; }

  // -----
  // Recording and restoring of the old voltage and current values
  // ŤŰήͤεϿȺ
  // -----
  virtual void setviold ()
  { v_old = v ; a_old = a ; tt_old = tt ; a_conv_old = a_conv ; }
  virtual void restorevi ()
  { v = v_old ; a = a_old ; tt = tt_old ; a_conv = a_conv_old ; }

  virtual void teta_vi () ; 	// teta  volt, ampere ؤѴ
  virtual void add_to_teta ( double , bool ) ; // teta ˲ä

  // Ž³ǡ
  sscon & feedcon () { return ssfeedcon ; }
  const sscon & feedcon () const { return ssfeedcon ; }

  void setpeak () ;			// ԡήŰͤΥå
  double peakcur () { return amx ; }	// ԡή֤ͤ
  double npeakcur () { return amy ; }	// ԡή֤ͤ
  double peakvolt () { return voltpeak ; }	// ǹŰ֤ͤ
  double bottomvolt () { return voltbottom ; }	// Ű֤ͤ

  void setsubcntl ( double ) ;		// subcntl å
  void addtosubcntl ( double ) ;	// subcntl å
  double getsubcntl () { return subcntl ; }	// subcntl å

  void cccl () ;	// Cc, Cl η׻

  // ή: ֹ桤ήͤ
  // ΡɤȯǤʤȡġĤȤꤢ warning Ф
  // ¦: branch ǤϽ¦
  void directional_curr_start ( int , double , double ) ;

  // ή: ֹ桤ήͤ
  // ΡɤȯǤʤȡġĤȤꤢ warning Ф
  // ¦: branch Ǥϵ¦
  void directional_curr_end ( int , double , double ) ;

  // ե꡼: 
  int readfile ( FILE * fl , char * fls )
  { return subc . readfile ( fl , fls ) ; }

  // ե꡼: 
  int readfile_xml ( const TiXmlNode * tn_in ) ;
} ;

#endif /* ! ___ELECCHAR_HH */
