// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Prof. SONE's Laboratory, the Univ. of Tokyo.)
// rtsscmds.hh --- header file that defines command lists
// $Id: rtsscmds.hh,v 2.4 1994/12/27 12:03:47 rt Exp $

#ifndef ___RTSSCMDS_HH
#define ___RTSSCMDS_HH

#include <cstring>

enum commandvalue {	// ޥɡե饰ꥹ

    // N Flags
    STATION_OBJECT_VALID,	// Ϥͭ, h_file ɤ߹
    CONGES_STATION,		// ΨؤȤѹ
    ONTPREC_DELAY_SET,		// ontprec åȽ٤
    STARTSTOP_PARAMETER,	// شԻʬѹ
    ONTPREC,			// Υåհַ׻٥С
    INITIALDEPARTURETIME,	// tdept  trainvar ޥɤǻ

    // N Commands in feeder::rf_nfile()
    PATTERNS,		// ѥ

    // N Commands in diapattern::readfile()
    NEXTSTA,		// nextsta ֥Ȥο
    CYCLETIME,		// ѥ1ʬλ
    PHASE,		// 
    CARS,		// ֿ
    PATTERNCIRC,	// ѥܿ
    TRAINVAR,		// ֤Ϳ
    TRAINDATA,		// ֤η

    // N Commands in nextsta::readfile()
    STARTPOINT,			// 
    ENDPOINT,			// λ
    ENDVELOCITY,		// إǡλǤ®
    NEXTNXX,			// ǡܹ
//     STATION_OBJECT_NUMBER,	// бإֹ֥ -> H Cmds.
    STARTSTOPTIME,		// شԻʬ
    STATIONSTOP,		// ֻ
    NOTCHOFF,			// Υå®
    DIREC,			// ֿʹʲ = 1
    NFLINE,			// ֹ
    CONGESTION,			// ֤ǤֺΨ
    NEXTSTA_PATTERN,		// إǡΥ
    GRADCRVNUMBER,		// gradcrv ޥɤο
    GRADCRV,			// gradcrv ֹ

    // H Flags
    STOPORIENTED,		// ش߻ظ
    STATIONSTOP_VARIATION_TYPE_A,	// ֻʬưʶʸס

    // H Commands in station_obj::readfile()
    STATION_OBJECT_NUMBER,	// station_obj ο
    IOLINENUMBER,		// niolno
    TRACKNUMBER,		// nvoie
    STATION_OBJECT_TYPE,	// stnobjtype
    STOP_OUT_OF_STATION,	// stop_out_of_station
    DEPART_ARRIVAL,		// ȯָ弡ޤ
    ARRIVAL_DEPART,		// 弡ȯ֤ޤ
    ARRIVAL_ARRIVAL,		// 弡ޤ
    DEPART_DEPART,		// ȯָ弡ȯ֤ޤ
    DEPART_PASS,		// ȯָ弡̲ޤ
    ARRIVAL_PASS,		// 弡̲ޤ
    PASS_ARRIVAL,		// ̲弡ޤ
    PASS_DEPART,		// ̲弡ȯ֤ޤ
    PASS_PASS,			// ̲弡̲ޤ

    // H Commands in
    // station_obj_stationstop_variation::readfile_additional_readfile()
    DISTURBANCE,		// ֤٤餻뤫ݤ
    DISTURBANCE_TIME,		// ֤٤餻
    CONTROL_DISTURBANCE_TYPE,	// μ
    CONTROL_STATION_OBJ_NUMBER,	// оݤ station_obj ֹ
    CONTROL_STATION_OBJ_VALUE,	//  []
    CONTROL_STATION_OBJ_TIME,	// 򤫤 []

    END_OF_DATA		// ǡλؼ

};
    
struct commandlist {		// ޥɥꥹ
  commandvalue cmdval ;		// б enum 
  char const * cmdname ; 	// ޥɤ̾
} ;

#ifndef __GLOB_MAIN_ROUTINE

extern commandlist comlist [] ;
extern int comnum ;

int sortcommands ( const void * kvl , const void * dvl ) ;

#else

commandlist comlist [] = {

    // N Flags
    { STATION_OBJECT_VALID, "station_object_valid" },
    { CONGES_STATION, "conges_station" },
    { ONTPREC_DELAY_SET, "ontprec_delay_set" },
    { STARTSTOP_PARAMETER, "startstop_parameter" },
    { ONTPREC, "ontprec" },
    { INITIALDEPARTURETIME, "initialdeparturetime" },

    // N Commands in feeder::rf_nfile()
    { PATTERNS, "patterns" },

    // N Commands in diapattern::readfile()
    { NEXTSTA, "nextsta" },
    { CYCLETIME, "cycletime" },
    { PHASE, "phase" },
    { CARS, "cars" },
    { PATTERNCIRC, "patterncirc" },
    { TRAINVAR, "trainvar" },
    { TRAINDATA, "traindata" },

    // N Commands in nextsta::readfile()
    { STARTPOINT, "startpoint" },		// 
    { ENDPOINT, "endpoint" },			// λ
    { ENDVELOCITY, "endvelocity" },		// إǡλǤ®
    { NEXTNXX, "nextnxx" },			// ǡܹ
    { STARTSTOPTIME, "startstoptime" },		// شԻʬ
    { STATIONSTOP, "stationstop" },		// ֻ
    { NOTCHOFF, "notchoff" },			// Υå®
    { DIREC, "direc" },				// ֿʹʲ = 1
    { NFLINE, "nfline" },			// ֹ
    { CONGESTION, "congestion" },		// ֤ǤֺΨ
    { NEXTSTA_PATTERN, "nextsta_pattern" },	// إǡΥ
    { GRADCRVNUMBER, "gradcrvnumber" },		// gradcrv ޥɤο
    { GRADCRV, "gradcrv" },			// gradcrv ֹ

    // H Flags
    { STOPORIENTED, "stoporiented" },	// ش߻ظ
    { STATIONSTOP_VARIATION_TYPE_A, "stationstop_variation_type_a" },

    // H Commands in station_obj::readfile()
    { STATION_OBJECT_NUMBER, "station_object_number" },	// station_obj ο
    { IOLINENUMBER, "iolinenumber" },			// niolno
    { TRACKNUMBER, "tracknumber" },			// nvoie
    { STATION_OBJECT_TYPE, "station_object_type" },	// stnobjtype
    { STOP_OUT_OF_STATION, "stop_out_of_station" },	// out_of_station
    { DEPART_ARRIVAL, "depart_arrival" },	// ȯָ弡ޤ
    { ARRIVAL_DEPART, "arrival_depart" },	// 弡ȯ֤ޤ
    { ARRIVAL_ARRIVAL, "arrival_arrival" },	// 弡ޤ
    { DEPART_DEPART, "depart_depart" },		// ȯָ弡ȯ֤ޤ
    { DEPART_PASS, "depart_pass" },		// ȯָ弡̲ޤ
    { ARRIVAL_PASS, "arrival_pass" },		// 弡̲ޤ
    { PASS_ARRIVAL, "pass_arrival" },		// ̲弡ޤ
    { PASS_DEPART, "pass_depart" },		// ̲弡ȯ֤ޤ
    { PASS_PASS, "pass_pass" },			// ̲弡̲ޤ

    // H Commands in
    // station_obj_stationstop_variation::readfile_additional_readfile()
    { DISTURBANCE, "disturbance" },		// ֤٤餻
    { DISTURBANCE_TIME, "disturbance_time" },	// ֤٤餻
    { CONTROL_DISTURBANCE_TYPE,	"control_disturbance_type" },
    { CONTROL_STATION_OBJ_NUMBER, "control_station_obj_number" },
    { CONTROL_STATION_OBJ_VALUE, "control_station_obj_value" },
    { CONTROL_STATION_OBJ_TIME, "control_station_obj_time" },
 
    // End of Data
    { END_OF_DATA, "" }
} ;

int comnum = 0;

int sortcommands
( const void* kvl, const void* dvl ) {
    return strcmp( ( ( commandlist* ) kvl ) -> cmdname,
                   ( ( commandlist* ) dvl ) -> cmdname );
}

#endif /* __GLOB_MAIN_ROUTINE */

#endif /* ! ___RTSSCMDS_HH */
