// -- This may look like C code, but it's really C++ --
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// trd_rf.cc --- readfile function in class traindata
// -----
// ChangeLog:
// 2007. 11. 22
//  Redirected log messages to l_file.
// -----

#include <cstdio>
#include <sstream>
#include <iomanip>

#include "train.hh"
#include "EnergyStorage.hh"

using std :: fixed ;
using std :: ostringstream ;
using std :: setprecision ;
using std :: scientific ;




// ----
// A trick for reading <powerdata> or <brakedata> in an XML file.
// XML ե <powerdata> ޤ <brakedata> ɤिˡ
// ----
string const _POWERDATA_TAG = "<powerdata>" ;
string const _BRAKEDATA_TAG = "<brakedata>" ;

string const &
_pb_tag_str
( bool x )
{
  if ( x )
  {
    return _POWERDATA_TAG ;
  }
  else
  {
    return _BRAKEDATA_TAG ;
  }
}



// ----
// Reading P-file (train performance data).
// ֥ǡΥե꡼ (Pե)
// ----
void
traindata :: readfile_xml
( TiXmlNode const * tn_in ,
  string const & _err ,
  bool _is_rheo_in ,
  double _changeover_speed_band_in )
{
  // ----
  // Setting _is_rheo, _has_changeover, _changeover_speed_band in p and b.
  // ----
  p . _is_rheo = b . _is_rheo = _is_rheo_in ;
  p . _changeover_speed_band = b . _changeover_speed_band
    = _changeover_speed_band_in ;

  // -----
  // Getting child element(s) of tag <train_data_set>, which is in XML-ised
  // P file.
  //  <train_flag>: As many appearances as are required, can be omitted. Must
  //  appear in front of all other tags.
  //  <cs_command>: One must appear after <train_flag> tags. Cannot be
  //  omitted.
  //  <powerdata>, <brakedata>, <congestion>, <auxiliary_load>, <weight_data>,
  //  <davis_coefficients>, <curve_resistance_coefficient>,
  //  <rolling_mass_coefficient>, <deceleration>, <cars_in_trainset>: Each one
  //  of them must appear after the <cs_command> tag. Cannot be omitted.
  //  <autodata>: Up to one appearance after the <cs_command> tag. Can be
  //  omitted.
  // -----
  bool flag_ended = false ;
  bool cs_command_ended = false ;
  bool sw_power , sw_brake , sw_auto , sw_cong , sw_auxc , sw_crc , sw_rmc ;
  bool sw_dec , sw_cit , sw_setw , sw_setr , sw_energystorage ;
  sw_power = sw_brake = sw_auto = sw_cong = sw_auxc = sw_crc = sw_rmc
    = sw_dec = sw_cit = sw_setw = sw_setr = sw_energystorage = false ;
  for ( TiXmlNode const * _tc = tn_in -> FirstChild () ;
        _tc ; _tc = _tc -> NextSibling () )
  {
    // -----
    // Ignore non-Element node.
    // Ȱʳ̵롣
    // -----
    if ( _tc -> Type () != TiXmlNode :: TINYXML_ELEMENT )
    {
      continue ;
    }

    // -----
    // Check tag name.
    // ̾å
    // -----
    string _tc_v = _tc -> ValueStr () ;
    if ( _tc_v == "train_flag" )
    {
      // -----
      // If flag processing has ended, quit.
      // ե饰λƤʤ¹Ԥߡ
      // -----
      if ( flag_ended )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Flag in wrong position." << endl ;
        exit ( 1 ) ;
      }
      
      // -----
      // Processing <train_flag> tag.
      // (1) Getting name attribute for <train_flag>.
      // (2) Setting corresponding boolean variable.
      // <train_flag> .
      // (1) <train_flag>  name °.
      // (2) ط bool ѿ򥻥åȤ롣
      // -----
      TiXmlAttribute const * _tc_a
        = _tc -> ToElement () -> FirstAttribute () ;
      bool sw_name_found = false ;
      while ( _tc_a )
      {
        if ( string ( _tc_a -> Name () ) == "name" )
        {
          // Attribute "name"
          string flag_name = _tc_a -> ValueStr () ;
          _tc_a = _tc_a -> Next () ;
          if ( sw_name_found )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate appearance of attribute name in <train_flag>?"
                 << endl ;
            exit ( 1 ) ;
          }
          sw_name_found = true ;
          if ( flag_name == "differentregend" )
          {
            if ( sw_different_regend )
            {
              sw_different_regend = false ;
              l_ofs << "OK, toggled sw_different_regend to false" << endl ;
            }
            else
            {
              sw_different_regend = true ;
              l_ofs << "OK, toggled sw_different_regend to true" << endl ;
            }
          }
          else if ( flag_name == "auxpower" )
          {
            if ( sw_aux_power )
            {
              sw_aux_power = false ;
              l_ofs << "OK, toggled sw_aux_power to false" << endl ;
            }
            else
            {
              sw_aux_power = true ;
              l_ofs << "OK, toggled sw_aux_power to true" << endl ;
            }
          }
          else if ( flag_name == "torque_shibori" )
          {
            if ( sw_torque_shibori )
            {
              sw_torque_shibori = false ;
              l_ofs << "OK, toggled sw_torque_shibori to false" << endl ;
            }
            else
            {
              sw_torque_shibori = true ;
              l_ofs << "OK, toggled sw_torque_shibori to true" << endl ;
            }
          }
          else if ( flag_name == "shiboriparallel" )
          {
            if ( sw_shibori_parallel )
            {
              sw_shibori_parallel = false ;
              l_ofs << "OK, toggled sw_shibori_parallel to false" << endl ;
            }
            else
            {
              sw_shibori_parallel = true ;
              l_ofs << "OK, toggled sw_shibori_parallel to true" << endl ;
            }
          }
          else if ( flag_name == "regendantei" )
          {
            if ( sw_regenoffantei )
            {
              sw_regenoffantei = false ;
              l_ofs << "OK, toggled sw_regenoffantei to false" << endl ;
            }
            else
            {
              sw_regenoffantei = true ;
              l_ofs << "OK, toggled sw_regenoffantei to true" << endl ;
            }
          }
          else if ( flag_name == "anteimotor" )
          {
            if ( sw_anteimotor )
            {
              sw_anteimotor = false ;
              l_ofs << "OK, toggled sw_anteimotor to false" << endl ;
            }
            else
            {
              sw_anteimotor = true ;
              l_ofs << "OK, toggled sw_anteimotor to true" << endl ;
            }
          }
        }
        else
        {
          cerr << "Error parsing " << _err << ":" << endl
               << " Attribute " << _tc_a -> Name ()
               << " for <train_flag> tag not allowed" << endl ;
          exit ( 1 ) ;
        }
      }
    } // tag <train_flag>
    else if ( _tc_v == "cs_command" )
    {
      // -----
      // If flag processing has ended, quit.
      // ե饰λƤʤ¹Ԥߡ
      // -----
      if ( flag_ended )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Tag <cs_command> in wrong position." << endl ;
        exit ( 1 ) ;
      }
      flag_ended = true ;
      if ( cs_command_ended )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Tag <cs_command> in wrong position." << endl ;
        exit ( 2 ) ;
      }
      cs_command_ended = true ;

      // -----
      // Processing <cs_command> tag.
      // (1) Getting type attribute for <train_flag>.
      // (2) Setting corresponding enum variable.
      // <cs_command> .
      // (1) <cs_command>  type °.
      // (2) ط enum ѿ򥻥åȤ롣
      // -----
      TiXmlAttribute const * a_csc
        = _tc -> ToElement () -> FirstAttribute () ;
      bool sw_csc_found = false ;
      while ( a_csc )
      {
        if ( string ( a_csc -> Name () ) == "type" )
        {
          // Attribute "type"
          string csc_name = a_csc -> ValueStr () ;
          a_csc = a_csc -> Next () ;
          if ( sw_csc_found )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate appearance of attribute type in <cs_command>?"
                 << endl ;
            exit ( 1 ) ;
          }
          sw_csc_found = true ;
          if ( csc_name == "None" )
          {
            ccx = None ;
            sw_auto = true ;
          }
          else if ( csc_name == "Ec_auto" )
          {
            ccx = Ec_auto ;
          }
          else if ( csc_name == "Ea_cvauto0" )
          {
            ccx = Ea_cvauto0 ;
          }
          else if ( csc_name == "Const_volt" )
          {
            ccx = Const_volt ;
          }
          else if ( csc_name == "Const_power" )
          {
            ccx = Const_power ;
          }
          else if ( csc_name == "Torque_keisu" )
          {
            ccx = Torque_keisu ;
          }
          else
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " " << csc_name
                 << " not allowed as type in <cs_command>." << endl ;
            exit ( 1 ) ;
          }
        }
      }
    } // tag <cs_command>
    else if ( _tc_v == "powerdata" || _tc_v == "brakedata" )
    {
      // -----
      // If flag processing has ended, quit.
      // ե饰λƤʤʤ¹Ԥߡ
      // -----
      if ( ! ( flag_ended && cs_command_ended ) )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Tag <powerdata> or <brakedata> in wrong position." << endl ;
        exit ( 1 ) ;
      }

      bool sw_iampower ;
      if ( _tc_v == "powerdata" )
      {
        if ( sw_power )
        {
          cerr << "Error parsing " << _err << ":" << endl
               << " Tag <powerdata> appearing twice?" << endl ;
          exit ( 1 ) ;
        }
        sw_iampower = sw_power = true ;
        l_ofs << endl << "** Train Characteristics **" << endl
              << "Powerdata:" << endl ;
      }
      else
      {
        if ( sw_brake )
        {
          cerr << "Error parsing " << _err << ":" << endl
               << " Tag <brakedata> appearing twice?" << endl ;
          exit ( 1 ) ;
        }
        sw_brake = true ;
        sw_iampower = false ;
        l_ofs << endl << "** Train Characteristics **" << endl
              << "Brakedata:" << endl ;
      }

      bool sw_rheo = ! _is_rheo_in ;
      bool sw_ec , sw_zc , sw_miv , sw_bmv , sw_rege , sw_regx ;
      bool sw_mav , sw_regs , sw_emp , sw_mid , sw_ful ;
      sw_ec = sw_zc = sw_miv = sw_bmv = sw_mav = sw_emp = sw_mid = sw_ful
        = false ;

      // Ϲԥǡˤ
      sw_regs = sw_rege = sw_regx = sw_iampower ;

      if ( ! sw_different_regend )	// ΤȤ
      {
        sw_rege = true ;
      }
      
      if ( ! sw_regenoffantei )
      {
        // ϤΤȤ
        sw_regx = true ;
      }
      else
      {
        b . regendantei = 0.0 ;
      }
      double x_pb ;

      // -----
      // Processing <powerdata>, <brakedata> tag.
      // (1) Getting attribute for <train_flag>.
      // (2) Setting corresponding variable.
      // <powerdata>, <brakedata> .
      // (1) <powerdata>, <brakedata> °.
      // (2) طѿ򥻥åȤ롣
      // -----
      TiXmlAttribute const * a_pb
        = _tc -> ToElement () -> FirstAttribute () ;
      while ( a_pb )
      {
        if ( string ( a_pb -> Name () ) == "ec" )
        {
          // Attribute "ec"
          if ( sw_ec )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate appearance of attribute ec in "
                 << _pb_tag_str ( sw_iampower ) << "." << endl ;
            exit ( 1 ) ;
          }
          sscanf ( a_pb -> Value () , "%lf" , & x_pb ) ;
          ostringstream o_ec ;
          o_ec << fixed << setprecision ( 1 ) << x_pb ;
          if ( sw_iampower )
          {
            p . ec = x_pb ;
            l_ofs << "p.ec = " << o_ec . str () << endl ;
          }
          else
          {
            b . ec = x_pb ;
            l_ofs << "b.ec = " << o_ec . str () << endl ;
          }
          sw_ec = true ;
          a_pb = a_pb -> Next () ;
        }
        else if ( string ( a_pb -> Name () ) == "zero_velocity_current"
                  || string ( a_pb -> Name () ) == "regen_off_velocity" )
        {
          // Attribute "zero_velocity_current" (formerly zerocur)
          // Attribute "regen_off_velocity" (formerly regenoff)
          if ( sw_zc )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate appearance of attribute " ;
            if ( sw_iampower )
            {
              cerr << "zero_velocity_current" ;
            }
            else
            {
              cerr << "regen_off_velocity" ;
            }
            cerr << " in " << _pb_tag_str ( sw_iampower ) << "." << endl ;
            exit ( 1 ) ;
          }
          sscanf ( a_pb -> Value () , "%lf" , & x_pb ) ;
          if ( string ( a_pb -> Name () ) == "zero_velocity_current" )
          {
            if ( ! sw_iampower )
            {
              cerr << "Error parsing " << _err << ":" << endl
                   << " zero_velocity_current must not appear in <brakedata>"
                   << endl ;
              exit ( 1 ) ;
            }
            ostringstream o_zc ;
            o_zc << fixed << setprecision ( 1 ) << ( p . zerocur = x_pb ) ;
            l_ofs << "p.zerocur = " << o_zc . str () << endl ;
          }
          else
          {
            if ( sw_iampower )
            {
              cerr << "Error parsing " << _err << ":" << endl
                   << " regen_off_velocity must not appear in <powerdata>"
                   << endl ;
              exit ( 1 ) ;
            }
            ostringstream o_ro ;
            o_ro << fixed << setprecision ( 2 ) << ( b . regenoff = x_pb ) ;
            l_ofs << "b.regenoff = " << o_ro . str () << endl ;
          }
          sw_zc = true ;
          a_pb = a_pb -> Next () ;
        }
        else if ( string ( a_pb -> Name () ) == "has_changeover" )
        {
          // Attribute "has_changeover" (powerdata only)
          if ( ! _is_rheo_in || ! sw_iampower )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Attribute \"has_changeover\" not allowed in "
                 << _pb_tag_str ( sw_iampower ) << "." << endl ;
            exit ( 1 ) ;
          }
          if ( sw_rheo )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate appearance of attribute "
                 << "\"has_changeover\" in "
                 << _pb_tag_str ( sw_iampower ) << "." << endl ;
            exit ( 1 ) ;
          }
          string _atc = a_pb -> ValueStr () ;
          if ( _atc  == "true" || _atc == "True" || _atc == "t" || _atc == "T"
               || _atc == "TRUE" || _atc == "Y" || _atc == "yes"
               || _atc == "y" || _atc == "YES" )
          {
            p . _has_changeover = true ;
            l_ofs << "p . _has_changeover set to true" << endl ;
          }
          else if ( _atc  == "false" || _atc == "False" || _atc == "f"
                    || _atc == "F" || _atc == "FALSE" || _atc == "N"
                    || _atc == "no" || _atc == "n" || _atc == "NO" )
          {
            p . _has_changeover = false ;
            l_ofs << "p . _has_changeover set to false" << endl ;
          }
          else
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Attribute \"has_changeover\" with invalid value in "
                 << _pb_tag_str ( sw_iampower ) << ":" << endl
                 << "  (value = \"" << _atc << "\")" << endl ;
            exit ( 1 ) ;
          }
          sw_rheo = true ;
          a_pb = a_pb -> Next () ;
        }
        else if ( string ( a_pb -> Name () )
                  == "rheostatic_regen_off_velocity" )
        {
          // Attribute "rheostatic_regen_off_velocity" (brakedata only)
          if ( ! _is_rheo_in || sw_iampower )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Attribute \"rheostatic_regen_off_velocity\" not allowed"
                 << " in " << _pb_tag_str ( sw_iampower ) << "." << endl ;
            exit ( 1 ) ;
          }
          if ( sw_rheo )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate appearance of attribute "
                 << "\"rheostatic_regen_off_velocity\" in "
                 << _pb_tag_str ( sw_iampower ) << "." << endl ;
            exit ( 1 ) ;
          }
          sw_rheo = true ;
          sscanf ( a_pb -> Value () , "%lf" , & x_pb ) ;
          b . _rheostatic_regen_off_velocity = x_pb ;
          ostringstream _os_rrov ;
          _os_rrov << fixed << setprecision ( 2 )
                   << b . _rheostatic_regen_off_velocity ;
          l_ofs << "b . _rheostatic_regen_off_velocity = "
                << _os_rrov . str () << endl ;
          a_pb = a_pb -> Next () ;
        }
        else if ( string ( a_pb -> Name () ) == "minimum_voltage" )
        {
          // Attribute "minimum_voltage" (formerly minimumvoltage)
          if ( sw_miv )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate appearance of attribute minimum_voltage"
                 << " in " << _pb_tag_str ( sw_iampower ) << "." << endl ;
            exit ( 1 ) ;
          }
          sscanf ( a_pb -> Value () , "%lf" , & x_pb ) ;
          ostringstream o_mv ;
          o_mv << fixed << setprecision ( 1 ) << x_pb ;
          if ( sw_iampower )
          {
            p . minvol = x_pb ;
            l_ofs << "p.minvol = " << o_mv . str () << endl ;
          }
          else
          {
            b . minvol = x_pb ;
            l_ofs << "b.minvol = " << o_mv . str () << endl ;
          }
          sw_miv = true ;
          a_pb = a_pb -> Next () ;
        }
        else if ( string ( a_pb -> Name () ) == "practical_lowest_voltage" )
        {
          // Attribute "practical_lowest_voltage" (formerly bminvoltage)
          if ( sw_bmv )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate appearance of attribute "
                 << "practical_lowest_voltage in "
                 << _pb_tag_str ( sw_iampower ) << "." << endl ;
            exit ( 1 ) ;
          }
          sscanf ( a_pb -> Value () , "%lf" , & x_pb ) ;
          ostringstream o_bmv ;
          o_bmv << fixed << setprecision ( 1 ) << x_pb ;
          if ( sw_iampower )
          {
            p . bminvol = x_pb ;
            l_ofs << "p.bminvol = " << o_bmv . str () << endl ;
          }
          else
          {
            b . bminvol = x_pb ;
            l_ofs << "b.bminvol = " << o_bmv . str () << endl ;
          }
          sw_bmv = true ;
          a_pb = a_pb -> Next () ;
        }
        else if ( string ( a_pb -> Name () ) == "maximum_voltage" )
        {
          // Attribute "maximum_voltage" (formerly bminvoltage)
          if ( sw_mav )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate appearance of attribute maximum_voltage"
                 << " in " << _pb_tag_str ( sw_iampower ) << "." << endl ;
            exit ( 1 ) ;
          }
          sscanf ( a_pb -> Value () , "%lf" , & x_pb ) ;
          ostringstream o_mav ;
          o_mav << fixed << setprecision ( 1 ) << x_pb ;
          if ( sw_iampower )
          {
            p . maxvol = x_pb ;
            l_ofs << "p.maxvol = " << o_mav . str () << endl ;
          }
          else
          {
            b . maxvol = x_pb ;
            l_ofs << "b.maxvol = " << o_mav . str () << endl ;
          }
          sw_mav = true ;
          a_pb = a_pb -> Next () ;
        }
        else if ( string ( a_pb -> Name () ) == "regen_limiter_start_voltage" )
        {
          // Attribute "regen_limiter_start_voltage"
          // (formerly regenlimitstartvoltage)
          if ( sw_iampower )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Must not have attribute regen_limiter_start_voltage"
                 << " in " << _pb_tag_str ( sw_iampower ) << "." << endl ;
            exit ( 1 ) ;
          }
          if ( sw_regs )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate appearance of attribute "
                 << "regen_limiter_start_voltage"
                 << " in " << _pb_tag_str ( sw_iampower ) << "." << endl ;
            exit ( 1 ) ;
          }
          sscanf ( a_pb -> Value () , "%lf" , & x_pb ) ;
          ostringstream o_bstv ;
          o_bstv << fixed << setprecision ( 1 ) << ( b . startvol = x_pb ) ;
          l_ofs << "b.startvol = " << o_bstv . str () << endl ;
          sw_regs = true ;
          a_pb = a_pb -> Next () ;
        }
        else if ( string ( a_pb -> Name () ) == "regen_limiter_end_voltage" )
        {
          // Attribute "regen_limiter_end_voltage"
          // (formerly regenlimitendvoltage)
          if ( sw_iampower )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Must not have attribute regen_limiter_end_voltage"
                 << " in " << _pb_tag_str ( sw_iampower ) << "." << endl ;
            exit ( 1 ) ;
          }
          if ( sw_rege )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate appearance of attribute "
                 << "regen_limiter_end_voltage"
                 << " in " << _pb_tag_str ( sw_iampower ) << "." << endl ;
            exit ( 1 ) ;
          }
          sscanf ( a_pb -> Value () , "%lf" , & x_pb ) ;
          ostringstream o_rev ;
          o_rev << fixed << setprecision ( 1 ) << ( b . regendvol = x_pb ) ;
          l_ofs << "b.regendvol = " << o_rev . str () << endl ;
          sw_rege = true ;
          a_pb = a_pb -> Next () ;
        }
        else if ( string ( a_pb -> Name () ) == "regen_shutdown_threshold" )
        {
          // Attribute "regen_shutdown_threshold"
          // (formerly regenoffanteika)
          if ( sw_iampower || sw_regx )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Must not have attribute regen_shutdown_threshold"
                 << " in " << _pb_tag_str ( sw_iampower ) << "." << endl ;
            exit ( 1 ) ;
          }
          sscanf ( a_pb -> Value () , "%lf" , & x_pb ) ;
          ostringstream o_rea ;
          o_rea << fixed << setprecision ( 1 ) << ( b . regendantei = x_pb ) ;
          l_ofs << "b.regendantei = " << o_rea . str () << endl ;
          sw_regx = true ;
          a_pb = a_pb -> Next () ;
        }
        else
        {
          cerr << "Error parsing " << _err << ":" << endl
               << " Attribute " << a_pb -> Name () << " for "
               << _pb_tag_str ( sw_iampower ) << "tag not allowed" << endl ;
          exit ( 1 ) ;
        }
      }
      if ( ! ( sw_ec && sw_zc && sw_miv && sw_bmv && sw_mav && sw_regs
               && sw_rege && sw_regx && sw_rheo ) )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Some attribute(s) missing in "
             << _pb_tag_str ( sw_iampower ) << "tag" << endl ;
        exit ( 1 ) ;
      }

      for ( TiXmlNode const * _de = _tc -> FirstChild () ;
            _de ; _de = _de -> NextSibling () )
      {
        // -----
        // Ignore non-Element node.
        // Ȱʳ̵롣
        // -----
        if ( _de -> Type () != TiXmlNode :: TINYXML_ELEMENT )
        {
          continue ;
        }

        // -----
        // Check tag name.
        // ̾å
        // -----
        string _de_v = _de -> ValueStr () ;

        bool sw_iamemp , sw_iammid , sw_iamful ;
        sw_iamemp = sw_iammid = sw_iamful = false ;
        if ( _de_v == "empty_data_entry" )
        {
          if ( sw_emp )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate tag <empty_data_entry> in "
                 << _pb_tag_str ( sw_iampower ) << "." << endl ;
            exit ( 1 ) ;
          }
          sw_iamemp = sw_emp = true ;
          l_ofs << "Empty:" << endl ;
        }
        else if ( _de_v == "mid_data_entry" )
        {
          if ( sw_mid )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate tag <mid_data_entry> in "
                 << _pb_tag_str ( sw_iampower ) << "." << endl ;
            exit ( 1 ) ;
          }
          sw_iammid = sw_mid = true ;
          l_ofs << "Mid:" << endl ;
        }
        else if ( _de_v == "full_data_entry" )
        {
          if ( sw_ful )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate tag <full_data_entry> in "
                 << _pb_tag_str ( sw_iampower ) << "." << endl ;
            exit ( 1 ) ;
          }
          sw_iamful = sw_ful = true ;
          l_ofs << "Full:" << endl ;
        }
        else
        {
          cerr << "Error parsing " << _err << ":" << endl
               << " Tag " << _de_v << " not allowed in "
               << _pb_tag_str ( sw_iampower ) << "." << endl ;
          exit ( 1 ) ;
        }

        pbchar pbd ;
        bool sw_cg , sw_mc , sw_hv , sw_lv , sw_tf , sw_mtc ;
        sw_cg = sw_mc = sw_hv = sw_lv = sw_tf = false ;

        // motor_current (formerly motorcurr):
        //  anteimotor ե饰Τ
        if ( ( ! sw_anteimotor ) || sw_iampower )
        {
          sw_mtc = true ;
        }
        else
        {
          sw_mtc = false ;
        }
        TiXmlAttribute const * _de_a
          = _de -> ToElement () -> FirstAttribute () ;
        while ( _de_a )
        {
          if ( string ( _de_a -> Name () ) == "congestion" )
          {
            // Attribute "congestion"
            if ( sw_cg )
            {
              cerr << "Error parsing " << _err << ":" << endl
                   << " Duplicate appearance of attribute congestion"
                   << " in " << _de_v << " of "
                   << _pb_tag_str ( sw_iampower ) << "." << endl ;
              exit ( 1 ) ;
            }
            sscanf ( _de_a -> Value () , "%lf" , & x_pb ) ;
            ostringstream o_cg ;
            o_cg << fixed << setprecision ( 2 ) << ( pbd . conges = x_pb ) ;
            l_ofs << "  conges = " << o_cg . str () << endl ;
            sw_cg = true ;
            _de_a = _de_a -> Next () ;
          }
          else if ( string ( _de_a -> Name () ) == "maximum_current" )
          {
            // Attribute "maximum_current" (formerly maximumcurrent)
            if ( sw_mc )
            {
              cerr << "Error parsing " << _err << ":" << endl
                   << " Duplicate appearance of attribute maximum_current"
                   << " in " << _de_v << " of "
                   << _pb_tag_str ( sw_iampower ) << "." << endl ;
              exit ( 1 ) ;
            }
            sscanf ( _de_a -> Value () , "%lf" , & x_pb ) ;
            ostringstream o_mcurr ;
            o_mcurr << fixed << setprecision ( 2 ) << ( pbd . mcurr = x_pb ) ;
            l_ofs << "  maximum current = " << o_mcurr . str () << endl ;
            sw_mc = true ;
            _de_a = _de_a -> Next () ;
          }
          else if ( string ( _de_a -> Name () ) == "high_velocity" )
          {
            // Attribute "high_velocity" (formerly highvelocity)
            if ( sw_hv )
            {
              cerr << "Error parsing " << _err << ":" << endl
                   << " Duplicate appearance of attribute high_velocity"
                   << " in " << _de_v << " of "
                   << _pb_tag_str ( sw_iampower ) << "." << endl ;
              exit ( 1 ) ;
            }
            sscanf ( _de_a -> Value () , "%lf" , & x_pb ) ;
            ostringstream o_hv ;
            o_hv << fixed << setprecision ( 2 ) << ( pbd . highvel = x_pb ) ;
            l_ofs << "  high velocity = " << o_hv . str () << endl ;
            sw_hv = true ;
            _de_a = _de_a -> Next () ;
          }
          else if ( string ( _de_a -> Name () ) == "low_velocity" )
          {
            // Attribute "low_velocity" (formerly lowvelocity)
            if ( sw_lv )
            {
              cerr << "Error parsing " << _err << ":" << endl
                   << " Duplicate appearance of attribute low_velocity"
                   << " in " << _de_v << " of "
                   << _pb_tag_str ( sw_iampower ) << "." << endl ;
              exit ( 1 ) ;
            }
            sscanf ( _de_a -> Value () , "%lf" , & x_pb ) ;
            ostringstream o_lv ;
            o_lv << fixed << setprecision ( 2 ) << ( pbd . lowvel = x_pb ) ;
            l_ofs << "  low velocity = " << o_lv . str () << endl ;
            sw_lv = true ;
            _de_a = _de_a -> Next () ;
          }
          else if ( string ( _de_a -> Name () ) == "tractive_effort" )
          {
            // Attribute "tractive_effort" (formerly tractionforce)
            if ( sw_tf )
            {
              cerr << "Error parsing " << _err << ":" << endl
                   << " Duplicate appearance of attribute tractive_effort"
                   << " in " << _de_v << " of "
                   << _pb_tag_str ( sw_iampower ) << "." << endl ;
              exit ( 1 ) ;
            }
            sscanf ( _de_a -> Value () , "%lf" , & x_pb ) ;
            ostringstream o_tracf ;
            o_tracf << fixed << setprecision ( 2 ) << ( pbd . tracf = x_pb ) ;
            l_ofs << "  tractive effort = " << o_tracf . str () << endl ;
            sw_tf = true ;
            _de_a = _de_a -> Next () ;
          }
          else if ( string ( _de_a -> Name () ) == "motor_current" )
          {
            // Attribute "motor_current" (formerly motorcurrent)
            if ( sw_mtc )
            {
              cerr << "Error parsing " << _err << ":" << endl
                   << " Duplicate appearance of attribute motor_current"
                   << " in " << _de_v << " of "
                   << _pb_tag_str ( sw_iampower ) << "." << endl ;
              exit ( 1 ) ;
            }
            sscanf ( _de_a -> Value () , "%lf" , & x_pb ) ;
            ostringstream o_moc ;
            o_moc << fixed << setprecision ( 2 )
                  << ( pbd . motorcurr = x_pb ) ;
            l_ofs << "  motor current = " << o_moc . str () << endl ;
            sw_mtc = true ;
          }
          else
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Attribute " << _de_a -> Name () << " for " << _de_v
                 << " in " << _pb_tag_str ( sw_iampower )
                 << "tag not allowed" << endl ;
            exit ( 1 ) ;
          }
        }	// pbd ɤ߽
        if ( ! ( sw_cg && sw_mc && sw_hv && sw_lv && sw_tf && sw_mtc ) )
        {
          cerr << "Error parsing " << _err << ":" << endl
               << " Some attribute(s) missing in " << _de_v << " in "
               << _pb_tag_str ( sw_iampower ) << "tag" << endl ;
          exit ( 1 ) ;
        }
        if ( sw_iamemp )
        {
          l_ofs << "Empty data" << endl ;
          if ( sw_iampower )
          {
            p . pbempty = pbd ;
          }
          else
          {
            b . pbempty = pbd ;
          }
        }
        else if ( sw_iammid )
        {
          l_ofs << "Mid data" << endl ;
          if ( sw_iampower )
          {
            p . pbmid = pbd ;
          }
          else
          {
            b . pbmid = pbd ;
          }
        }
        else if ( sw_iamful )
        {
          l_ofs << "Full data" << endl ;
          if ( sw_iampower )
          {
            p . pbfull = pbd ;
          }
          else
          {
            b . pbfull = pbd ;
          }
        }
        else
        {
          l_ofs << "Unknown error" << endl ;
          cerr << "Unknown error" << endl ;
          exit ( 49 ) ;
        }	// pbd åȤ
      }
      if ( ! ( sw_emp && sw_mid && sw_ful ) )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " One of empty, mid or full data entry tag missing in "
             << _pb_tag_str ( sw_iampower ) << "tag" << endl ;
        exit ( 1 ) ;
      }
    }
    else if ( _tc_v == "autodata" )
    {
      // -----
      // If flag processing has ended, quit.
      // ե饰λƤʤʤ¹Ԥߡ
      // -----
      if ( ! ( flag_ended && cs_command_ended ) )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Tag <autodata> in wrong position." << endl ;
        exit ( 1 ) ;
      }
      if ( sw_auto )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Tag <autodata> either duplicate or not allowed." << endl ;
        exit ( 1 ) ;
      }
      sw_auto = true ;
      bool sw_mv , sw_fv , sw_pm , sw_po , sw_rb , sw_rf ;
      sw_mv = sw_fv = sw_pm = sw_po = sw_rb = sw_rf = false ;
      double _x_a ;
      TiXmlAttribute const * _a_a
        = _tc -> ToElement () -> FirstAttribute () ;
      while ( _a_a )
      {
        if ( string ( _a_a -> Name () ) == "minimum_velocity" )
        {
          // Attribute "minimum_velocity" (formerly minimumvelocity)
          if ( sw_mv )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate attribute minimum_velocity"
                 << " in <autodata>" << endl ;
            exit ( 1 ) ;
          }
          sscanf ( _a_a -> Value () , "%lf" , & _x_a ) ;
          ostringstream o_aminvel ;
          o_aminvel << fixed << setprecision ( 2 ) << ( a . minvel = _x_a ) ;
          l_ofs << "autod.minvel = " << o_aminvel . str () << endl ;
          sw_mv = true ;
          _a_a = _a_a -> Next () ;
        }
        else if ( string ( _a_a -> Name () ) == "full_velocity" )
        {
          // Attribute "full_velocity" (formerly fullvelocity)
          if ( sw_fv )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate attribute full_velocity"
                 << " in <autodata>" << endl ;
            exit ( 1 ) ;
          }
          sscanf ( _a_a -> Value () , "%lf" , & _x_a ) ;
          ostringstream o_afv ;
          o_afv << fixed << setprecision ( 2 ) << ( a . fullvel = _x_a ) ;
          l_ofs << "autod.fullvel = " << o_afv . str () << endl ;
          sw_fv = true ;
          _a_a = _a_a -> Next () ;
        }
        else if ( string ( _a_a -> Name () ) == "power_limit_voltage" )
        {
          // Attribute "power_limit_voltage" (formerly powerlimitvoltage)
          if ( sw_pm )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate attribute power_limit_voltage"
                 << " in <autodata>" << endl ;
            exit ( 1 ) ;
          }
          sscanf ( _a_a -> Value () , "%lf" , & _x_a ) ;
          ostringstream o_apmv ;
          o_apmv << fixed << setprecision ( 1 )
                 << ( a . pminvolx = a . pminvol = _x_a ) ;
          l_ofs << "autod.pminvol = " << o_apmv . str () << endl ;
          sw_pm = true ;
          _a_a = _a_a -> Next () ;
        }
        else if ( string ( _a_a -> Name () ) == "power_off_voltage" )
        {
          // Attribute "power_off_voltage" (formerly poweroffvoltage)
          if ( sw_po )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate attribute power_off_voltage"
                 << " in <autodata>" << endl ;
            exit ( 1 ) ;
          }
          sscanf ( _a_a -> Value () , "%lf" , & _x_a ) ;
          ostringstream o_apov ;
          o_apov << fixed << setprecision ( 1 )
                 << ( a . poffvolx = a . poffvol = _x_a ) ;
          l_ofs << "autod.poffvol = " << o_apov . str () << endl ;
          sw_po = true ;
          _a_a = _a_a -> Next () ;
        }
        else if ( string ( _a_a -> Name () ) == "regen_start_voltage" )
        {
          // Attribute "regen_start_voltage"
          // (formerly regenerationstartvoltage)
          if ( sw_rb )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate attribute regen_start_voltage"
                 << " in <autodata>" << endl ;
            exit ( 1 ) ;
          }
          sscanf ( _a_a -> Value () , "%lf" , & _x_a ) ;
          ostringstream o_acbv ;
          o_acbv << fixed << setprecision ( 1 ) << ( a . crbvol = _x_a ) ;
          l_ofs << "autod.crbvol = " << o_acbv . str () << endl ;
          sw_rb = true ;
          _a_a = _a_a -> Next () ;
        }
        else if ( string ( _a_a -> Name () ) == "full_regen_voltage" )
        {
          // Attribute "full_regen_voltage"
          // (formerly regenerationfullvoltage)
          if ( sw_rf )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate attribute full_regen_voltage"
                 << " in <autodata>" << endl ;
            exit ( 1 ) ;
          }
          sscanf ( _a_a -> Value () , "%lf" , & _x_a ) ;
          ostringstream o_crfv ;
          o_crfv << fixed << setprecision ( 1 ) << ( a . crfvol = _x_a ) ;
          l_ofs << "autod.crfvol = " << o_crfv . str () << endl ;
          sw_rf = true ;
          _a_a = _a_a -> Next () ;
        }
        else
        {
          cerr << "Error parsing " << _err << ":" << endl
               << " Attribute " << _a_a -> Name () << " for <autodata>"
               << " tag not allowed" << endl ;
          exit ( 1 ) ;
        }
      }
      if ( ! ( sw_mv && sw_fv && sw_pm && sw_po && sw_rb && sw_rf ) )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Some attribute(s) missing in <autodata>" << endl ;
        exit ( 1 ) ;
      }
    }
    else if ( _tc_v == "congestion" )
    {
      // -----
      // If flag processing has ended, quit.
      // ե饰λƤʤʤ¹Ԥߡ
      // -----
      if ( ! ( flag_ended && cs_command_ended ) )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Tag <congestion> in wrong position." << endl ;
        exit ( 1 ) ;
      }
      if ( sw_cong )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Duplicate tag <congestion>." << endl ;
        exit ( 1 ) ;
      }
      sw_cong = true ;
      TiXmlAttribute const * _a_cong
        = _tc -> ToElement () -> FirstAttribute () ;
      bool sw_cong_attr = false ;
      ostringstream o_cgx ;
      while ( _a_cong )
      {
        if ( string ( _a_cong -> Name () ) == "value" )
        {
          // Attribute "value"
          if ( sw_cong_attr )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate attribute value"
                 << " in <congestion>" << endl ;
            exit ( 1 ) ;
          }
          sscanf ( _a_cong -> Value () , "%lf" , & cong ) ;
          o_cgx . clear () ;
          o_cgx . str ( "" ) ;
          o_cgx << fixed << setprecision ( 2 ) << cong ;
          l_ofs << "conges = " << o_cgx . str () << endl ;
          sw_cong_attr = true ;
          _a_cong = _a_cong -> Next () ;
        }
        else
        {
          cerr << "Error parsing " << _err << ":" << endl
               << " Attribute " << _a_cong -> Name () << " for <congestion>"
               << " tag not allowed" << endl ;
          exit ( 1 ) ;
        }
      }
      if ( ! sw_cong_attr )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Attribute value missing in <congestion>" << endl ;
        exit ( 1 ) ;
      }
    }
    else if ( _tc_v == "auxiliary_load" )
    {
      // Tag <auxiliary_load> (formerly auxcurrent)

      // -----
      // If flag processing has ended, quit.
      // ե饰λƤʤʤ¹Ԥߡ
      // -----
      if ( ! ( flag_ended && cs_command_ended ) )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Tag <auxiliary_load> in wrong position." << endl ;
        exit ( 1 ) ;
      }
      if ( sw_auxc )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Duplicate tag <auxiliary_load>." << endl ;
        exit ( 1 ) ;
      }
      sw_auxc = true ;
      TiXmlAttribute const * _a_auxl
        = _tc -> ToElement () -> FirstAttribute () ;
      bool sw_auxc_attr = false ;
      while ( _a_auxl )
      {
        if ( string ( _a_auxl -> Name () ) == "value" )
        {
          // Attribute "value"
          if ( sw_auxc_attr )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate attribute value"
                 << " in <auxiliary_load>" << endl ;
            exit ( 1 ) ;
          }
          sscanf ( _a_auxl -> Value () , "%lf" , & auxcurr ) ;
          ostringstream o_auxl ;
          o_auxl << fixed << setprecision ( 2 ) << auxcurr ;
          l_ofs << "aux. load = " << o_auxl . str () << endl ;
          sw_auxc_attr = true ;
          _a_auxl = _a_auxl -> Next () ;
        }
        else
        {
          cerr << "Error parsing " << _err << ":" << endl
               << " Attribute " << _a_auxl -> Name ()
               << " for <auxiliary_load> tag not allowed" << endl ;
          exit ( 1 ) ;
        }
      }
      if ( ! sw_auxc_attr )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Attribute value missing in <auxiliary_load>" << endl ;
        exit ( 1 ) ;
      }
    }
    else if ( _tc_v == "curve_resistance_coeff" )
    {
      // -----
      // If flag processing has ended, quit.
      // ե饰λƤʤʤ¹Ԥߡ
      // -----
      if ( ! ( flag_ended && cs_command_ended ) )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Tag <curve_resistance_coeff> in wrong position." << endl ;
        exit ( 1 ) ;
      }
      if ( sw_crc )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Duplicate tag <curve_resistance_coeff>." << endl ;
        exit ( 1 ) ;
      }
      sw_crc = true ;
      TiXmlAttribute const * _a_crc
        = _tc -> ToElement () -> FirstAttribute () ;
      bool sw_crc_attr = false ;
      while ( _a_crc )
      {
        if ( string ( _a_crc -> Name () ) == "value" )
        {
          // Attribute "value"
          if ( sw_crc_attr )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate attribute value"
                 << " in <curve_resistance_coeff>" << endl ;
            exit ( 1 ) ;
          }
          sscanf ( _a_crc -> Value () , "%lf" , & mra ) ;
          ostringstream o_crc ;
          o_crc << fixed << setprecision ( 2 ) << mra ;
          l_ofs << "curve resistance coeff. = " << o_crc . str () << endl ;
          sw_crc_attr = true ;
          _a_crc = _a_crc -> Next () ;
        }
        else
        {
          cerr << "Error parsing " << _err << ":" << endl
               << " Attribute " << _a_crc -> Name ()
               << " for <curve_resistance_coeff> tag not allowed" << endl ;
          exit ( 1 ) ;
        }
      }
      if ( ! sw_crc_attr )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Attribute value missing in <curve_resistance_coeff>"
             << endl ;
        exit ( 1 ) ;
      }
    }
    else if ( _tc_v == "rolling_mass_coeff" )
    {
      // -----
      // If flag processing has ended, quit.
      // ե饰λƤʤʤ¹Ԥߡ
      // -----
      if ( ! ( flag_ended && cs_command_ended ) )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Tag <rolling_mass_coeff> in wrong position." << endl ;
        exit ( 1 ) ;
      }
      if ( sw_rmc )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Duplicate tag <rolling_mass_coeff>." << endl ;
        exit ( 1 ) ;
      }
      sw_rmc = true ;
      TiXmlAttribute const * _a_rmc
        = _tc -> ToElement () -> FirstAttribute () ;
      bool sw_rmc_attr = false ;
      while ( _a_rmc )
      {
        if ( string ( _a_rmc -> Name () ) == "value" )
        {
          // Attribute "value"
          if ( sw_rmc_attr )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate attribute value"
                 << " in <rolling_mass_coeff>" << endl ;
            exit ( 1 ) ;
          }
          sscanf ( _a_rmc -> Value () , "%lf" , & mrb ) ;
          ostringstream o_rmc ;
          o_rmc << fixed << setprecision ( 4 ) << mrb ;
          l_ofs << "rolling mass coeff. = " << o_rmc . str () << endl ;
          sw_rmc_attr = true ;
          _a_rmc = _a_rmc -> Next () ;
        }
        else
        {
          cerr << "Error parsing " << _err << ":" << endl
               << " Attribute " << _a_rmc -> Name ()
               << " for <rolling_mass_coeff> tag not allowed" << endl ;
          exit ( 1 ) ;
        }
      }
      if ( ! sw_rmc_attr )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Attribute value missing in <rolling_mass_coeff>"
             << endl ;
        exit ( 1 ) ;
      }
    }
    else if ( _tc_v == "deceleration" )
    {
      // -----
      // If flag processing has ended, quit.
      // ե饰λƤʤʤ¹Ԥߡ
      // -----
      if ( ! ( flag_ended && cs_command_ended ) )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Tag <deceleration> in wrong position." << endl ;
        exit ( 1 ) ;
      }
      if ( sw_dec )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Duplicate tag <deceleration>." << endl ;
        exit ( 1 ) ;
      }
      sw_dec = true ;
      TiXmlAttribute const * _a_dec
        = _tc -> ToElement () -> FirstAttribute () ;
      bool sw_dec_attr = false ;
      while ( _a_dec )
      {
        if ( string ( _a_dec -> Name () ) == "value" )
        {
          // Attribute "value"
          if ( sw_dec_attr )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate attribute value"
                 << " in <deceleration>" << endl ;
            exit ( 1 ) ;
          }
          sscanf ( _a_dec -> Value () , "%lf" , & mrc ) ;
          ostringstream o_td ;
          o_td << fixed << setprecision ( 2 ) << mrc ;
          l_ofs << "train deceleration = " << o_td . str () << endl ;
          sw_dec_attr = true ;
          _a_dec = _a_dec -> Next () ;
        }
        else
        {
          cerr << "Error parsing " << _err << ":" << endl
               << " Attribute " << _a_dec -> Name ()
               << " for <deceleration> tag not allowed" << endl ;
          exit ( 1 ) ;
        }
      }
      if ( ! sw_dec_attr )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Attribute value missing in <deceleration>"
             << endl ;
        exit ( 1 ) ;
      }
    }
    else if ( _tc_v == "cars_in_trainset" )
    {
      // -----
      // If flag processing has ended, quit.
      // ե饰λƤʤʤ¹Ԥߡ
      // -----
      if ( ! ( flag_ended && cs_command_ended ) )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Tag <cars_in_trainset> in wrong position." << endl ;
        exit ( 1 ) ;
      }
      if ( sw_cit )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Duplicate tag <cars_in_trainset>." << endl ;
        exit ( 1 ) ;
      }
      sw_cit = true ;
      TiXmlAttribute const * _a_cit
        = _tc -> ToElement () -> FirstAttribute () ;
      bool sw_cit_attr = false ;
      while ( _a_cit )
      {
        if ( string ( _a_cit -> Name () ) == "value" )
        {
          // Attribute "value"
          if ( sw_cit_attr )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate attribute value"
                 << " in <cars_in_trainset>" << endl ;
            exit ( 1 ) ;
          }
          sscanf ( _a_cit -> Value () , "%d" , & mrd ) ;
          l_ofs << "number of cars in a trainset = " << mrd << endl ;
          sw_cit_attr = true ;
          _a_cit = _a_cit -> Next () ;
        }
        else
        {
          cerr << "Error parsing " << _err << ":" << endl
               << " Attribute " << _a_cit -> Name ()
               << " for <cars_in_trainset> tag not allowed" << endl ;
          exit ( 1 ) ;
        }
      }
      if ( ! sw_cit_attr )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Attribute value missing in <cars_in_trainset>"
             << endl ;
        exit ( 1 ) ;
      }
    }
    else if ( _tc_v == "weight_data" )
    {
      // Tag <weight_data> (formerly setweight)

      // -----
      // If flag processing has ended, quit.
      // ե饰λƤʤʤ¹Ԥߡ
      // -----
      if ( ! ( flag_ended && cs_command_ended ) )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Tag <weight_data> in wrong position." << endl ;
        exit ( 1 ) ;
      }
      if ( sw_setw )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Duplicate tag <weight_data>." << endl ;
        exit ( 1 ) ;
      }
      sw_setw = true ;
      TiXmlAttribute const * _a_setw
        = _tc -> ToElement () -> FirstAttribute () ;
      bool sw_setw_power_car_weight = false ;
      bool sw_setw_power_car_payload = false ;
      bool sw_setw_trailer_car_weight = false ;
      bool sw_setw_trailer_car_payload = false ;
      while ( _a_setw )
      {
        if ( string ( _a_setw -> Name () ) == "power_car_weight" )
        {
          // Attribute "power_car_weight"
          if ( sw_setw_power_car_weight )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate attribute power_car_weight"
                 << " in <weight_data>" << endl ;
            exit ( 1 ) ;
          }
          sscanf ( _a_setw -> Value () , "%lf" , & wta ) ;
          sw_setw_power_car_weight = true ;
          _a_setw = _a_setw -> Next () ;
        }
        else if ( string ( _a_setw -> Name () ) == "power_car_payload" )
        {
          // Attribute "power_car_payload"
          if ( sw_setw_power_car_payload )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate attribute power_car_payload"
                 << " in <weight_data>" << endl ;
            exit ( 1 ) ;
          }
          sscanf ( _a_setw -> Value () , "%lf" , & wtb ) ;
          sw_setw_power_car_payload = true ;
          _a_setw = _a_setw -> Next () ;
        }
        else if ( string ( _a_setw -> Name () ) == "trailer_car_weight" )
        {
          // Attribute "trailer_car_weight"
          if ( sw_setw_trailer_car_weight )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate attribute trailer_car_weight"
                 << " in <weight_data>" << endl ;
            exit ( 1 ) ;
          }
          sscanf ( _a_setw -> Value () , "%lf" , & wtc ) ;
          sw_setw_trailer_car_weight = true ;
          _a_setw = _a_setw -> Next () ;
        }
        else if ( string ( _a_setw -> Name () ) == "trailer_car_payload" )
        {
          // Attribute "trailer_car_payload"
          if ( sw_setw_trailer_car_payload )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate attribute trailer_car_payload"
                 << " in <weight_data>" << endl ;
            exit ( 1 ) ;
          }
          sscanf ( _a_setw -> Value () , "%lf" , & wtd ) ;
          sw_setw_trailer_car_payload = true ;
          _a_setw = _a_setw -> Next () ;
        }
        else
        {
          cerr << "Error parsing " << _err << ":" << endl
               << " Attribute " << _a_setw -> Name ()
               << " for <weight_data> tag not allowed" << endl ;
          exit ( 1 ) ;
        }
      }
      if ( ! ( sw_setw_power_car_weight && sw_setw_power_car_payload
               && sw_setw_trailer_car_weight
               && sw_setw_trailer_car_payload ) )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Some attribute(s) missing in <weight_data>" << endl ;
        exit ( 1 ) ;
      }
      ostringstream o_weight ;
      o_weight << fixed << setprecision ( 2 ) << wta << " "
               << wtb << " " << wtc << " " << wtd ;
      l_ofs << "setweight = " << o_weight . str () << endl ;
    }
    else if ( _tc_v == "davis_coefficients" )
    {
      // Tag <davis_coefficients> (formerly setrest)

      // -----
      // If flag processing has ended, quit.
      // ե饰λƤʤʤ¹Ԥߡ
      // -----
      if ( ! ( flag_ended && cs_command_ended ) )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Tag <davis_coefficients> in wrong position." << endl ;
        exit ( 1 ) ;
      }
      if ( sw_setr )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Duplicate tag <davis_coefficients>." << endl ;
        exit ( 1 ) ;
      }
      sw_setr = true ;
      TiXmlAttribute const * _a_setr
        = _tc -> ToElement () -> FirstAttribute () ;
      bool sw_setr_a_zero_order_for_power_car = false ;
      bool sw_setr_b_first_order_for_power_car = false ;
      bool sw_setr_c_zero_order_for_trailer_car = false ;
      bool sw_setr_d_first_order_for_trailer_car = false ;
      bool sw_setr_e_second_order_per_trainset = false ;
      bool sw_setr_f_second_order_per_car = false ;
      while ( _a_setr )
      {
        if ( string ( _a_setr -> Name () ) == "zero_order_for_power_car" )
        {
          // Attribute "zero_order_for_power_car"
          if ( sw_setr_a_zero_order_for_power_car )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate attribute zero_order_for_power_car"
                 << " in <davis_coefficients>" << endl ;
            exit ( 1 ) ;
          }
          sscanf ( _a_setr -> Value () , "%lf" , & rca ) ;
          sw_setr_a_zero_order_for_power_car = true ;
          _a_setr = _a_setr -> Next () ;
        }
        else if
          ( string ( _a_setr -> Name () ) == "first_order_for_power_car" )
        {
          // Attribute "first_order_for_power_car"
          if ( sw_setr_b_first_order_for_power_car )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate attribute first_order_for_power_car"
                 << " in <davis_coefficients>" << endl ;
            exit ( 1 ) ;
          }
          sscanf ( _a_setr -> Value () , "%lf" , & rcb ) ;
          sw_setr_b_first_order_for_power_car = true ;
          _a_setr = _a_setr -> Next () ;
        }
        else if
          ( string ( _a_setr -> Name () ) == "zero_order_for_trailer_car" )
        {
          // Attribute "zero_order_for_trailer_car"
          if ( sw_setr_c_zero_order_for_trailer_car )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate attribute zero_order_for_trailer_car"
                 << " in <davis_coefficients>" << endl ;
            exit ( 1 ) ;
          }
          sscanf ( _a_setr -> Value () , "%lf" , & rcc ) ;
          sw_setr_c_zero_order_for_trailer_car = true ;
          _a_setr = _a_setr -> Next () ;
        }
        else if
          ( string ( _a_setr -> Name () ) == "first_order_for_trailer_car" )
        {
          // Attribute "first_order_for_trailer_car"
          if ( sw_setr_d_first_order_for_trailer_car )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate attribute first_order_for_trailer_car"
                 << " in <davis_coefficients>" << endl ;
            exit ( 1 ) ;
          }
          sscanf ( _a_setr -> Value () , "%lf" , & rcd ) ;
          sw_setr_d_first_order_for_trailer_car = true ;
          _a_setr = _a_setr -> Next () ;
        }
        else if
          ( string ( _a_setr -> Name () ) == "second_order_per_trainset" )
        {
          // Attribute "second_order_per_trainset"
          if ( sw_setr_e_second_order_per_trainset )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate attribute second_order_per_trainset"
                 << " in <davis_coefficients>" << endl ;
            exit ( 1 ) ;
          }
          sscanf ( _a_setr -> Value () , "%lf" , & rce ) ;
          sw_setr_e_second_order_per_trainset = true ;
          _a_setr = _a_setr -> Next () ;
        }
        else if
          ( string ( _a_setr -> Name () ) == "second_order_per_car" )
        {
          // Attribute "second_order_per_car"
          if ( sw_setr_f_second_order_per_car )
          {
            cerr << "Error parsing " << _err << ":" << endl
                 << " Duplicate attribute second_order_per_car"
                 << " in <davis_coefficients>" << endl ;
            exit ( 1 ) ;
          }
          sscanf ( _a_setr -> Value () , "%lf" , & rcf ) ;
          sw_setr_f_second_order_per_car = true ;
          _a_setr = _a_setr -> Next () ;
        }
        else
        {
          cerr << "Error parsing " << _err << ":" << endl
               << " Attribute " << _a_setr -> Name ()
               << " for <davis_coefficients> tag not allowed" << endl ;
          exit ( 1 ) ;
        }
      }
      if ( ! ( sw_setr_a_zero_order_for_power_car
               && sw_setr_b_first_order_for_power_car
               && sw_setr_c_zero_order_for_trailer_car
               && sw_setr_d_first_order_for_trailer_car
               && sw_setr_e_second_order_per_trainset
               && sw_setr_f_second_order_per_car ) )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Some attribute(s) missing in <davis_coefficients>"
             << endl ;
        exit ( 1 ) ;
      }
      ostringstream o_setrsc ;
      o_setrsc << scientific << setprecision ( 3 ) << rca << " " << rcb
               << " " << rcc << " " << rcd << " " << rce << " " << rcf ;
      l_ofs << "setrsc = " << o_setrsc . str () << endl ;
    }
    else if ( _tc_v == "energystorage" )
    {
      // Tag <energystorage> (new)

      // -----
      // If flag processing has ended, or if duplicate <energystorage>
      // tag is found, halt the program.
      // ե饰λƤʤ or ʣ <energystorage> ȯ
      // 줿ʤ顤¹Ԥߡ
      // -----
      if ( ! ( flag_ended && cs_command_ended ) )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Tag <energystorage> in wrong position." << endl ;
        exit ( 1 ) ;
      }
      if ( sw_energystorage )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Duplicate tag <energystorage>." << endl ;
        exit ( 1 ) ;
      }
      sw_energystorage = true ;

      // ----
      // The name of the child tag of <energystorage> will be given to the
      // "creator" of ESS_OnBoard. There must be one single child tag
      // under <energystorage>.
      // <energystorage> λҥ̾ΤΤޤ ESS_OnBoard 
      // ȤΡ֥ꥨפϤ롣<energystorage> ϡ
      // ҥ1ĤʤФʤʤ
      // ----
      bool sw_gc = true ;
      for ( const TiXmlNode * _gc = _tc -> FirstChild () ; _gc ;
            _gc = _gc -> NextSibling () )
      {
        // -----
        // Ignore non-Element node.
        // Ȱʳ̵롣
        // -----
        if ( _gc -> Type () != TiXmlNode :: TINYXML_ELEMENT )
        {
          continue ;
        }
        // -----
        // If already processed an element, halt the program (duplicate
        // child tags).
        // Ǥ˥ȤѤߤǤм¹ߡʻҥʣˡ
        // -----
        if ( ! sw_gc )
        {
          cerr << "Error parsing " << _err << ":" << endl
               << " Tag <energystorage> has duplicate children." << endl ;
          exit ( 1 ) ;
        }

        // -----
        // First element will be used to create an ESS_OnBoard object.
        // Because the default constructor assigns an No_ESS_OnBoard
        // class instance to _ess, it must be destroyed first.
        // ǽΥȤ ESS_OnBoard ֥ȤĤ롣ǥե
        // 󥹥ȥ饯 _ess  No_ESS_OnBoard 饹Υ󥹥
        // ƤƤޤäƤ뤿ᡤޤ˲ɬפ롣
        // -----
        delete _ess ;
        _ess = OBESS_Expander :: create ( _gc -> Value () , _gc ) ;
        sw_gc = false ;
        l_ofs << "On-board energy storage: class = " << _gc -> Value ()
              << endl ;
      }
      if ( sw_gc )
      {
        cerr << "Error parsing " << _err << ":" << endl
             << " Tag <energystorage> without a valid child." << endl ;
        exit ( 1 ) ;
      }
    }
    else
    {
      cerr << "Error parsing " << _err << ":" << endl
           << " Tag " << _tc_v << " not allowed" << endl ;
      exit ( 1 ) ;
    }
  }
  if ( ! ( flag_ended && cs_command_ended && sw_power && sw_brake && sw_auto
           && sw_cong && sw_auxc && sw_crc && sw_rmc && sw_dec && sw_cit
           && sw_setw && sw_setr ) )
  {
    cerr << "Error parsing " << _err << ":" << endl
         << " Some tag(s) missing" << endl ;
    exit ( 1 ) ;
  }
}




// ----
// Reading P-file (train performance data).
// ֥ǡΥե꡼ (Pե)
// ----
void
traindata :: readfile
( FILE * pbdata ,
  char * p_file )
{

  ostringstream o_x ;

  while ( 1 )
  {
    // ǽ cs_command 򸫤Ĥޤ³
    getcommand ( pbdata , p_file ) ;
    if ( cmpcommand ( "differentregend" ) )
    {
      if ( sw_different_regend )
      {
        sw_different_regend = false ;
        l_ofs << "OK, toggled sw_different_regend to false" << endl ;
      }
      else
      {
        sw_different_regend = true ;
        l_ofs << "OK, toggled sw_different_regend to true" << endl ;
      }
    }
    else if ( cmpcommand ( "auxpower" ) )
    {
      if ( sw_aux_power )
      {
        sw_aux_power = false ;
        l_ofs << "OK, toggled sw_aux_power to false" << endl ;
      }
      else
      {
        sw_aux_power = true ;
        l_ofs << "OK, toggled sw_aux_power to true" << endl ;
      }
    }
    else if ( cmpcommand ( "torque_shibori" ) )
    {
      if ( sw_torque_shibori )
      {
        sw_torque_shibori = false ;
        l_ofs << "OK, toggled sw_torque_shibori to false" << endl ;
      }
      else
      {
        sw_torque_shibori = true ;
        l_ofs << "OK, toggled sw_torque_shibori to true" << endl ;
      }
    }
    else if ( cmpcommand ( "shiboriparallel" ) )
    {
      if ( sw_shibori_parallel )
      {
        sw_shibori_parallel = false ;
        l_ofs << "OK, toggled sw_shibori_parallel to false" << endl ;
      }
      else
      {
        sw_shibori_parallel = true ;
        l_ofs << "OK, toggled sw_shibori_parallel to true" << endl ;
      }
    }
    else if ( cmpcommand ( "regendantei" ) )
    {
      if ( sw_regenoffantei )
      {
        sw_regenoffantei = false ;
        l_ofs << "OK, toggled sw_regenoffantei to false" << endl ;
      }
      else
      {
        sw_regenoffantei = true ;
        l_ofs << "OK, toggled sw_regenoffantei to true" << endl ;
      }
    }
    else if ( cmpcommand ( "anteimotor" ) )
    {
      if ( sw_anteimotor )
      {
        sw_anteimotor = false ;
        l_ofs << "OK, toggled sw_anteimotor to false" << endl ;
      }
      else
      {
        sw_anteimotor = true ;
        l_ofs << "OK, toggled sw_anteimotor to true" << endl ;
      }
    }
    else if ( strcmp ( tmpch, "cs_command" ) == 0 )
    {
      break ;
    }
    else
    {
      err_eof ( p_file ) ;
    }
  }
  getcommand ( pbdata , p_file ) ;
  if ( cmpcommand ( "None" ) )
  {
    ccx = None ;
  }
  else if ( cmpcommand ( "Ec_auto" ) )
  {
    ccx = Ec_auto ;
  }
  else if ( cmpcommand ( "Ea_cvauto0" ) )
  {
    ccx = Ea_cvauto0 ;
  }
  else if ( cmpcommand ( "Const_volt" ) )
  {
    ccx = Const_volt ;
  }
  else if ( cmpcommand ( "Const_power" ) )
  {
    ccx = Const_power ;
  }
  else if ( cmpcommand ( "Torque_keisu" ) )
  {
    ccx = Torque_keisu ;
  }
  else
  {
    err_eof ( p_file ) ;
  }

  // powerdata, brakedata Ȼ
  bool sw_power , sw_brake , sw_auto , sw_cong , sw_auxc , sw_setw ;
  bool sw_setr , sw_setm ;
  sw_power = sw_brake = sw_auto = sw_cong = sw_auxc = sw_setw = sw_setr
    = sw_setm = false ;
  while ( ! ( sw_power && sw_brake && sw_auto && sw_cong
              && sw_auxc && sw_setw && sw_setr && sw_setm ) )
  {
    getcommand ( pbdata , p_file ) ;
    if ( cmpcommand ( "powerdata" ) || cmpcommand ( "brakedata" ) )
    {
      bool sw_iampower ;
      if ( cmpcommand ( "powerdata" ) )
      {
        if ( sw_power )
        {
          err_eof ( p_file ) ;
        }
        sw_iampower = sw_power = true ;
        l_ofs << endl << "** Train Characteristics **" << endl
              << "Powerdata:" << endl ;
      }
      else
      {
        if ( sw_brake )
        {
          err_eof ( p_file ) ;
        }
        sw_brake = true ;
        sw_iampower = false ;
        l_ofs << endl << "** Train Characteristics **" << endl
              << "Brakedata:" << endl ;
      }
      bool sw_ec , sw_zc , sw_miv , sw_bmv , sw_rege , sw_regx ;
      bool sw_mav , sw_regs , sw_emp , sw_mid , sw_ful ;
      sw_ec = sw_zc = sw_miv = sw_bmv = sw_mav = sw_emp = sw_mid = sw_ful
        = false ;

      // Ϲԥǡˤ
      sw_regs = sw_rege = sw_regx = sw_iampower ;
		
      if ( ! sw_different_regend )	// ΤȤ
      {
        sw_rege = true ;
      }
      
      if ( ! sw_regenoffantei )
      {
        // ϤΤȤ
        sw_regx = true ;
      }
      else
      {
        b . regendantei = 0.0 ;
      }
      double x ;
      while ( ! ( sw_ec && sw_zc && sw_miv && sw_bmv && sw_mav
                  && sw_regs && sw_rege && sw_regx && sw_emp
                  && sw_mid && sw_ful ) )
      {
        if ( cmpcommand ( pbdata , "ec" , p_file , true ) )
        {
          if ( sw_ec )
          {
            err_eof ( p_file ) ;
          }
          getdouble ( pbdata , p_file , x ) ;
          o_x . clear () ;
          o_x . str ( "" ) ;
          o_x << fixed << setprecision ( 1 ) << x ;
          if ( sw_iampower )
          {
            p . ec = x ;
            l_ofs << "p.ec = " << o_x . str () << endl ;
          }
          else
          {
            b . ec = x ;
            l_ofs << "b.ec = " << o_x . str () << endl ;
          }
          sw_ec = true ;
        }
        else if ( cmpcommand ( "zerocur" ) || cmpcommand ( "regenoff" ) )
        {
          if ( sw_zc )
          {
            err_eof ( p_file ) ;
          }
          if ( cmpcommand ( "zerocur" ) )
          {
            if ( ! sw_iampower )
            {
              err_eof ( p_file ) ;
            }
            getdouble ( pbdata , p_file , p . zerocur ) ;
            o_x . clear () ;
            o_x . str ( "" ) ;
            o_x << fixed << setprecision ( 1 ) << p . zerocur ;
            l_ofs << "p.zerocur = " << o_x . str () << endl ;
          }
          else
          {
            if ( sw_iampower )
            {
              err_eof ( p_file ) ;
            }
            getdouble ( pbdata , p_file , b . regenoff ) ;
            o_x . clear () ;
            o_x . str ( "" ) ;
            o_x << fixed << setprecision ( 2 ) << b . regenoff ;
            l_ofs << "b.regenoff = " << o_x . str () << endl ;
          }
          sw_zc = true ;
        }
        else if ( cmpcommand ( "minimumvoltage" ) )
        {
          if ( sw_miv )
          {
            err_eof ( p_file ) ;
          }
          getdouble ( pbdata , p_file , x ) ;
          o_x . clear () ;
          o_x . str ( "" ) ;
          o_x << fixed << setprecision ( 1 ) << x ;
          if ( sw_iampower )
          {
            p . minvol = x ;
            l_ofs << "p.minvol = " << o_x . str () << endl ;
          }
          else
          {
            b . minvol = x ;
            l_ofs << "b.minvol = " << o_x . str () << endl ;
          }
          sw_miv = true ;
        }
        else if ( cmpcommand ( "bminvoltage" ) )
        {
          if ( sw_bmv )
          {
            err_eof ( p_file ) ;
          }
          getdouble ( pbdata , p_file , x ) ;
          o_x . clear () ;
          o_x . str ( "" ) ;
          o_x << fixed << setprecision ( 1 ) << x ;
          if ( sw_iampower )
          {
            p . bminvol = x ;
            l_ofs << "p.bminvol = " << o_x . str () << endl ;
          }
          else
          {
            b . bminvol = x ;
            l_ofs << "b.bminvol = " << o_x . str () << endl ;
          }
          sw_bmv = true ;
        }
        else if ( cmpcommand ( "maximumvoltage" ) )
        {
          if ( sw_mav )
          {
            err_eof ( p_file ) ;
          }
          getdouble ( pbdata , p_file , x ) ;
          o_x . clear () ;
          o_x . str ( "" ) ;
          o_x << fixed << setprecision ( 1 ) << x ;
          if ( sw_iampower )
          {
            p . maxvol = x ;
            l_ofs << "p.maxvol = " << o_x . str () << endl ;
          }
          else
          {
            b . maxvol = x ;
            l_ofs << "b.maxvol = " << o_x . str () << endl ;
            if ( ! sw_different_regend )
            {
              // ƱͤǤ褤
              b . regendvol = x ;
            }
          }
          sw_mav = true ;
        }
        else if ( cmpcommand ( "regenlimitstartvoltage" ) )
        {
          if ( sw_regs || sw_iampower )
          {
            err_eof ( p_file ) ;
          }
          getdouble ( pbdata , p_file , b . startvol ) ;
          o_x . clear () ;
          o_x . str ( "" ) ;
          o_x << fixed << setprecision ( 1 ) << b . startvol ;
          l_ofs << "b.startvol = " << o_x . str () << endl ;
          sw_regs = true ;
        }
        else if ( cmpcommand ( "regenlimitendvoltage" ) )
        {
          if ( sw_rege || sw_iampower )
          {
            err_eof ( p_file ) ;
          }
          getdouble ( pbdata , p_file , b . regendvol ) ;
          o_x . clear () ;
          o_x . str ( "" ) ;
          o_x << fixed << setprecision ( 1 ) << b . regendvol ;
          l_ofs << "b.regendvol = " << o_x . str () << endl ;
          sw_rege = true ;
        }
        else if ( cmpcommand ( "regenoffanteika" ) )
        {
          if ( sw_regx || sw_iampower )
          {
            err_eof ( p_file ) ;
          }
          getdouble ( pbdata , p_file , b . regendantei ) ;
          o_x . clear () ;
          o_x . str ( "" ) ;
          o_x << fixed << setprecision ( 1 ) << b . regendantei ;
          l_ofs << "b.regendantei = " << o_x . str () << endl ;
          sw_regx = true ;
        }
        else if ( cmpcommand ( "empty" ) || cmpcommand ( "mid" )
                  || cmpcommand ( "full" ) )
        {
          bool sw_iamemp , sw_iammid , sw_iamful ;
          sw_iamemp = sw_iammid = sw_iamful = false ;
          if ( cmpcommand ( "empty" ) )
          {
            if ( sw_emp )
            {
              err_eof ( p_file ) ;
            }
            sw_iamemp = sw_emp = true ;
            l_ofs << "Empty:" << endl ;
          }
          else if ( cmpcommand ( "mid" ) )
          {
            if ( sw_mid )
            {
              err_eof ( p_file ) ;
            }
            sw_iammid = sw_mid = true ;
            l_ofs << "Mid:" << endl ;
          }
          else
          {
            if ( sw_ful )
            {
              err_eof ( p_file ) ;
            }
            sw_iamful = sw_ful = true ;
            l_ofs << "Full:" << endl ;
          }
          pbchar pbd ;
          bool sw_cg , sw_mc , sw_hv , sw_lv , sw_tf , sw_mtc ;
          sw_cg = sw_mc = sw_hv = sw_lv = sw_tf = false ;

          // motorcurr:  anteimotor ե饰Τ
          if ( ( ! sw_anteimotor ) || sw_iampower )
          {
            sw_mtc = true ;
          }
          else
          {
            sw_mtc = false ;
          }
          while ( ! ( sw_cg && sw_mc && sw_hv && sw_lv && sw_tf && sw_mtc ) )
          {
            if ( cmpcommand ( pbdata , "congestion" , p_file , true ) )
            {
              if ( sw_cg )
              {
                err_eof ( p_file ) ;
              }
              getdouble ( pbdata , p_file , pbd . conges ) ;
              o_x . clear () ;
              o_x . str ( "" ) ;
              o_x << fixed << setprecision ( 2 ) << pbd . conges ;
              l_ofs << "  conges = " << o_x . str () << endl ;
              sw_cg = true ;
            }
            else if ( cmpcommand ( "maximumcurrent" ) )
            {
              if ( sw_mc )
              {
                err_eof ( p_file ) ;
              }
              getdouble ( pbdata , p_file , pbd . mcurr ) ;
              o_x . clear () ;
              o_x . str ( "" ) ;
              o_x << fixed << setprecision ( 2 ) << pbd . mcurr ;
              l_ofs << "  maximum current = " << o_x . str () << endl ;
              sw_mc = true ;
            }
            else if ( cmpcommand ( "highvelocity" ) )
            {
              if ( sw_hv )
              {
                err_eof ( p_file ) ;
              }
              getdouble ( pbdata , p_file , pbd . highvel ) ;
              o_x . clear () ;
              o_x . str ( "" ) ;
              o_x << fixed << setprecision ( 2 ) << pbd . highvel ;
              l_ofs << "  high velocity = " << o_x . str () << endl ;
              sw_hv = true ;
            }
            else if ( cmpcommand ( "lowvelocity" ) )
            {
              if ( sw_lv )
              {
                err_eof ( p_file ) ;
              }
              getdouble ( pbdata , p_file , pbd . lowvel ) ;
              o_x . clear () ;
              o_x . str ( "" ) ;
              o_x << fixed << setprecision ( 2 ) << pbd . lowvel ;
              l_ofs << "  low velocity = " << o_x . str () << endl ;
              sw_lv = true ;
            }
            else if ( cmpcommand ( "tractionforce" ) )
            {
              if ( sw_tf )
              {
                err_eof ( p_file ) ;
              }
              getdouble ( pbdata , p_file , pbd . tracf ) ;
              o_x . clear () ;
              o_x . str ( "" ) ;
              o_x << fixed << setprecision ( 2 ) << pbd . tracf ;
              l_ofs << "  traction force = " << o_x . str () << endl ;
              sw_tf = true ;
            }
            else if ( cmpcommand ( "motorcurrent" ) )
            {
              if ( sw_mtc )
              {
                err_eof ( p_file ) ;
              }
              getdouble ( pbdata , p_file , pbd . motorcurr ) ;
              o_x . clear () ;
              o_x . str ( "" ) ;
              o_x << fixed << setprecision ( 2 ) << pbd . motorcurr ;
              l_ofs << "  motor current = " << o_x . str () << endl ;
              sw_mtc = true ;
            }
            else
            {
              err_eof ( p_file ) ;
            }
          }	// pbd ɤ߽

          if ( sw_iamemp )
          {
            l_ofs << "Empty data" << endl ;
            if ( sw_iampower )
            {
              p . pbempty = pbd ;
            }
            else
            {
              b . pbempty = pbd ;
            }
          }
          else if ( sw_iammid )
          {
            l_ofs << "Mid data" << endl ;
            if ( sw_iampower )
            {
              p . pbmid = pbd ;
            }
            else
            {
              b . pbmid = pbd ;
            }
          }
          else if ( sw_iamful )
          {
            l_ofs << "Full data" << endl ;
            if ( sw_iampower )
            {
              p . pbfull = pbd ;
            }
            else
            {
              b . pbfull = pbd ;
            }
          }
          else
          {
            l_ofs << "Unknown error" << endl ;
            cerr << "Unknown error" << endl ;
            exit ( 49 ) ;
          }	// pbd åȤ
        }
        else
        {
          err_eof ( p_file ) ;
        }
      }	// powerdata/brakedata ɤ߽
    }
    else if ( cmpcommand ( "autodata" ) )
    {
      // autodata 
      if ( sw_auto )
      {
        err_eof ( p_file ) ;
      }
      sw_auto = true ;
      bool sw_mv , sw_fv , sw_pm , sw_po , sw_rb , sw_rf ;
      sw_mv = sw_fv = sw_pm = sw_po = sw_rb = sw_rf = false ;
      while ( ! ( sw_mv && sw_fv && sw_pm && sw_po && sw_rb && sw_rf ) )
      {
        if ( cmpcommand ( pbdata , "minimumvelocity" , p_file , true ) )
        {
          if ( sw_mv )
          {
            err_eof ( p_file ) ;
          }
          getdouble ( pbdata , p_file , a . minvel ) ;
          o_x . clear () ;
          o_x . str ( "" ) ;
          o_x << fixed << setprecision ( 2 ) << a . minvel ;
          l_ofs << "autod.minvel = " << o_x . str () << endl ;
          sw_mv = true ;
        }
        else if ( cmpcommand ( "fullvelocity" ) )
        {
          if ( sw_fv )
          {
            err_eof ( p_file ) ;
          }
          getdouble ( pbdata , p_file , a . fullvel ) ;
          o_x . clear () ;
          o_x . str ( "" ) ;
          o_x << fixed << setprecision ( 2 ) << a . fullvel ;
          l_ofs << "autod.fullvel = " << o_x . str () << endl ;
          sw_fv = true ;
        }
        else if ( cmpcommand ( "powerlimitvoltage" ) )
        {
          if ( sw_pm )
          {
            err_eof ( p_file ) ;
          }
          getdouble ( pbdata , p_file , a . pminvol ) ;
          o_x . clear () ;
          o_x . str ( "" ) ;
          o_x << fixed << setprecision ( 1 )
              << ( a . pminvolx = a . pminvol ) ;
          l_ofs << "autod.pminvol = " << o_x . str () << endl ;
          sw_pm = true ;
        }
        else if ( cmpcommand ( "poweroffvoltage" ) )
        {
          if ( sw_po )
          {
            err_eof ( p_file ) ;
          }
          getdouble ( pbdata , p_file , a . poffvol ) ;
          o_x . clear () ;
          o_x . str ( "" ) ;
          o_x << fixed << setprecision ( 1 )
              << ( a . poffvolx = a . poffvol ) ;
          l_ofs << "autod.poffvol = " << o_x . str () << endl ;
          sw_po = true ;
        }
        else if ( cmpcommand ( "regenerationstartvoltage" ) )
        {
          if ( sw_rb )
          {
            err_eof ( p_file ) ;
          }
          getdouble ( pbdata , p_file , a . crbvol ) ;
          o_x . clear () ;
          o_x . str ( "" ) ;
          o_x << fixed << setprecision ( 1 ) << a . crbvol ;
          l_ofs << "autod.crbvol = " << o_x . str () << endl ;
          sw_rb = true ;
        }
        else if ( cmpcommand ( "regenerationfullvoltage" ) )
        {
          if ( sw_rf )
          {
            err_eof ( p_file ) ;
          }
          getdouble ( pbdata , p_file , a . crfvol ) ;
          o_x . clear () ;
          o_x . str ( "" ) ;
          o_x << fixed << setprecision ( 1 ) << a . crfvol ;
          l_ofs << "autod.crfvol = " << o_x . str () << endl ;
          sw_rf = true ;
        }
        else
        {
          err_eof ( p_file ) ;
        }
      }	// autodata ɤ߽
    }
// ¾
    else if ( cmpcommand ( "congestion" ) )
    {
      if ( sw_cong )
      {
        err_eof ( p_file ) ;
      }
      getdouble ( pbdata , p_file , cong ) ;
      o_x . clear () ;
      o_x . str ( "" ) ;
      o_x << fixed << setprecision ( 2 ) << cong ;
      l_ofs << "conges = " << o_x . str () << endl ;
      sw_cong = true ;
    }
    else if ( cmpcommand ( "auxcurrent" ) )
    {
      if ( sw_auxc )
      {
        err_eof ( p_file ) ;
      }
      getdouble ( pbdata , p_file , auxcurr ) ;
      o_x . clear () ;
      o_x . str ( "" ) ;
      o_x << fixed << setprecision ( 2 ) << auxcurr ;
      l_ofs << "aux. current = " << o_x . str () << endl ;
      sw_auxc = true ;
    }
    else if ( cmpcommand ( "setweight" ) )
    {
      if ( sw_setw )
      {
        err_eof ( p_file ) ;
      }
      gettwodbls ( pbdata , p_file , wta , wtb ) ;
      gettwodbls ( pbdata , p_file , wtc , wtd ) ;
      o_x . clear () ;
      o_x . str ( "" ) ;
      o_x << fixed << setprecision ( 2 ) << wta << " " << wtb << " "
          << wtc << " " << wtd ;
      l_ofs << "setweight = " << o_x . str () << endl ;
      sw_setw = true ;
    }
    else if ( cmpcommand ( "setrest" ) )
    {
      if ( sw_setr )
      {
        err_eof ( p_file ) ;
      }
      getthreedbls ( pbdata , p_file , rca , rcb , rcc ) ;
      getthreedbls ( pbdata , p_file , rcd , rce , rcf ) ;
      o_x . clear () ;
      o_x . str ( "" ) ;
      o_x << scientific << setprecision ( 3 ) << rca << " " << rcb << " "
          << rcc << " " << rcd << " " << rce << " " << rcf ;
      l_ofs << "setrsc = " << o_x . str () << endl ;
      sw_setr = true ;
    }
    else if ( cmpcommand ( "setmres" ) )
    {
      if ( sw_setm )
      {
        err_eof ( p_file ) ;
      }
      getthreedbls ( pbdata , p_file , mra , mrb , mrc ) ;
      getint ( pbdata , p_file , mrd ) ;
      o_x . clear () ;
      o_x . str ( "" ) ;
      o_x << fixed << setprecision ( 3 ) << mra << " " << mrb << " "
          << mrc << " " << mrd ;
      l_ofs << "setmres = " << o_x . str () << endl ;
      sw_setm = true ;
    }
    else
    {
      err_eof ( p_file ) ;
    }
  }
}
