// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// trnext.cc --- class train functions on nextmotion
// -----
// ChangeLog:
// 2007. 11. 22
//  Redirected log messages to l_file.
// -----

#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <iostream>

#include "train.hh"

#define INVLIM 1e-5

//#define DEBUG
//#define TIMEPRINT




// ®٤θ
bool
train :: vlimitbrake
()
{
  nextsta :: gc_size_type i = 0 ;
  for ( i = nxx -> dqgrad () ;
        ( i > pgrad && direc () == 1 ) || ( i < pgrad && direc () == - 1 ) ;
        i -= direc () )
  {
    if ( nxx -> vlimit ( i ) < INVLIM
         || nxx -> vlimit ( i ) >= nxx -> vlimit ( pgrad ) )
    {
      // ¤ʤΤȤ
      continue ;
    }

    if ( bklen ( pos , pgrad , vel , nxx -> vlimit ( i ) ) * direc ()
         >= nxx -> spoint ( i ) * direc () )
    {
      // ®ٸ®ξ
      stat = Brake ;
      brakev = nxx -> vlimit ( i ) ;
      rnotchold = rnotch = - 1.0 ;
      return true ;
    }
  }
  return false ;
}




// ֤μ֤η׻
void
train :: nextmotion
( double tracff )
{
  switch ( stat )
  {
  case Power :		// Ϲ
    nm_power ( tracff ) ;
    break ;
  case Coast :		// ƹ
    nm_coast ( tracff ) ;
    break ;
  case Regenerate :	//  (֥졼)
    nm_regen ( tracff ) ;
    break ;
  case Brake :		// ֥졼
    nm_brake ( tracff ) ;
    break ;
  case Stn_stop :	// 
    nm_stnstop ( tracff ) ;
    break ;
  case Between_stop :	// ش
    nm_stnbtws ( tracff ) ;
    break ;
  case Const_vel :	// ®
    nm_constv ( tracff ) ;
    break ;
  }
  if ( pos * direc() >= nxx -> nextswitch () * direc () )
  {
    setNextstaPointer ( nxx -> nextnxx () ) ;	// إǡ촹
  }
}
