// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// OBESS_CurrentCapper.hh
//  --- declaration of class OBESS_CurrentCapper and related classes
// -----
// ChangeLog:
// 2010. 1. 26
//  File created.
// -----


#ifndef OBESS_CurrentCappper_HH
#define OBESS_CurrentCappper_HH

#include "EnergyStorage.hh"


// -----
// OBESS class which actually have NO ability to store energy, only function
// being current capping. Test implementation.
// ֺܥͥ륮֥饹ͥ륮ѤϹԤͣεǽ
// ήԡǤ褦ʤΡƥȡץơ
// -----
class OBESS_CurrentCapper
  : public ESS_OnBoard ,
    public OBESS_Expander
{
private :

  double max_current_power ;
  double max_current_brake ;

  // Prohibiting use of default constructor.
  explicit OBESS_CurrentCapper () ;

public :

  // Constructors
  OBESS_CurrentCapper ( ESD_Initialiser const & ) ;
  OBESS_CurrentCapper ( OBESS_CurrentCapper const & ) ;

  // (virtual) destructor
  ~OBESS_CurrentCapper () ;

  // (virtual) function cloning itself
  OBESS_CurrentCapper * getMyClone ()
  { return new OBESS_CurrentCapper ( * this ) ; }

  // (virtual) operator=. Does nothing (variables need not be copied).
  OBESS_CurrentCapper & operator= ( ESS_OnBoard const & x )
  { return * this ; }

  // (virtual) function writing out to a CSV file
  void writeToCSV ( ostream & , bool ) const ;
  void writeHeaderToCSV ( ostream & , bool , string const & ) const ;

  // (virtual) function calculating current and di from voltage, etc. of
  // the converter of the substation.
  void calculateVoltagesAndCurrents ( train_ParamFunc * ) ;

  // (virtual) function to renew the states
  void calculateESDVoltageAndCurrent ( train_ParamFunc * ) ;

  // (virtual) function to renew the states
  void renewElectricalStates ( train_ParamFunc * ) ;

  // -----
  // (Virtual) function for regeneration limiter processing.
  // -----
  void processRegenerationLimiter ( train_ParamFunc * ) ;

  // -----
  // (Virtual) functions for interfacing. SOC is to be returned in
  // "per cent" (%).
  // -----
  double getCurrent () const { return 0 ; }
  double getDeltaI () const { return 0 ; }
  double getSOC () const { return 0 ; }
  double getEnergyCapacity () const { return 0 ; }
  void setStartSOC () {}
  void printSOCStoredResults
  ( ostream & , ostringstream & , ostringstream & ) const {}
} ;




// -----
// Creator of class OBESS_CurrentCapper.
// OBESS_CurrentCapper  Creator.
// -----
class OBESS_CurrentCapperCreator
  : public OBESS_Expander :: ObjectCreator
{
public :
  OBESS_CurrentCapperCreator ()
  { add_to_creators_list ( "current_capper" ) ; }
  OBESS_CurrentCapperCreator ( char const * x )
    : OBESS_Expander :: ObjectCreator () { add_to_creators_list ( x ) ; }
  OBESS_CurrentCapper * create () const
  {
    cerr << "Error: OBESS_CurrentCapper... default constructor prohibited"
         << endl ;
    exit ( 1 ) ;
  }
  OBESS_CurrentCapper * create ( ESS_Initialiser const & x ) const
  { return new OBESS_CurrentCapper ( x ) ; }
} ;



#endif	// OBESS_CurrentCappper_HH
