// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// diapatrn.cc --- class diapattern functions
// -----
// ChangeLog:
// 2007. 12. 14
//  delete [] bug in diapattern::setbuf(...)
// 2007. 11. 21
//  Redirected log messages to l_file.
// -----


#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <iostream>
#include <sstream>
#include <iomanip>
#include <algorithm>

#include "diapatrn.hh"

using std :: cerr ;
using std :: endl ;
using std :: ostringstream ;
using std :: setw ;
using std :: setprecision ;
using std :: fixed ;
using std :: right ;
using std :: sort ;



#define POWERRATEGREAT 0.2
#define TIMERATEGREAT 0.03
#define POWERRATEMEDIUM 0.1
#define TIMERATEMEDIUM 0.01
#define POWERRATELEAST 0.04	// setbuf ѥե饰
#define TIMERATELEAST 0.005	// setbuf ѥե饰

//#define DEBUG




// ----
// Destructor of _NextstaPtrs
// ----
_NextstaPtrs :: ~_NextstaPtrs
()
{
  for ( np_iterator ii = np_begin () ; ii < np_end () ; ++ ii )
  {
    if ( * ii )
    {
      delete * ii ;
    }
  }
}



// empty constructor
diapattern :: diapattern
()
  : _NextstaPtrs ()
{
  twhole = phase = pos = vel = tdept = taudx = 0 ;
  ndpt = cars = dptm = 0 ;
  stat = Power ;
  dcmd = No_comm ;
  bufss = bufset = false ;
}




// Хԡ
void
diapattern :: membercopy
( diapattern & dpx )
{
  twhole = dpx . twhole ;
  cars = dpx . cars ;
  phase = dpx . phase ;
  dptm = dpx . dptm ;
  pos = dpx . pos ;
  vel = dpx . vel ;
  stat = dpx . stat ;
  tdept = dpx . tdept ;
  taudx = dpx . taudx ;
  bufss = dpx . bufss ;
  bufset = dpx . bufset ;
  dcmd = dpx . dcmd ;
  ndpt = dpx . ndpt ;
  train_type_key = dpx . train_type_key ;

}

// X(X&)
diapattern :: diapattern
( diapattern & dpx )
  : _NextstaPtrs ( dpx )
{
  membercopy ( dpx ) ;
}



// 黻
diapattern &
diapattern :: operator=
( diapattern & dpx )
{
  if ( & dpx == this )
    return * this ;
  _NextstaPtrs :: operator= ( dpx ) ;
  membercopy ( dpx ) ;
  return * this ;
}



// nextsta object  nxx 򥻥å
void
diapattern :: nextnxx
()
{
  // nxx: ΡּإǡפؤΥݥ
  for ( diapattern :: np_iterator i = np_begin () ; i < np_end () - 1 ; ++ i )
  {
    if ( ! * i )
    {
      cerr << "Error in diapattern::nextnxx(): diapattern having null pointer"
           << endl ;
      exit ( 1 ) ;
    }
    ( * i ) -> set_nextnxx ( * ( i + 1 ) ) ;
  }
  ( * ( np_end () - 1 ) ) -> set_nextnxx ( * np_begin () ) ;
}



// nextsta object ֹ򶵤
void
diapattern :: setnxx
()
{
  int j = 0 ;
  for ( diapattern :: np_iterator i = np_begin () ; i < np_end () ; ++ i )
  {
    if ( ! * i )
    {
      cerr << "Error in diapattern::setnxx(): diapattern having null pointer"
           << endl ;
      exit ( 1 ) ;
    }
    ( * i ) -> set_ndpt ( ndpt ) ;  // ndpt  diapattern ֹ
    ( * i ) -> set_ndp ( j ) ;	    // ndp  diapattern ֹ
    ++ j ;
  }
}



// dcmd Υå
void
diapattern :: setdc
( dp_command x )
{
  dcmd = x ;
  for ( diapattern :: np_iterator i = np_begin () ; i < np_end () ; ++ i )
  {
    if ( ! * i )
    {
      cerr << "Error in diapattern::setdc(): diapattern having null pointer"
           << endl ;
      exit ( 1 ) ;
    }
    // diapattern ⤹٤Ʊ
    ( * i ) -> setdc ( dcmd ) ;
  }
}



void
diapattern :: prtinit
()
{
  for ( diapattern :: np_iterator i = np_begin () ; i < np_end () ; ++ i )
  {
    if ( ! * i )
    {
      cerr << "Error in diapattern::prtinit(): diapattern having null pointer"
           << endl ;
      exit ( 1 ) ;
    }
    ( * i ) -> prtinit () ;
  }
}



void
diapattern :: prtreset
()
{
  for ( diapattern :: np_iterator i = np_begin () ; i < np_end () ; ++ i )
  {
    if ( ! * i )
    {
      cerr << "Error in diapattern::prtreset(): diapattern having null pointer"
           << endl ;
      exit ( 1 ) ;
    }
    ( * i ) -> prtreset () ;
  }
}



struct bufsort
{
  double prate ;
  diapattern :: np_size_type i ;
  double bz ;
} ;



// setbuf ѥȥץ
// int sortbuff
// ( const void * ax ,
//   const void * bx )
// {
//   bufsort * a = ( bufsort * ) ax ;
//   bufsort * b = ( bufsort * ) bx ;
//   if ( a -> prate > b -> prate ) return 1 ;
//   else if ( a -> prate < b -> prate ) return -1 ;
//   else return 0 ;
// }
class _SortBuff
{
public :
  bool operator () ( bufsort const & ax ,
                     bufsort const & bx ) const
  { return ax . prate < bx . prate ; }
} ;



// ;͵ʬĴ
bool
diapattern :: setbuf
()
{
  //**********************************************************************
  // εǽϹڤν1992ˤθΤդä줿ǽܺ٤
  // رطϸŵ칶ʸˤ򻲾Ȥ衣
  // 1994ǯʳǤϤ⤦ΤȤ˺äϤ ^_^;
  //**********************************************************************
  if ( dcmd != Buffer_yes )
      return true ;		// Buffer_yes Τ
  if ( bufset )
    return true ;
  for ( diapattern :: np_iterator i = np_begin () ; i < np_end () - 1 ; ++ i )
  {
    if ( ! * i )
    {
      cerr << "Error in diapattern::setbuf(): diapattern having null pointer"
           << endl ;
      exit ( 1 ) ;
    }
    //  ٤Τ
    if ( ! ( * i ) -> prtset () )
    {
      return true ;
    }
  }
  // static bufsort * bsort = new bufsort [ np_size () ] ;
  // static int bsortm = np_size () ;
  // double bufm = 0.0 ;
  // if ( bsortm < np_size () )
  // {
  //   delete [] bsort ;
  //   bsort = new bufsort [ bsortm = np_size () ] ;
  // }
  double bufm = 0.0 ;
  vector < bufsort > bsort ;
  bsort . reserve ( np_size () ) ;
  for ( np_size_type i = 0 ; i < np_size () ; ++ i )
  {
    bufsort x ;
    x . i = i ;
    x . bz = 0.0 ;
    // bsort [ i ] . i = i ;
    // bsort [ i ] . bz = 0.0 ;
    bufm += x . prate = getElement ( i ) -> prate () ;
    bsort . push_back ( x ) ;
  }
  bufm /= np_size () ;
  // qsort ( bsort , np_size () , sizeof ( bufsort ) , & sortbuff ) ;
  sort ( bsort . begin () , bsort . end () , _SortBuff () ) ;
  
  np_size_type gl = 0 ;
  np_size_type ml = 0 ;
  np_size_type ll = 0 ;
  np_size_type lg = 0 ;
  np_size_type mg = 0 ;
  np_size_type gg = 0 ;
  for ( np_size_type i = 0 ; i < np_size () ; ++ i )
  {
    if ( bsort [ i ] . prate > bufm - POWERRATEGREAT )
    {
      gl = i ;
    }
    else
    {
      continue ;
    }
    if ( bsort [ i ] . prate > bufm - POWERRATEMEDIUM )
    {
      ml = i ;
    }
    else
    {
      continue ;
    }
    if ( bsort [ i ] . prate > bufm - POWERRATELEAST )
    {
      ll = i ;
      break ;
    }
  }
  for ( np_size_type i = np_size () - 1 ; i >= 0 ; -- i )
  {
    if ( bsort [ i ] . prate < bufm + POWERRATEGREAT )
      gg = i ;
    else continue ;
    if ( bsort [ i ] . prate < bufm + POWERRATEMEDIUM )
      mg = i ;
    else continue ;
    if ( bsort [ i ] . prate < bufm + POWERRATELEAST )
    {
      lg = i ;
      break ;
    }
  }

  double bufzl = 0.0 ;
  double bufzg = 0.0 ;
  for ( np_size_type i = 0 ; i < gl ; ++ i )
    bufzl += getElement ( bsort [ i ] . i ) -> tarrive ( true )
      * TIMERATEGREAT ;
  for ( np_size_type i = gl ; i < ml ; ++ i )
    bufzl += getElement ( bsort [ i ] . i ) -> tarrive ( true )
      * TIMERATEMEDIUM ;
  for ( np_size_type i = ml ; i < ll ; ++ i )
    bufzl += getElement ( bsort [ i ] . i ) -> tarrive ( true )
      * TIMERATELEAST ;
  for ( np_size_type i = np_size () - 1 ; i > gg ; -- i )
    bufzg += getElement ( bsort [ i ] . i ) -> tarrive ( true )
      * TIMERATEGREAT ;
  for ( np_size_type i = gg ; i > mg ; -- i )
    bufzg += getElement ( bsort [ i ] . i ) -> tarrive ( true )
      * TIMERATEMEDIUM ;
  for ( np_size_type i = mg ; i > lg ; -- i )
    bufzg += getElement ( bsort [ i ] . i ) -> tarrive ( true )
      * TIMERATELEAST ;

  for ( np_size_type i = 0 ; i < gl ; ++ i )
  {
    bsort [ i ] . bz = - getElement ( bsort [ i ] . i ) -> tarrive ( true ) ;
    bsort [ i ] . bz *= TIMERATEGREAT ;
    bsort [ i ] . bz /= bufzl ;
  }
  for ( np_size_type i = gl ; i < ml ; ++ i )
  {
    bsort [ i ] . bz = - getElement ( bsort [ i ] . i ) -> tarrive ( true ) ;
    bsort [ i ] . bz *= TIMERATEMEDIUM ;
    bsort [ i ] . bz /= bufzl ;
  }
  for ( np_size_type i = ml ; i < ll ; ++ i )
  {
    bsort [ i ] . bz = - getElement ( bsort [ i ] . i ) -> tarrive ( true ) ;
    bsort [ i ] . bz *= TIMERATELEAST ;
    bsort [ i ] . bz /= bufzl ;
  }
  for ( np_size_type i = np_size () - 1 ; i > gg ; -- i )
  {
    bsort [ i ] . bz = getElement ( bsort [ i ] . i ) -> tarrive ( true ) ;
    bsort [ i ] . bz *= TIMERATEGREAT ;
    bsort [ i ] . bz /= bufzg ;
  }
  for ( np_size_type i = gg ; i > mg ; -- i )
  {
    bsort [ i ] . bz = getElement ( bsort [ i ] . i ) -> tarrive ( true ) ;
    bsort [ i ] . bz *= TIMERATEMEDIUM ;
    bsort [ i ] . bz /= bufzg ;
  }
  for ( np_size_type i = mg ; i > lg ; -- i )
  {
    bsort [ i ] . bz = getElement ( bsort [ i ] . i ) -> tarrive ( true ) ;
    bsort [ i ] . bz *= TIMERATELEAST ;
    bsort [ i ] . bz /= bufzg ;
  }

  if ( bufzl > bufzg )
    bufzl = bufzg ;

  for ( np_size_type i = 0 ; i < np_size () ; ++ i )
  {
    gg = bsort [ i ] . i ;
    bufzg = bsort [ i ] . bz * bufzl ;
    getElement ( gg ) -> setbuf ( bufzg ) ;
  }
  prtreset () ;
  if ( bufss )
    bufset = true ;
  else
    bufss = true ;
  return false ;
}



// phase ׻ľ֤ˡ­碌פΤˤ
void
diapattern :: realphase_cal
()
{
  addphase = - phase ;
  while ( addphase < - INVLIM )
    addphase += twhole / cars ;
  ostringstream cx ;
  cx . clear () ;
  cx . str ( "" ) ;
  cx << "Diapattern " << ndpt << ": real phase = " << setprecision ( 3 )
     << fixed << setw ( 10 ) << right << addphase ;
  l_ofs << cx . str () << endl ;
  return ;
}
