// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Prof. SONE's Laboratory, the Univ. of Tokyo.)
// feed_y.cc --- class feed_y functions
// $Id: feed_y.cc,v 2.4 1994/12/27 12:03:47 rt Exp $

#include <cstdio>
#include <cmath>
#include <cstdlib>

#include "feed_y.hh"



// 
_BN_Container &
_BN_Container :: operator=
( _BN_Container const & x )
{
  if ( & x == this )
    return * this ;

  vector < bran_node > :: operator= ( x ) ;
  return * this ;
}



// Operator +=
_BN_Container &
_BN_Container :: operator+=
( bran_node const & x )
{
  push_back ( x ) ;
  return * this ;
}



// Operator +=
_BN_Container &
_BN_Container :: operator+=
( _BN_Container const & x )
{
  if ( & x == this )
  {
    cerr << "Error: _BN_Container::operator+= must not be performed on itself"
         << endl ;
    exit ( 1 ) ;
  }

  for ( vector < bran_node > :: const_iterator ii = x . begin () ;
        ii < x . end () ; ++ ii )
  {
    push_back ( * ii ) ;
  }
  return * this ;
}



// X(X&)
feed_y :: feed_y
( feed_y const & x )
  : _BN_Container ( x ) ,
    hh ( x . hh ) ,
    ht ( x . ht ) ,
    dy ( x . dy )
{
}



// 
feed_y &
feed_y :: operator=
( feed_y const & x )
{
  if ( & x == this )
    return * this ;

  _BN_Container :: operator= ( x ) ;
  hh = x . hh ;
  dy = x . dy ;
  ht = x . ht ;

  return * this ;
}



// ֥ɥߥ󥹹
diagmatrix &
feed_y :: diag_y
()
{
  dy . renewmn ( bn_size () ) ;
  for ( diagmatrix :: size_type i = 0 ; i < bn_size () ; ++ i )
  {
    dy ( i ) = 1.0 / getElement ( i ) . impedance ;
  }
  return dy ;
}



// ݻ³, : ncss
matrix &
feed_y :: h
( int ncss )
{
  hh . renewmn ( ncss , bn_size () ) ;
  for ( matrix :: size_type i = 0 ; i < bn_size () ; ++ i )
  {
    hh ( getElement ( i ) . startnode , i ) += 1 ;
    hh ( getElement ( i ) . endnode , i ) += - 1 ;
  }
  return hh ;
}



// ٹ, : ncss, ymtx
void
feed_y :: y
( int ncss ,
  matrix & _ymtx )
{
  h ( ncss ) ;	// ³η׻, ̤ hh ˳ǼƤ
  matrix _ht ;
  hh . transpose ( _ht ) ;    // ³ž֤
  matrix _zz = hh * diag_y () ;
  _ymtx = _zz * _ht;	    // Y = H * D * H^T
}
