// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Prof. SONE's Laboratory, the Univ. of Tokyo.)
// trn_coas.cc --- class train functions on nextmotion: nm_coast
// $Id: trn_coas.cc,v 2.4 1994/12/27 12:03:47 rt Exp $

#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <iostream>

#include "train.hh"

#define INVLIM 1e-5

//#define DEBUG

#define DELAY_ALLOWED 	3	// Ec_auto ƹ˵٤[sec]
	// ƹΥͥ륮ֵѤˤ٥٤ɻߤΤ

// ƹԻμֱ黻
void
train :: nm_coast
( double tracff )
{

  // tracff *= emrn ;
  enableMechanicalPowerCalculation () ;
  npos ( tracff ) ;	// ֱ黻
  disableMechanicalPowerCalculation () ;

  if ( g_sw_station_object_valid && g_sw_disttrain_ended )
  {
    if ( pos * direc ()
         >= nxx -> parrive () * direc () - nxx -> out_of_station () )
    {
      sw_x_btws = false ;	// ش֤߰᤮ǧ
    }
  }

  if ( nxx -> nxxptn () == Pass_pass
       || nxx -> nxxptn () == Station_pass )
  {
    // ̲ξ
    if ( nm_nxxps () )
    {
      // إǡ
      return ;
    }
  }

  if ( bklen () * direc () >= nxx -> parrive () * direc () )
  {
    // ե֥졼ξ
    stat = Brake ;
    brakev = nxx -> varrive () ;
    rnotchold = rnotch = - 1.0 ;
    return ;
  }

  if ( g_sw_station_object_valid && g_sw_disttrain_ended )
  {
    // ͭΤߥå

    double bkl_drx = bklen ( 0.0 ) * direc () ;

    if ( bkl_drx >= nxx -> parrive () * direc () - nxx -> out_of_station ()
         // && g_sw_stop_between_oriented -> ¤Ϥʤ
         && nxx -> stnobj () -> voie_occupied ( this ) )
    {
      // ե֥졼ξ: out_of_station ΰ֤ޤǤ
      // **** ش߻ظξ礫ı̤̤
      // **** out_of_station ΰ֤ޤǤ®0ˤʤʤ
      stat = Brake ;
      brakev = 0.0 ;	// ɸ®: 
      sw_btws = true ;	// شߤΤΥ֥졼ʤΤ true
      sw_x_btws = false ;	// ش֤߰᤮ǧ
      rnotchold = rnotch = - 1.0 ;
      return ;
    }
  }

  if ( vlimitbrake () )
  {
    //  brake Ƚ
    return ;
  }
  
  if ( nm_stnobj_brake () )
  {
    // ؤˤ֥졼
#ifdef DEBUG
    cerr << "car " << cs_number () << " stnobj_brake" << endl ;
#endif
    return ;
  }

  if ( nm_stnobj_power () )
  {
    // ؤˤϹ
#ifdef DEBUG
    cerr << "car " << cs_number () << " stnobj_power" << endl ;
#endif
    return ;
  }

  if ( cpsww )
  {
    // Իʬ礻ΤϹ/
    cpsw = true ;
  }
  
  if ( cpsw && rnotch < INVLIM )
  {
    // (Ec_auto mode)
    double ontx = ontimesub ( pos , pgrad , vel , t_sim ) ;

    double x_tard = 0.0 ;	// ٤ʬδ
    if ( g_sw_station_object_valid && g_sw_disttrain_ended )
    {
      // ͭΤߥå
      // **** nxx -> tarr_delay( this ) : ̵ zero ʤΤ
      x_tard = nxx -> tarr_delay( this ) ;	// 줬̾
      if ( g_sw_stop_between_oriented && sw_x_btws )
      {
        // ش߻ظǱش֤߰᤮Ƥʤ
        x_tard = 0.0 ;	// ٤ʤȤƥѥ
      }
    }

    if ( ontx - tdept + taudx < nxx -> tarrive( pfirst ) + x_tard )
    {
      l_ofs << "car " << carno << ": REGENERATE" << endl ;
      // Τ߾֤ؤž
      stat = Regenerate ;
      rnotchold = rnotch = - 1.0 ;
      iamcoast = false ;			// Τΰ
      iamconst = false ;
    }
    else if ( ontx - tdept + taudx > nxx -> tarrive( pfirst )
              + x_tard + DELAY_ALLOWED )
    {
      	// ٥٤Ƚ
      iamcoast = false ;				// Ϲΰ
      iamconst = true ;
      cpsw = false ;				// cpsw ꥻå
      if ( vel >= nxx -> vlimit ( pgrad ) && nxx -> vlimit ( pgrad ) >= INVLIM
           && tresist ( vel , pgrad ) < 0 )
      {
        // ®¤ˤ뢪®Ԥž
        stat = Const_vel ;
        return ;
      }
      stat = Power ;				// ϹԾ֤ž
      rnotchold = rnotch = 1.0 ;
      ontprec = nxx -> get_ontprec () ;
      return ;
    }
  }

  if ( vel >= nxx -> vlimit ( pgrad ) && nxx -> vlimit ( pgrad ) >= INVLIM
       && tresist ( vel , pgrad ) < 0 )
  {
    // ۤˤ®پ徺®¤ˤä
    stat = Const_vel ;	// ®Ԥž
    iamcoast = true ;	// ƹΰ
    iamconst = false ;
    return ;
  }

  if ( cpsw )
  {
    cpsw = false ;
  }
}
