// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Prof. SONE's Laboratory, the Univ. of Tokyo.)
// feeder.cc --- class feeder functions
// $Id: feeder.cc,v 2.4 1994/12/27 11:47:32 rt Exp $


#include <cstdio>
#include <cstdlib>
#include <cmath>

#include "kidenrt.hh"

//#define DEBUG

feeder :: feeder
()
 : ymtx () ,
   feedy () ,
   gff_xx () ,
   gamma () ,
   fvec () ,
   vec_dpt () ,
   vec_fln () ,
   vec_csd () ,
   vec_gcv () ,
   vec_sub () ,
   _trd () ,
   _soc () ,
   _xread ()
{
  // empty constructor
  feeders = ncar = nss = ncss = ndp = ngrad = 0;
  delta = 10.0;

  // CSV output file -- mainly for Mr Nogi. Hence, csvout_nogi...
  if ( use_c_file && ! csvout_nogi . is_open () )
  {
    csvout_nogi . open ( c_file ) ;
  }
  nogi_header_required = true ;

  // Creator registration to _xread
  _xread [ "soc_feedforward_data" ] = & _soc ;
}




// X(X&) ػ
feeder :: feeder
( const feeder & x )
{
  l_ofs << "Error: initialization of class feeder object "
        << "by another class feeder object prohibited" << endl ;
  cerr << "Error: initialization of class feeder object "
       << "by another class feeder object prohibited" << endl ;
  exit ( 20 ) ;	// error 20: ֥Ƚػߥ顼
}

// ػ
feeder &
feeder :: operator=
( const feeder & x )
{
  l_ofs << "Error: replacement of class feeder object "
        << "by another class feeder object prohibited" << endl ;
  cerr << "Error: replacement of class feeder object "
       << "by another class feeder object prohibited" << endl ;
  exit ( 20 ) ;	// error 20: ֥Ƚػߥ顼
  return * this ;	// -Wall warning 򤱤뤿
}



// destructor
feeder :: ~feeder
()
{
}



// train ֥Ȥ emccal ѿ k ˥å
// void
// feeder :: emcc
// ( bool k )
// {
//   for ( int i = 0 ; i < ncar ; ++ i )
//   {
//     getCAR ( i ) . emgc () = k ;
//   }
// }


// runtrain, disttrain Υ֥ץ
void
feeder :: runtrsub
( int i )
{
  double tracff = getCAR ( i ) . getTractiveEffort () ;
  getCAR ( i ) . nextmotion ( tracff ) ;
}

// ֤餻
void feeder::runtrain
() {
    for (register int i = 0; i < ncar; i++) {
	runtrsub(i);
    }
}


// rnotch η׻
void
feeder :: notchrate
()
{
  for ( int i = 0 ; i < ncar ; ++ i )
  {
    getCAR ( i ) . teta_v_only () ;
    getCAR ( i ) . notchrate () ;
  }
}
