// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Prof. SONE's Laboratory, the Univ. of Tokyo.)
// ffunc.cc --- class feeder functions: ffunc, gradf
// $Id: ffunc.cc,v 2.4 1994/12/27 12:03:47 rt Exp $


#include <cstdio>
#include <cstdlib>
#include <cmath>

#include "kidenrt.hh"

//#define DEBUG



// grad  
void
feeder :: gradf
()
{
  matrix :: size_type i ;
  matrix :: size_type j ;

  // gff ѿ
  gff_xx . renewmn ( ncss , ncss ) ;
  gamma . renewmn ( ncss ) ;

  for ( i = 0 ; i < ncss ; ++ i )
  {
    for ( j = 0 ; j < ncss ; ++ j )
    {
      // gff η׻
      gff_xx ( j , i ) = ymtx ( j , i ) * getCSD ( i ) -> dgva () ;
      if ( j == i )
        gff_xx ( j , i ) -= getCSD ( i ) -> duva () ;
    }
  }
}



//  ؿ, : fvec ٥ȥ
double
feeder :: ffunc
( matrix & fvv )
{
  matrix :: size_type i ;
  matrix :: size_type j ;
  double x ;
  double ff ;

  // ήŰ٥ȥη
  for ( i = 0 ; i < ncss ; ++ i )
  {
    // teta  volt, ampere ؤѴ
    getCSD ( i ) -> teta_vi () ;
  }

  // f = u - y * g
  for ( i = 0 ; i < ncss ; ++ i )
  {
    fvv ( i ) = 0.0 ;
    for ( j = 0 ; j < ncss ; ++ j )
    {
      fvv ( i ) += ymtx ( i , j ) * getCSD ( j ) -> gva () ;
    }
    fvv ( i ) -= getCSD ( i ) -> uva () ;
  }
  ff = 0.0 ;
  for ( i = 0 ; i < ncss ; ++ i )
  {
    x = fabs ( fvv ( i ) ) ;
    if ( ff < x )
    {
      ff = x ;
    }
  }
  return ff ;
}
