// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// matrix.hh --- class matrix, class diagmatrix
// -----
// ChangeLog:
// 2008. 7. 7
//  Included many features for speed-ups.
// 2008. 7. 6
//  Improved speed of matrix::eqnsolve(). Re-designed both matrix and
//  diagmatrix classes so that they are derived from vector < double > .
// 2007. 11. 22
//  Removed fprintf(...).
// -----

#ifndef ___MATRIX_HH
#define ___MATRIX_HH	// Ƥ2٥󥯥롼ɤƤס

#include <cstdio>
#include <cstdlib>
#include <vector>
#include <iostream>

using std :: cerr ;
using std :: endl ;
using std :: vector ;


class diagmatrix ;


// ----
// class matrix: matrix calculations
// class matrix: Ȥα黻饹
// ----
class matrix
  : public vector < double >
{
  // ----
  // Basic informatio for the matrix this object holds
  // Υ֥Ȥݻ˴ؤܾ
  // ----
  size_type m ;			// rows / 
  size_type n ;			// columns / 

  // ----
  // Row order information for LU decomposition
  // LUʬˤؤ
  // ----
  vector < size_type > ip ;

  bool LU_decomposed ;		// true if LU decomposition is done

  // ----
  // Private member functions
  // ץ饤١ȥдؿ
  // ----
  void swapf ( double & , double & ) ;	// Swapping variables / ѿ
  void matrixinst ( size_type , size_type ) ; // Initialising / 
    
public :

  // ----
  // Constructors.
  // 󥹥ȥ饯
  // ----
  matrix ( size_type mm , size_type nn )
    : ip () , LU_decomposed ( false ) { matrixinst ( mm , nn ) ; }

  explicit matrix ( size_type mm )
    : ip () , LU_decomposed ( false ) { matrixinst ( mm , 1 ) ; }

  matrix ()
    : vector < double > () , ip () , LU_decomposed ( false )
  { m = n = 0 ; }

  ~matrix () {}		// destructor

  matrix ( const matrix & ) ;	// Ȥˤ
    
  double & operator() ( size_type i , size_type j = 0 ) {	// Ǥλ
    if ( i < 0 || j < 0 || i >= m || j >= n ) {
      cerr << "Error: subscript out of range in matrix element call" << endl ;
      exit ( 1 ) ;
    }
    return ( * this ) [ i * n + j ] ;
  }
    
  double element ( size_type i , size_type j = 0 ) const {	// Ǥλ
    if ( i < 0 || j < 0 || i >= m || j >= n ) {
      cerr << "Error: subscript out of range in matrix element call" << endl ;
      exit ( 2 ) ;
    }
    return ( * this ) [ i * n + j ] ;
  }
    
  // ----
  // Minus sign.
  // ޥʥ
  // ----
  matrix operator- () ;
    
  // ----
  // Substitution operators.
  // Ԥ黻ҷ
  // ----
  matrix & operator= ( const matrix & ) ;	// Substitution / 黻
  matrix & operator+= ( const matrix & ) ;
  matrix & operator+= ( const diagmatrix & ) ;	// Addition / ä
  matrix & operator-= ( const matrix & ) ;
  matrix & operator-= ( const diagmatrix & ) ;	// Subtraction / 
  matrix & operator*= ( const matrix & ) ;
  matrix & operator*= ( const diagmatrix & ) ;	// Multiplication / ݤ
  matrix & operator*= ( double ) ;
    
  // ----
  // Old LU decomposition implementation (1992 by RT...)
  // LUʬˤ켡θŤץơ (1992 by RT...)
  // ----
//   int eqnsolve () ;
//   int inverse () ;	// Inverse matrix / չ

  // ----
  // New LU decomposition implementation. Reference: Numerical Recipe.
  // LUʬˤ켡롼
  // ----
  int decompose_LU () ;
  int eqnsolve ( const matrix & , matrix & ) ;
  int inverse ( matrix & ) ;
  void resetLUDecompFlag () { LU_decomposed = false ; }

  // ----
  // Transposition. Result will be stored in the object given as argument.
  // ž̤֡ϰȤͿ֥Ȥ˳Ǽ롣
  // ----
  void transpose ( matrix & ) ;
    
  void renewmn ( size_type , size_type = 1 ) ;	// ԡѹ
  void renew ( double = 0.0 ) ;
  size_type row () const { return m ; }	// Կ
  size_type col () const { return n ; }	// 
    
  // Dividing the matrix into four / 򣴤Ĥʬ
  void quaddiv
  ( size_type , size_type , matrix & , matrix & , matrix & , matrix & ) ;

  // Concatenating four matrices to one / ʬ䤵줿41Ĥ˷
  void quadjoin ( matrix & , matrix & , matrix & , matrix & ) ;

  friend matrix operator* ( const diagmatrix & , const matrix & ) ;
  friend matrix operator* ( const matrix & , const diagmatrix & ) ;
  friend matrix operator* ( const matrix & , const matrix & ) ;
  friend matrix operator+ ( const matrix & , const matrix & ) ;
  friend matrix operator- ( const matrix & , const matrix & ) ;
  friend matrix operator* ( double , const matrix & ) ;

} ;




// ----
// class diagmatrix: diagonal matrix calculations
// class diagmatrix: гѹȤα黻饹
// ----
class diagmatrix
  : public vector < double >
{
  size_type m ;	//  = 
  double x ;    // = 0.0

public :

  diagmatrix ( size_type ) ;	// constructor: : m
  diagmatrix () : m ( 0 ) , x ( 0.0 ) {}	// empty constructor
  ~diagmatrix () {}	// destructor

  diagmatrix ( const diagmatrix & ) ;	// Ȥˤ
    
  double & operator() ( size_type i , size_type j ) {	// Ǥλ
    x = 0.0 ;
    if ( i < 0 || j < 0 || i >= m || j >= m ) {
      cerr << "Error: subscript out of range in diagmatrix element call" 
           << endl ; exit ( 1 ) ;
    } else if ( i != j ) return x ;
    else return ( * this ) [ i ] ;
  }

  double & operator() ( size_type i ) {		// Ǥλ
    if ( i < 0 || i >= m ) {
      cerr << "Error: subscript out of range in diagmatrix element call"
           << endl ; exit ( 2 ) ;
    }
    return ( * this ) [ i ] ;
  }

  double element ( size_type i , size_type j ) const {	// Ǥλ
    if ( i < 0 || j < 0 || i >= m || j >= m ) {
      cerr << "Error: subscript out of range in diagmatrix element call"
           << endl ; exit ( 3 ) ;
    } else if ( i != j ) return 0.0 ;
    else return ( * this ) [ i ] ;
  }

  double element ( size_type i ) const {	// Ǥλ
    if ( i < 0 || i >= m ) {
      cerr << "Error: subscript out of range in diagmatrix element call"
           << endl ; exit ( 4 ) ;
    } else return ( * this ) [ i ] ;
  }

  diagmatrix & operator= ( const diagmatrix & ) ;	// 黻

  // ----
  // Minus sign.
  // ޥʥ
  // ----
  diagmatrix operator- () ;

  // ----
  // Substitution operators.
  // Ԥ黻ҷ
  // ----
  diagmatrix & operator+= ( const diagmatrix & ) ;
  diagmatrix & operator-= ( const diagmatrix & ) ;
  diagmatrix & operator*= ( const diagmatrix & ) ;
  diagmatrix & operator*= ( double ) ;

  // ----
  // Calculation of inverse matrix.
  // չ
  // ----
  int inverse () ;

  void renewmn ( size_type ) ;		// ԡѹ

  size_type row () const { return m ; }	// Կ
  size_type col () const { return m ; }	// 

  friend diagmatrix operator* ( const diagmatrix & , const diagmatrix & ) ;
  friend matrix operator* ( const diagmatrix & , const matrix & ) ;
  friend matrix operator* ( const matrix & , const diagmatrix & ) ;

  friend diagmatrix operator* ( double , const diagmatrix & ) ;

} ;




// ----
// Operators
// 黻ҷ
// ----
matrix operator+ ( const matrix & , const matrix & ) ;
matrix operator- ( const matrix & , const matrix & ) ;
matrix operator* ( const matrix & , const matrix & ) ;
matrix operator* ( const diagmatrix & , const matrix & ) ;
matrix operator* ( const matrix & , const diagmatrix & ) ;
diagmatrix operator* ( const diagmatrix & , const diagmatrix & ) ;
matrix operator* ( double , const matrix & ) ;
diagmatrix operator* ( double , const diagmatrix & ) ;


#endif /* ! ___MATRIX_HH */
