// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Prof. SONE's Laboratory, the Univ. of Tokyo.)
// sigobj.hh --- class signalling and related classes and structs
// $Id: sigobj.hh,v 2.4 1994/12/27 12:03:47 rt Exp $

#include "globvar.hh"
#include "readdata.hh"
#include "NoRefTable.hh"
#include "enumerat.hh"

#ifndef ___SIGOBJ_HH
#define ___SIGOBJ_HH		// Ƥ2٥󥯥롼ɤƤס

// ƻϩ֥
struct railsigcell {
    double stp;		// ֳ
    double endp;	// ֽλ ; endp > stp
    int trainhere;	// ֺ: true
    int trainnum;	// ֹ ( ! trainhere ΤȤ̵̣ )
    double vlimit;	// ®
};

// ذ֤˴ؤǡ
class 
: public NoRefTable<gcvel>, public readdata {

// ѿʤ
//	gcvel* gxx;	// ۶ǡ
//	int gmax;	// ۶ǡθĿ
//	int gmem;	// ǡΤ˳ݤκ
// ؿ

  private:
    void error26_name() {
	fprintf(stderr, "Error: subscript out of range in\n");
	fprintf(stderr, "       gradcrv object gcvel data call\n");
    }

  public:
    gradcrv(): NoRefTable<gcvel>() {}			// constructor
    // destructor ʤ
    gradcrv(gradcrv& x): NoRefTable<gcvel>(x) {}	// constructor: X(X&)
    gradcrv& operator=(gradcrv&);  	// ѱ黻ҤΥС
    gradcrv& operator+=(gcvel&);	// gcvel ɲáʥǡåա
    gradcrv& operator+=(gcvel);		// gcvel ɲáʥǡåա
    gradcrv& renewpos(int, double);	// gcvel ǡν

    int readfile(FILE*);	// ե꡼
};

gradcrv& operator+(gradcrv&, gradcrv&);	// 2ĤĤʤfriend ס

class train;
class feeder;
class diapattern;

// αؤޤǤԤ˴ؤǡ
class nextsta
: public gradcrv {

  private:

// ѿ
    int direc;  	// 
    double startp;	// ȯ
    double arp;		// ã
    double arv; 	// ɸ®, nxp = Pass_station  nonzero 
    double art;		// ã
    int nfline;  	// ֹ
    nextsta_pattern nxp;	// ؾˡ
    double tstop;	// ֻ
    double vnoff;	// Υå®١ʰȤȤʤ
    int ndpt;	// diapattern ֹ
    int ndp;	// diapattern ֹ
    double nextsw;	// Υǡؤ
    nextsta* nxx;	// μإǡ
    double bufcont;	// ;͵ʬĴѿ
    double prt;		// ϹΨ
    bool setprt;	// ϹΨåȤ true
    double pfcont;	// pfi ܤϹ/Τ ޤǤϱشԻʬ򶸤碌
    int pfi;		// Իʬ碌򤷤
    dp_command dcmd;	// ѿ
    double conges;	// Ψ g_sw_conges_station  true ΤȤΤͭ
    bool ontprec;	// ζ֤Ϻǽ餫 ontime_prec ǻֹ碌

    // ѿɬפʤ
    NoRefTable<int> greq_gnum;		// gradcrv Τʤֹ
    NoRefTable<int> greq_renposf;	// renewpos ΤΥե饰
    NoRefTable<double> greq_gzpos;	// renewpos ΤιΥ
    int greq_x;				// ׵桢ǽϥ

    // ѿϾ copy ޥɤǽǤ褦ˤʤäȤΤ
    bool sw_nreq;	// readfile  copy ꤷ
    int nreq_kz;	// copy Τѿ (ndpt)
    int nreq_kx;	// Ʊ              (ndp)

// ؿ
    inline void fpgrad(int& zz) {zz += direc;}
    inline void bpgrad(int& zz) {zz -= direc;}
       	// ۥǡθ֤߰(f)/(b)
    inline void chkdirec() {		// ǧ롼
	if (direc != 1 && direc != -1) {
	    fprintf(stderr, "Error: int direc must be 1 or -1\n");
	    exit(15);	// error 15: ꥨ顼
	}
    }

  public:

// ؿ
//	nextsta(int);	// constructor: gxx θĿ (int)
    nextsta(nextsta&);	// constructor: 
    nextsta();	// empty constructor
    ~nextsta() {nxx = 0;}	// destructor
    nextsta& operator=(nextsta&);
    nextsta& operator=(gradcrv&);  	// ѱ黻ҤΥС

    int readfile(FILE*, char*);		// ե꡼

    void setvar(double, int, double, double, double, int, double, double);
	// ѿʤϽ
    inline void set_ndp(int n) {ndp = n;}		// ndp Υå
    inline void set_ndpt(int n) {ndpt = n;}		// ndpt Υå

    inline void setpf(double x, int i) {pfcont = x; pfi = i;}
    inline void prate(double x) {prt = x; setprt = true;}
    inline void prtreset() {setprt = false;}
    inline void prtinit() {prtreset(); prt = bufcont = pfcont = 0.0;}
    inline void setbuf(double x) {bufcont += x;}
    inline void setdc(dp_command x) {dcmd = x;}
    inline void set_nextnxx(nextsta* x) {nxx = x;}
    inline void set_ontprec() {ontprec = true;}
    inline bool get_ontprec() {return ontprec;}
    void get_greq(int&, int&, double&);	// greq_* Ȥ֤
					// ʤʤ gnum = -1 ֤
    int dpgrad(double);			// ۥǡθַ߰
    void adjpgrad(int&, double);	// ۥǡθֹ߰碌
    void arv_pass();			// arv ν
    double tarrive(int);		// ontime , Ѥ
    double tarrive(bool);		// setbuf ѡ˾Ѥ
    inline bool prtset() {return setprt;}
    inline double bufdiff() {return bufcont;}
    inline double prate() {return prt;}
    inline double congestion() {return conges;}
    inline double nextswitch() {return nextsw;}
    inline double parrive() {return arp;}
    inline double varrive() {return arv;}
    inline double tarrive() {return art;}
    inline nextsta_pattern nxxptn() {return nxp;}
    inline double stoptime() {return tstop;}
    inline double pstart() {return startp;}
    inline nextsta* nextnxx() {return nxx;}
    inline int feedlinenumber() {return nfline;}
    inline int direction() {return direc;}
    inline int dptnum() {return ndpt;}
    inline int dpttbl() {return ndp;}			// ѿ
    inline int dqgrad() {		// ۥǡνذ
	chkdirec();
	if (direc == 1) return (number() - 1);
	if (direc == -1) return 0;
    }
    inline int dsgrad() {		// ۥǡεذ
	chkdirec();
	if (direc == 1) return 0;
	if (direc == -1) return (number() - 1);
    }
    inline void fwpgrad(int& zz) {chkdirec();fpgrad(zz);}
    inline void bkpgrad(int& zz) {chkdirec();bpgrad(zz);}
		// ۥǡθ֤߰(fw)/(bk)

    inline double epoint(int pgrad) {	// ǡλ֤
	chkdirec();
	if (direc == 1)
	    return operator[]( pgrad ).endp;	// direc= 1 ʤ endp
	else return operator[]( pgrad ).stp;	//       -1 ʤ stp
    }
    inline double spoint(int pgrad) {	// ǡ֤ؿ
	chkdirec();
	if (direc == 1)
	    return operator[]( pgrad ).stp;		// direc= 1 ʤ stp
	else return operator[]( pgrad ).endp;	//       -1 ʤ endp
    }

    inline double grad(int pgrad) {return operator[](pgrad).grad;}
    inline double curve(int pgrad) {return operator[](pgrad).curve;}
    double vlimit(int pgrad);
		// ΰ֤ۡȾ¡®٤֤ؿ

    inline double grad(double pos) {return grad(dpgrad(pos));}
    inline double curve(double pos) {return curve(dpgrad(pos));}
    double vlimit(double pos) {return vlimit(dpgrad(pos));}
		// а֤ۡȾ¡®٤֤ؿ
};

#endif /* ! ___SIGOBJ_HH */
