// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// rf_hfile.cc --- read data from files: H file
// -----
// ChangeLog:
// 2007. 11. 21
//  Redirected log messages to l_file.
// -----

#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <cstring>
#include <iostream>

#include "kidenrt.hh"
#include "StrPrintf.hh"

using std :: cerr ;
using std :: endl ;


// Reading the H-file (headway-related data)
void
feeder :: rf_hfile
()
{
  if ( ! g_sw_station_object_valid )
  {
    // Not necessary, skip
    return ;
  }

  FILE * hpoint = fopen ( h_file , "r" ) ;
  if ( hpoint == 0 )
  {
    err_access ( h_file ) ;
  }

  commandvalue comval ;
  while ( ( comval = getcommandvalue( hpoint, h_file ) )
	  != STATION_OBJECT_NUMBER )
  {
    // Processing flags, until the first command "station_object_number"
    // is found
    switch ( comval )
    {
    case STOPORIENTED :
      // "Halt-oriented" simulation. If true, trains tend to stop between
      // stations.
      if ( g_sw_stop_between_oriented )
      {
	g_sw_stop_between_oriented = false ;
	cerr << "OK, toggled g_sw_stop_between_oriented to false" << endl ;
      }
      else
      {
	g_sw_stop_between_oriented = true ;
	cerr << "OK, toggled g_sw_stop_between_oriented to true" << endl ;
      }
      break ;

    case STATIONSTOP_VARIATION_TYPE_A :
      // Using deterministic station dwell time fluctuation model.
      g_sw_use_stnobj_ssvar = true ;
      cerr << "OK, g_sw_use_stnobj_ssvar set to true" << endl ;
      gettwodbls ( hpoint , h_file , glob_head , glob_t_sv ) ;
      l_ofs << StrPrintf ( " Headway: %10.3f, Invalid Stoptime %10.3f" ,
                           glob_head , glob_t_sv ) << endl ;
      break ;

    default :	// Error
      err_eof ( h_file ) ;
      break ;
    }
  }

  // Interpreting command "station_object_number"
  int stnmax ;
  getint ( hpoint , h_file , stnmax ) ;
  l_ofs << endl << StrPrintf ( "Number of station objects: %d" , stnmax )
        << endl ;
  stnobj . setnum ( stnmax ) ;
  if ( g_sw_use_stnobj_ssvar )
  {
    x_stnobj_s . setnum ( stnmax ) ;
    for ( int i = 0 ; i < stnmax; ++ i )
    {
      stnobj [ i ] = & ( x_stnobj_s [ i ] ) ;
    }
  }
  else
  {
    x_stnobj . setnum ( stnmax ) ;
    for ( int i = 0 ; i < stnmax ; ++ i )
    {
      stnobj [ i ] = & ( x_stnobj [ i ] ) ;
    }
  }        

  for ( int i = 0 ; i < stnmax ; ++ i )
  {
    // Assign a serial number to each instance of station_obj
    stnobj [ i ] -> set_stnno ( i ) ;
    // Read data for the station_obj
    stnobj [ i ] -> readfile ( hpoint ) ;
  }

  // Set pointer to station_obj that a nextsta object must have
  for ( int i = 0 ; i < getDPTsize () ; ++ i )
  {
    for ( diapattern :: np_iterator j = getDPT ( i ) . np_begin () ;
          j < getDPT ( i ) . np_end () ; ++ j )
    {
      if ( ! ( * j ) )
      {
        cerr << "Error in feeder::rf_hfile(): diapattern having null pointer"
             << endl ;
        exit ( 1 ) ;
      }
      
      ( * j ) -> set_stnobj ( stnobj [ ( * j ) -> stnobjnum () ] ) ;
      cerr << "diapattern " << i << ", nextsta " << ( * j ) -> dpttbl ()
           << ":" << endl << " station object No. "
           << ( * j ) -> stnobjnum () << " set." << endl ;
    }
  }

  // Data sorting for station_obj_stationstop_variation objects
  if ( g_sw_use_stnobj_ssvar )
  {
    for ( int i = 0 ; i < x_stnobj_s . number () ; ++ i )
    {
      if ( x_stnobj_s [ i ] . control_type () != Without_control )
      {
	x_stnobj_s [ x_stnobj_s [ i ] . control_target_stnobj () ]
	  . set_stnobj_ssvar_p ( & ( x_stnobj_s [ i ] ) ) ;
	cerr << "x_stnobj " << i << " -> control: "
	     << x_stnobj_s[ i ].control_target_stnobj() << "." << endl ;
      }
    }
  }
}
