// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// sim_ctla.cc --- Realtime substation voltage control routine, type A
// -----
// ChangeLog:
// 2007. 11. 21
//  Redirected log messages to l_file.
// -----

#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <iostream>

#include "kidenrt.hh"
#include "StrPrintf.hh"

using std :: cerr ;
using std :: endl ;


#define DELTA_C_LIM TYPEA_DCLIM
#define DELTA_C_MAX TYPEA_DCMAX

#define DEBUG_TYPEA

// #ifdef DEBUG_TYPEA
// bool sw_x = false ;
// #endif /* DEBUG_TYPEA */



// ϩ׻ޤΥ֥롼󡢥ꥢ륿楿A
void
feeder :: simcc_ssctl_a
( int & cctt )
{
  // 1ʳġŰǹΥ黻
  resetsubcntl () ;	// Ž subcntl  1 ˥ꥻå
  simcccore ( cctt ) ;
  int ipc ;
  double xregr ;
  double regr_old ;
  if ( cctt )
  {
    // ׻ｪλΤȤ
    simcc_ssctl_a_regipc ( ipc , xregr ) ;	// ʹΨå
    if ( ipc < 0 ||
	 fabs ( xregr - 1.0 ) < INVLIM )
    {
      // ʤߤʤ
#ifdef DEBUG_TYPEA
      l_ofs << "No problem regeneration. return." << endl ;
#endif
      return ;
    }
  }
  else
  {
    // ׻۾ｪλΤȤġĤǤñ˥꥿
    l_ofs << "ccal failed!" << endl ;
    return ;
  }
  double subcntl_pre , dv_dsubcntl , subcntl_ppx = 0.0 ;
  int ipc_successive = 0 ;
  for ( int k = 0 ; k < TYPEA_REGMAX ; ++ k )
  {
#ifdef DEBUG_TYPEA
    l_ofs << StrPrintf ( "regeneration check , cycle %d, suc %d" ,
                         k , ipc_successive ) << endl ;
#endif
    int ipcx = ipc ;
    regr_old = xregr ;
    double regr_b = getCAR ( ipc ) . regenrate () ;
    subcntl_pre = getSUB ( 0 ) . getsubcntl () ;	// Ʊ1ĸФ褤
    if ( k == 0 )
      subcntl_ppx = subcntl_pre ;	// ƤǤ
    bool sw_subc_shippai = false ;
    if ( subcntl_pre < DELTA_C_LIM )
    {
      // ¢Űݾ phase 
      dv_dsubcntl = 0.0 ;
#ifdef DEBUG_TYPEA
      l_ofs << "already minimized. skip" << endl ;
#endif
      continue ;
    }
    double delta_c_div = 1.0 ;
    simcc_ssctl_a_dreg
      ( cctt , delta_c_div , dv_dsubcntl , subcntl_pre , regr_b , ipc ) ;
    if ( ! cctt )
    {
      // ׻۾ｪλΤȤ
      simcc_ssctl_a_setctl ( subcntl_pre ) ;
      simcccore ( cctt ) ;	// ׻ԤϤʤϤ
      if ( k == 0 ) return ;
      else
      {
	sw_subc_shippai = true ;
	break ;
      }
    }
    if ( sw_subc_shippai )
    {
#ifdef DEBUG_TYPEA
      l_ofs << "subc shippai. proceed on to voltage phase." << endl ;
#endif
      break ;		// ׻ԡġĲͥ⡼ɤȴ
    }
    // ʬͤη׻
    double dv_dcntl_sum = dv_dsubcntl ;
    if ( fabs ( dv_dcntl_sum ) < INVLIM )
    {
      // Ű㲼ǲʤ
#ifdef DEBUG_TYPEA
      l_ofs << "No need to do further regeneration phase." << endl ;
#endif
      simcc_ssctl_a_setctl ( subcntl_ppx ) ;	// 
      simcccore ( cctt ) ;	// ׻ԤϤʤϤ
      if ( k == 0 ) return ;
      else break ;
    }
    dv_dcntl_sum = ( regr_b - 1.0 ) / dv_dcntl_sum ;
#ifdef DEBUG_TYPEA
    l_ofs << StrPrintf ( "dv_dcntl_sum = %12.6f" , dv_dcntl_sum ) << endl ;
#endif
    // ͤ
    double xdx = dv_dcntl_sum * dv_dsubcntl ;
    if ( fabs ( xdx ) > DELTA_C_MAX + INVLIM )
    {
      dv_dcntl_sum *= DELTA_C_MAX ;
      dv_dcntl_sum /= fabs ( xdx ) ;
#ifdef DEBUG_TYPEA
      l_ofs << StrPrintf ( "dv_dcntl_sum: set to %12.6f" , dv_dcntl_sum )
            << endl ;
#endif
    }
    bool sw_first = true ;
    bool sw_eliminated = false ;
    bool sw_successive = false ;
    while ( fabs ( dv_dcntl_sum ) > DELTA_C_LIM || sw_first )
    {
      sw_first = false ;
      simcc_ssctl_a_addctl ( dv_dcntl_sum * dv_dsubcntl ) ;
#ifdef DEBUG_TYPEA
      l_ofs << StrPrintf ( "+ ( %12.6f ) = %12.6f" ,
                           dv_dcntl_sum * dv_dsubcntl ,
                           getSUB ( 0 ) . getsubcntl () )
            << endl ;
#endif
      simcccore ( cctt ) ;		// ϩ׻
      ipc = -10 ;
      xregr = 1.0 ;
      if ( cctt )
      {			// ׻ｪλΤȤ
	simcc_ssctl_a_regipc ( ipc , xregr ) ;	// ipc ȯ
	if ( ipc < 0 || fabs ( xregr - 1.0 ) < INVLIM )
	{
#ifdef DEBUG_TYPEA
	  l_ofs << "problem regenation eliminated." << endl ;
#endif
	  sw_eliminated = true ;
	  break ;		// ʤߤʤ
	}
	if ( ipc == ipcx && xregr - regr_old < TYPEA_REGR_D )
	{
	  if ( ipc_successive == 0 )
	  {
	    // ֤
	    subcntl_ppx = subcntl_pre ;	// ¸
	  }
	  ++ ipc_successive ;
	  if ( ipc_successive == TYPEA_IPCMAX )
	  {
	    // ᤹
#ifdef DEBUG_TYPEA
	    l_ofs << "No effect of voltage reduction." << endl ;
#endif
	    simcc_ssctl_a_setctl ( subcntl_ppx ) ;
	    simcccore ( cctt ) ;	// ׻ԤϤʤϤ
	    if ( k == 0 )
	      return ;
	    else if ( k - ipc_successive == - 1 )
	      return ;
	    else
	    {
	      sw_successive = true ;
	      break ;
	    }
	  }
	}
	else
	{
	  ipc_successive = 0 ;
	  subcntl_ppx = subcntl_pre ;
	}
	break ;
      }
      else
      {
	// ׻۾ｪλΤȤġĸᤷ
#ifdef DEBUG_TYPEA
	l_ofs << "calculation failed in voltage reduction. try again."
              << endl ;
#endif
	simcc_ssctl_a_setctl ( subcntl_ppx ) ;
	dv_dcntl_sum /= 2.0 ;
      }
    }
    if ( sw_eliminated || sw_successive )
      break ;
    if (  ( ! cctt ) || fabs ( dv_dcntl_sum ) <= DELTA_C_LIM )
    {
#ifdef DEBUG_TYPEA
      l_ofs << "shippai in voltage reduction." << endl ;
#endif
      simcc_ssctl_a_setctl ( subcntl_ppx ) ;
      simcccore ( cctt ) ;	// ׻ԤϤʤϤ
      if ( k == 0 ) return ;
      else break ;
    }
  }
  // Űξ ipc ȯĤʤä齪λ
  double xvolt ;
  simcc_ssctl_a_volipc ( ipc , xvolt ) ;
  if ( ipc < 0 || xvolt - TYPEA_MINVOLT < 0.0 )
  {
#ifdef DEBUG_TYPEA
    l_ofs << "No low-voltage cars. return." << endl ;
#endif
    return ;		// Űʤ
  }
  for ( int k = 0 ; k < TYPEA_TRNMAX ; ++ k )
  {
    double volt_b = getCAR ( ipc ) . volt () ;
    subcntl_pre = getSUB ( 0 ) . getsubcntl () ;
    if ( subcntl_pre > 1.0 - INVLIM )
    {
      // ¢
#ifdef DEBUG_TYPEA
      l_ofs << "already maximized. skip." << endl ;
#endif
      dv_dsubcntl = 0.0 ;
      continue ;
    }
    simcc_ssctl_a_setctl ( 1.0 ) ;	// Ű٤ޤǤ
    simcccore ( cctt ) ;		// ϩ׻
    if ( cctt )
    {
      // ׻ｪλʬ
      double volt_a = getCAR ( ipc ) . volt () ;
      volt_a -= volt_b ;
      dv_dsubcntl = volt_a / ( 1.0 - subcntl_pre ) ;
      simcc_ssctl_a_setctl ( subcntl_pre ) ;	// ᤹
#ifdef DEBUG_TYPEA
      l_ofs << StrPrintf ( "normally calculated, dv_dsub = %10.5f" ,
                           dv_dsubcntl ) << endl ;
#endif
    }
    else
    {
      // ׻۾ｪλ
#ifdef DEBUG_TYPEA
      l_ofs << "calculation failed." << endl ;
#endif
      simcc_ssctl_a_setctl ( subcntl_pre ) ;
      simcccore ( cctt ) ;	// ׻ԤϤʤϤ
      return ;
    }
    double dv_dcntl_sum = dv_dsubcntl ;
    if ( fabs ( dv_dcntl_sum ) < INVLIM )
    {
      // Ű徺ǲʤ
      simcc_ssctl_a_setctl ( subcntl_pre ) ;	// ᤹
      simcccore ( cctt ) ;	// ׻ԤϤʤϤ
      return ;
    }
    dv_dcntl_sum /= volt_b - TYPEA_MINVOLT ;
    simcc_ssctl_a_addctl ( dv_dcntl_sum * dv_dsubcntl ) ;
    simcccore ( cctt ) ;	// ϩ׻
    if ( cctt )
    {
      // ׻ｪλΤȤ
      simcc_ssctl_a_volipc ( ipc , xvolt ) ;		// ipc ȯ
      if ( ipc < 0 || xvolt - TYPEA_MINVOLT < 0.0 )
	return ;		// Űʤ
    }
    else
    {
      // ׻۾ｪλΤȤġĸᤷƼ
      simcc_ssctl_a_setctl ( subcntl_pre ) ;
      simcccore ( cctt ) ;	// ׻ԤϤʤϤ
      return ;
    }
  }
}



// simcc_ssctl_a Υ֥롼ŽβΨʬͤη׻
void
feeder :: simcc_ssctl_a_dreg
( int & cctt ,
  double delta_c_div ,
  double & dv_dsubcntl ,
  double & subcntl_pre ,
  double regr_b ,
  int ipc )
{
  // ŽŰ٤ޤǲ
  bool subcntl_zero_one = false ;
  if ( subcntl_pre < TYPEA_DELTA_C / delta_c_div )
  {
    subcntl_zero_one = true ;
    simcc_ssctl_a_setctl ( 0.0 ) ;
#ifdef DEBUG_TYPEA
    l_ofs << "minimized." << endl ;
#endif
  }
  else
  {
    simcc_ssctl_a_setctl ( subcntl_pre - TYPEA_DELTA_C / delta_c_div ) ;
#ifdef DEBUG_TYPEA
    l_ofs << StrPrintf ( "minus %.5f" , TYPEA_DELTA_C / delta_c_div )
          << endl ;
#endif
  }
  simcccore ( cctt ) ;		// ϩ׻
  if ( cctt )
  {
    // ׻ｪλʬ
    double regr_a = getCAR ( ipc ) . regenrate () ;
    regr_a -= regr_b ;
    if ( subcntl_zero_one )
      dv_dsubcntl = regr_a / subcntl_pre ;
    else
      dv_dsubcntl = regr_a * delta_c_div / TYPEA_DELTA_C ;
    simcc_ssctl_a_setctl ( subcntl_pre ) ;	// ᤹
#ifdef DEBUG_TYPEA
    l_ofs << StrPrintf ( "normally calculated, dv_dsub = %10.5f" ,
                         dv_dsubcntl ) << endl ;
#endif
    return ;
  }
  else
  {
    // ׻۾ｪλTYPEA_DELTA_C Ⱦʬˤƺƥȥ饤
    if ( TYPEA_DELTA_C / ( delta_c_div * 2.0 ) < DELTA_C_LIM )
    {
#ifdef DEBUG_TYPEA
      l_ofs << "calculation failed." << endl ;
#endif
      return ;
    }
    else
    {
#ifdef DEBUG_TYPEA
      l_ofs << "calculation failed. try again." << endl ;
#endif
      simcc_ssctl_a_dreg ( cctt , delta_c_div * 2.0 , dv_dsubcntl ,
			   subcntl_pre , regr_b , ipc ) ;
      return ;
    }
  }
}



// simcc_ssctl_a Υ֥롼ֲΨå
void
feeder :: simcc_ssctl_a_regipc
( int & ipc ,
  double & xregr )
{
  ipc = -10 ;
  xregr = 1.0 ;
  for ( int i = 0 ; i < ncar ; ++ i )
  {
    if ( getCAR ( i ) . regendead () )
      continue ;	// Ϲθʤ
    if ( getCAR ( i ) . rnotchvl () > - INVLIM )
      continue ;	// եΥåΥΤ߹θ
    double yregr = getCAR ( i ) . regenrate () ;
    if ( yregr < xregr )
    {
      xregr = yregr ;
      ipc = i ;
    }
  }
#ifdef DEBUG_TYPEA
  l_ofs << StrPrintf ( "ipc search ended, No.%3i: regenrate %6.3f" ,
                       ipc , xregr ) << endl ;
#endif
}



// A, setsubcntl Ԥ
void
feeder :: simcc_ssctl_a_setctl
( double ppx )
{
  for ( int i = 0 ; i < nss ; ++ i )
  {
    getSUB ( i ) . setsubcntl ( ppx ) ;
  }
}



// A, addtosubcntl Ԥ
void
feeder :: simcc_ssctl_a_addctl
( double ppx )
{
  for ( int i = 0 ; i < nss ; ++ i )
  {
    getSUB ( i ) . addtosubcntl ( ppx ) ;
  }
}



// simcc_ssctl_a Υ֥롼֥ѥŰå
void
feeder :: simcc_ssctl_a_volipc
( int & ipc ,
  double & xvolt )
{
  xvolt = TYPEA_MINVOLT ;
  ipc = - 10 ;
  for ( int i = 0 ; i < ncar ; ++ i )
  {
    if ( getCAR ( i ) . rnotchvl () < INVLIM )
      continue ;	// եΥåΥΤ߹θ
    double yvolt = getCAR ( i ) . volt () ;
    if ( yvolt < xvolt )
    {
      xvolt = yvolt ;
      ipc = i ;
    }
  }
}
