// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// ElectricChars.hh
//  --- declaration of class ElectricChars
// -----
// ChangeLog:
// 2008. 2. 2
//  File created.
// -----


#ifndef ElectricChars_HH
#define ElectricChars_HH

// -----
// Abstract class expressing the electric characteristics of either a train
// or a substation.
// NOTE::: Current flowing from system to the DC feeding system is POSITIVE.
// ֤ޤŽŵŪɽݥ饹.
// աƥफťƥήήȤʤ롣
// -----
class ElectricChars
{
public :

  // Virtual destructor
  virtual ~ElectricChars () {}

  // Virtual function for renewal of electrical state variables.
  virtual void renewElectricalStates () = 0 ;

  // Virtual function for calculation of ESD voltage and current
  virtual void calculateESDVoltageAndCurrent () = 0 ;

  // ----
  // Virtual function for SOC-related initialisation upon start of the
  // simulation cycle.
  // ----
  virtual void setStartSOC () = 0 ;

  // ----
  // Virtual function for typing out SOC-related data to the RES file.
  // ----
  virtual void printSOCStoredResults
  ( ostream & , ostringstream & , ostringstream & ) const = 0 ;

} ;

#endif	// ElectricChars_HH
