// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// kidenrt.hh --- header file that defines class feeder
// -----
// ChangeLog:
// 2007. 11. 7
//  Added function feeder :: rf_sxml_ctrl_a ( const TiXmlNode * const ).
//  This function reads the attributes for tag <substation_control_a> in the
//  new XML-formatted S file.
//  Added function feeder :: rf_sxml_substation ( const TiXmlNode * const ).
//  This function reads the tag <substation> in the new XML-formatted S file.
// -----

#include <cstdio>
#include <cstdlib>
#include <iostream>
#include <fstream>
#include <vector>
#include <stdexcept>
#include <map>

#include "globvar.hh"
#include "matrix.hh"
#include "enumerat.hh"
#include "nextsta.hh"
#include "elecchar.hh"
#include "train.hh"
#include "feed_y.hh"
#include "feedline.hh"
#include "diapatrn.hh"
#include "stnobj_s.hh"
#include "train.hh"
#include "Ref_SOC_Curve_Container.hh"

#include "tinyxml.h"

#ifndef ___KIDENRT_HH
#define ___KIDENRT_HH	// Ƥ2٥󥯥롼ɤƤס

using std :: map ;
using std :: string ;
using std :: vector ;
using std :: cerr ;
using std :: endl ;




// AŽꥢ륿Űѥǡ
struct typea_data
{
  int regmax ;		// ʤɻߤ򲿲뤫
  int ipcmax ;		// ƱξФ¡
  double minvolt ;	// Ű
  int trnmax ;		// Űɻߤ򲿲뤫
  double regr_d ;	// ʤɻͭȽ꺹ʬ
  double delta_c ;	// ŽʬȤȤκʬ
  double dcmax ;	// Step maximum limit
  double dclim ;	// Step minimum limit
} ;

// -----
// AŽŰбѿ: simulate.cc ư
// ե뤫Ϥ褦ѹ
// Typical :
//#define TYPEA_REGMAX	50	// ʤɻߤ򲿲뤫
//#define TYPEA_IPCMAX	15	// ƱξФ¡
//#define TYPEA_MINVOLT	1350.0	// Ű
//#define TYPEA_TRNMAX	30	// Űɻߤ򲿲뤫
//#define TYPEA_REGR_D	0.05	// ʤɻͭȽ꺹ʬ
//#define TYPEA_DELTA_C	0.1	// ŽʬȤȤκʬ
// 2007. 1. 9 -- New functions added
//#define TYPEA_DCMAX	0.002	// Step maximum limit
//#define TYPEA_DCLIM	1e-5	// Step minimum limit
// -----
#define TYPEA_REGMAX	realtime_data . typea . regmax
#define TYPEA_IPCMAX	realtime_data . typea . ipcmax
#define TYPEA_MINVOLT	realtime_data . typea . minvolt
#define TYPEA_TRNMAX	realtime_data . typea . trnmax
#define TYPEA_REGR_D	realtime_data . typea . regr_d
#define TYPEA_DELTA_C	realtime_data . typea . delta_c
#define TYPEA_DCMAX	realtime_data . typea . dcmax
#define TYPEA_DCLIM	realtime_data . typea . dclim

// ťƥǡ
class feeder
  : public readdata
{

  // 񤭽Фե... quick hack ɵƤ͡ʥ
  std :: ofstream csvout_nogi ;
  bool nogi_header_required ;

  // ʹѹʤ
  int feeders ;	// 
  int ncar ;	// ֿ
  int nss ;	// Ž
  int ncss ;	// = ncar + nss;
  int ndp ;	// ѥ
  vector < gradcrv * > :: size_type ngrad ;	// ̥ѥ
  double delta ;	// ʬ
  int nsim ;	// ߥ졼Ȥ

  // ٹϢ
  feed_y feedy ;	// ٹ׻
  matrix ymtx ;		// ٹ
  matrix gff_xx ; 	// grad  
  matrix gamma ;
  matrix fvec ;	// ؿʽġ˥٥ȥ
  diagmatrix dy ;	// ֥ɥߥ󥹹гѹ
  matrix ht ;	// ³, ž֤Τǥ֥ߥΡ

  // ƥǡ
  vector < feedline * > vec_fln ;	// ǡ
  vector < train * > vec_car ;           // ֥ǡ
  vector < elecchar * > vec_csd ;        // Žꡦ֥ǡ
  vector < diapattern * > vec_dpt ;      // ѥǡ
  vector < gradcrv * > vec_gcv ;         // ̥ѥǡ
  vector < elecchar * > vec_sub ;        // Žǡ

  // ѱإǡ
  RefTable < station_obj * > stnobj ;
  RefTable < station_obj > x_stnobj ;
  RefTable < station_obj_stationstop_variation > x_stnobj_s ;

  // ----
  // Map of gradcrv class instance for use in rf_gfile() function.
  // rf_gfile() ؿѤ gradcrv 饹󥹥󥹤 map
  // ----
  map < string , vector < gradcrv * > :: size_type > _gcv ;

  // ----
  // Map of traindata for use in rf_pfile() function.
  // rf_pfile() ؿѤ traindata 饹󥹥󥹤 map
  // ----
  map < string , traindata * > _trd ;

  // ----
  // Map of reference SOC data for use in rf_nfile() function.
  // rf_pfile() ؿѤեSOCǡ饹󥹥󥹤 map
  // ----
  Ref_SOC_Curve_Container _soc ;

  // ----
  // XML reader to be used for reference SOC data.
  // եSOCǡӤ߹XML꡼.
  // ----
  RS_XmlReader _xread ;

  union {		// *** ͤβ
    typea_data typea ;	// Aѥǡ
  } realtime_data;	// Žꥢ륿Űѥǡ

private :
  void runtrsub ( int ) ;	// runtrain, disttrain  subprogram
  void disttr_trinit () ;	// disttrain  subprogram: ־ֽ

  // ξŽޤǤԡ󥹤򶵤
  void tellimp () ;
  void tisub ( feed_y & ) ;	// tellimp  subprogram
  void ti_for ( int , int , feed_y & ) ; // tisub  subprogram, ʬ
  void ti_efor ( bran_node & ) ; // ti_for  subprogram
  void ti_bak ( int , int , feed_y & ) ; // tisub  subprogram, ʬ
  void ti_sbak ( bran_node & ) ; // ti_bak  subprogram
  void ti_cc () ;	         // tellimp  subprogram

  void rf_ffile () ;	// f_file ɤ߹
  void rf_gfile () ;	// g_file ɤ߹
  void rf_hfile () ;	// h_file ɤ߹
  void rf_nfile () ;	// n_file ɤ߹
  void rf_pfile () ;	// p_file ɤ߹
  void rf_sfile () ;	// s_file ɤ߹

  // XML G file reading subprograms
  void rf_gxml_speed_restriction_margin ( TiXmlNode const * ) ;
  void rf_gxml_data_sets ( TiXmlNode const * ) ;

  // XML S file reading subprograms
  void rf_sxml_ctrl_a ( TiXmlNode const * ) ;
  void rf_sxml_substation ( TiXmlNode const * ) ;

  // XML N file reading subprograms
  void rf_nxml_flags ( TiXmlNode const * ) ;
  void rf_nxml_accompanying_file ( TiXmlNode const * ) ;
  void rf_nxml_pattern ( TiXmlNode const * , int ) ;

  // simulate.cc Υ֥롼
  void resetsubcntl () {
    for ( int i = 0 ; i < nss ; ++ i ) getSUB ( i ) . setsubcntl ( 1.0 ) ;
  }
  void simcccore ( int & ) ;	 // ccal ޤ, 濴ʬ
  void simccsub ( int & ) ;	 // ccal ޤ
  void simcc_ssctl_a ( int & ) ; // ccal ޤ, ŽŰ楿A
  void simcc_ssctl_a_regipc ( int & , double & ) ;
				 // A, Ψå
  void simcc_ssctl_a_volipc ( int & , double & ) ;
				 // A, ѥŰå
  void simcc_ssctl_a_setctl ( double ) ;
                                 // A, setsubcntl Ԥʤ
  void simcc_ssctl_a_addctl ( double ) ;
    				 // A, addtosubcntl Ԥʤ
  void simcc_ssctl_a_dreg
  (int & , double , double & , double & , double , int ) ;
				 // A, Ψʬޤβϩ黻
  void siminteg () ;		 // ʬʬ
  void simssdirec () ;		 // Ž
  void simccalresult () ;	 // ϩ黻̤ν

  // -----
  // Renew the electrical state variables that all objects have.
  // ٤ƤΥ֥ȤͭŵŪѿ򹹿
  // -----
  void simRenewElectricalStates () ;

  // -----
  // Calculate voltage and current of all ESD's
  // -----
  void simCalculateESDVoltagesAndCurrents () ;

public :
  feeder () ;	// empty constructor
  feeder ( const feeder & ) ;	// X(X&) ػ
  feeder & operator= ( const feeder & ) ;	// ػ
  ~feeder () ;	// destructor

  void setvar ( int , int , int , int , double ) ;
            	// ѿͥå : feeders, ncar, nss, ndp, delta
            	// ΰγݤޤǤäƤ

  void readfile () ;	// ե꡼ɤȽ
  void setviold () {
    for ( int i = 0 ; i < ncss ; ++ i ) getCSD ( i ) -> setviold () ;
  }
  void restorevi () {
    for ( int i = 0 ; i < ncss ; ++ i ) getCSD ( i ) -> restorevi () ;
  }
  void notchrate () ;
  void setpeak () {
    for ( int i = 0 ; i < nss ; ++ i ) getSUB ( i ) . setpeak () ;
  }
  void settetazero () {
    for ( int i = 0 ; i < ncss ; ++ i ) getCSD ( i ) -> teta () = 0.0 ;
  }

  int ccal () ; 	// ϩ黻롼
  void ycal () ; 	// Y黻롼
  void gradf () ;	// grad  
  double ffunc ( matrix & , matrix & ) ;
  double ffunc ( matrix & ) ;	// ؿ٥ȥ

  // void emcc ( bool ) ;	// train.emccal 򤹤٤ưͤˤ

  // feedline ؤλ
  feedline & getFLN ( int gx )
  {
    feedline * x ;
    try
    {
      x = vec_fln . at ( gx ) ;
    }
    catch ( std :: out_of_range )
    {
      std :: cerr << "Error: subscript out of range in feedline data call"
		  << std :: endl
		  << "       within the feeder object" << std :: endl ;
      exit ( 26 ) ;
    }
    return * x ;
  }

  // diapattern  size
  vector < diapattern * > :: size_type getDPTsize ()
  {
    return vec_dpt . size () ;
  }

  // diapattern ؤλ
  diapattern & getDPT ( int gx )
  {
    diapattern * x ;
    try
    {
      x = vec_dpt . at ( gx ) ;
    }
    catch ( std :: out_of_range )
    {
      std :: cerr << "Error: subscript out of range in diapattern data call"
		  << std :: endl
		  << "       within the feeder object" << std :: endl ;
      exit ( 26 ) ;
    }
    return * x ;
  }

  // gradcrv ؤλ
  gradcrv & getGCV ( int gx )
  {
    gradcrv * x ;
    try
    {
      x = vec_gcv . at ( gx ) ;
    }
    catch ( std :: out_of_range )
    {
      std :: cerr << "Error: subscript out of range in gradcrv data call"
		  << std :: endl
		  << "       within the feeder object" << std :: endl ;
      exit ( 26 ) ;
    }
    return * x ;
  }

  // train ؤλ
  train & getCAR ( int gx )
  {
    train * x ;
    try
    {
      x = vec_car . at ( gx ) ;
    }
    catch ( std :: out_of_range )
    {
      std :: cerr << "Error: subscript out of range in train data call"
		  << std :: endl
		  << "       within the feeder object" << std :: endl ;
      exit ( 26 ) ;
    }
    return * x ;
  }

  // elecchar ؤλ
  elecchar & getSUB ( int gx )
  {
    elecchar * x ;
    try
    {
      x = vec_sub . at ( gx ) ;
    }
    catch ( std :: out_of_range )
    {
      std :: cerr << "Error: subscript out of range in elecchar data call"
		  << std :: endl
		  << "       within the feeder object" << std :: endl ;
      exit ( 26 ) ;
    }
    return * x ;
  }

  // elecchar * ؤλ
  elecchar * getCSD ( int gx )
  {
    elecchar * x ;
    try
    {
      x = vec_csd . at ( gx ) ;
    }
    catch ( std :: out_of_range )
    {
      std :: cerr << "Error: subscript out of range in elecchar pointer call"
		  << std :: endl
		  << "       within the feeder object" << std :: endl ;
      exit ( 26 ) ;
    }
    return x ;
  }

  void runtrain () ;	// ֤餻
  void disttrain () ;	// ֤ν֤

  void simulation () ;	// ߥ졼ץ
  void runcurve () ;
};


#endif /* ! ___KIDENRT_HH */
