// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// notchr.cc --- class train functions: notchrate()
// -----
// ChangeLog:
// 2007. 11. 21
//  Redirected log messages to l_file.
// -----

#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <iostream>
#include <sstream>
#include <iomanip>

#include "train.hh"

#define INVLIM 1e-5

//#define DEBUG
//#define CVPRINT	// V1, V2 ͤǤФ

#define NO_JERK

#define MINCL	10.0
#define REGEN_OFF_TETA	5.0


using std :: ostringstream ;
using std :: setprecision ;
using std :: fixed ;
using std :: setw ;
using std :: right ;



// եΥåη
void
train :: notchrate
()
{
  rnotchold = rnotch ;		// Ťͤ¸

  switch ( stat )
  {
  case Power :			// Ϲ
    nr_power () ;
    break ;

  case Brake :
  case Regenerate :		// 
    nr_regen () ;
    break ;

  case Coast :			// ƹ
    nr_coast () ;
#ifdef DEBUG
    ostringstream cx ;
    l_ofs << "car No." << carno << ":coast,nr=" ;
    cx . clear () ;
    cx . str ( "" ) ;
    cx << fixed << setprecision ( 3 ) << setw ( 6 ) << rnotch ;
    l_ofs << cx . str () << ", v=" ;
    cx . clear () ;
    cx . str ( "" ) ;
    cx << fixed << setprecision ( 1 ) << setw ( 7 ) << v ;
    l_ofs << cx . str () << endl ;
#endif	
    break ;

  case Const_vel :		// ®
    nr_constv () ;
    break ;

  case Stn_stop :
  case Between_stop :
  default :
    rnotch = dnch = 0.0 ;	// ɤ⥼
  }
#ifdef NO_JERK
#else
  b_jerk = false ;
  if ( fabs ( rnotch - rnotchold ) > 0.25 && stat == stat_old )
  {
    // ܰʳξ硢եΥåΨεѤ򤱤
    rnotch = ( rnotch - rnotchold ) / fabs ( rnotch - rnotchold ) ;
    rnotch *= 0.25 ;
    rnotch += rnotchold ;
    dnch = 0.0 ;
    b_jerk = true ;
  }
#endif
}


// notchrate Υ֥롼ϹԻ
void
train :: nr_power
( double & rnch ,
  double & dc )
{
  tetavisub ( 1.0 ) ;

  switch ( ccmd )
  {
  case Ec_auto :
  case Ea_cvauto0 :
    nr_p_ea ( rnch , dc ) ;
    break ;

  case None :
  default :	// default: -Wall warning Τ
    rnch = 1.0 ;
    dc = 0.0 ;
    break ;
  }
}



// notchrate()  subroutine, ®Ի
void
train :: nr_constv
()
{
  tetavisub ( 0.0 ) ;

  switch ( ccmd )
  {
  case None :
  default :		// default: -Wall warning Τ
  case Ec_auto :	// ξϺƸƤɬפ
  case Ea_cvauto0 :
    double tres = tresist ( vel , pgrad ) ;
    train_ParamFunc * __pf = getNewParamFuncCalculator () ;
    __pf -> prepareMaximumEffort () ;
    double tfp = __pf -> getMaxTractiveEffort () ;
    double tfb = __pf -> getMaxBrakingEffort () ;
    delete __pf ;
//     double tfp = tracf ( vel , v , 1.0 ) ;
//     sw_dtracf = true ;
//     double tfb = tracf ( vel , v , - 1.0 ) ;
//     sw_dtracf = false ;
    if ( ( fabs ( tfp ) <= fabs ( tres ) || fabs ( tfp ) < INVLIM )
         && ( tres > 0 ) )
    {
      rnotch = 1.0 ;
      dnch = 0.0 ;
    }
    else if ( ( fabs ( tfb ) <= fabs ( tres ) || fabs ( tfb ) < INVLIM )
              && ( tres < 0 ) )
    {
      rnotch = - 1.0 ;
      dnch = 0.0 ;
    }
    else if ( tres >= 0.0 )
    {
      rnotch = fabs ( tres / tfp ) ;
      double vlow = vlow_p ;
      double vhigh = vhigh_p ;
      double vl = vlow * v / pdata . ec ;
      double vh = vhigh * v / pdata . ec ;
      if ( vel < vl )
      {
        dnch = 0.0 ;
      }
      else if ( vel < vh )
      {
        dnch = - rnotch / v ;
      }
      else
      {
        dnch = - 2.0 * rnotch / v ;
      }
    }
    else
    {
      rnotch = - fabs ( tres / tfb ) ;
      // dnch = 0.0 ;
      double vlow = vlow_b ;
      double vhigh = vhigh_b ;
      double vl = vlow * v / bdata . ec ;
      double vh = vhigh * v / bdata . ec ;
      if ( vel < bdata . regenoff )
      {
        dnch = 0.0 ;
      }
      else if ( vel < vl )
      {
        dnch = 0.0 ;
      }
      else if ( vel < vh )
      {
        dnch = - rnotch / v ;
      }
      else
      {
        dnch = - 2.0 * rnotch / v ;
      }
    }
  }
}



// notchrate  subroutine, 
void
train :: nr_regen
()
{
  tetavisub ( - 1.0 ) ;

  switch ( ccmd )
  {
  case None :
  case Ec_auto :
  case Ea_cvauto0 :
  default :		// default: -Wall warning Τ
    train_ParamFunc * __pf = getNewParamFuncCalculator () ;
    __pf -> prepareMaximumEffort () ;
    double tfx = __pf -> getMaxBrakingEffort () ;
    delete __pf ;
//     sw_dtracf = true ;
//     double tfx = tracf ( vel , v ) ;	// ͡ʤ߹θ
//     sw_dtracf = false ;
    if ( fabs ( tfx ) < INVLIM )
    {
      rnotch = - 1.0 ;	// ŵŪϤϤɤФʤ -1
      dnch = 0.0 ;
      break ;
    }
    double bkf = brakef () ;		// ͡
    if ( bkf > fabs ( tfx ) )
    {
      rnotch = - 1.0 ;
      dnch = 0.0 ;
      break ;
    }
    double rnx = bkf / tfx ;	// ͡
    if ( rnx > 0.0 )
    {
      rnotch = 0.0 ;
      dnch = 0.0 ;
    }
    else
    {
      rnotch = rnx ;
      double vlow = vlow_b ;
      double vhigh = vhigh_b ;
      double vl = vlow * v / bdata . ec ;
      double vh = vhigh * v / bdata . ec ;
      if ( vel < bdata . regenoff )
      {
        dnch = 0.0 ;
        if ( bdata . _is_rheo )
        {
          rnotch = - 1.0 ;
        }
      }
      else if ( vel < vl )
      {
        if ( bdata . _is_rheo )
        {
          double _vsd
            = bdata . _rheostatic_regen_off_velocity * v / bdata . ec ;
          double _dvsd_dv
            = bdata . _rheostatic_regen_off_velocity * dv / bdata . ec ;
          if ( vel < _vsd - bdata . _changeover_speed_band * ( 1 + rnx ) )
          {
            rnotch = - 1.0 ;
            dnch = 0.0 ;
          }
          else if ( vel < _vsd )
          {
            rnotch = rnx - ( _vsd - vel ) / bdata . _changeover_speed_band ;
            dnch = - _dvsd_dv / bdata . _changeover_speed_band ;
          }
          else
          {
            dnch = 0.0 ;
          }
        }
        else
        {
          dnch = 0.0 ;
        }
      }
      else if ( vel < vh )
      {
        dnch = - rnotch / v ;
      }
      else
      {
        dnch = - 2.0 * rnotch / v ;
      }
    }
    break ;
  }
}



// notchrate  subroutine, ƹԻ
void
train :: nr_coast
()
{
  tetavisub ( 0.0 ) ;
  cpsww = false ;

  switch ( ccmd )
  {
  case None :
    rnotch = dnch = 0.0 ;
    break ;

  case Ec_auto :
  case Ea_cvauto0 :
    nr_c_ea () ;
    break ;

  default :
    // tetavisub ( 0.0 ) ;
    rnotch = dnch = 0.0 ;
    break ;
  }
}



// notchrate()  subprogram, Ecauto ϹԻ
void
train :: nr_p_ea
( double & rnch ,
  double & dc )
{
  double rnx ; 	// ֺǾեΥå

  // ®٤᤮ rnch = 1.0
  // Ű⤱ rnch = 1.0
  if ( vel < adata . minvel || v > adata . pminvol )
  {
    rnch = 1.0 ;
    dc = 0.0 ;
    return ;
  }
  if ( vel < adata . fullvel )
  {
    // Ǿ rnotch
    rnx = vel - adata . minvel ;
    rnx /= adata . fullvel - adata . minvel ;
  }
  else
  {
    rnx = 1.0 ;
  }
  
  rnx = 1.0 - rnx ;
  if ( v < adata . poffvol )
  {
    // Ű᤮: rnch = rmin
    rnch = rnx ;
    dc = 0.0 ;
    return ;
  }

  rnch = v - adata . poffvol ;	// 0 < rnch 1
  rnch /= adata . pminvol - adata . poffvol ;
  rnch *= 1.0 - rnx ;
  rnch += rnx ;			// rnch 
  dc = ( 1.0 - rnx ) / ( adata . pminvol - adata . poffvol ) ;
}



// եΥåηꡢccmd = EcautoƹԻ
void
train :: nr_c_ea
()
{
  double rnx , rnbx ;
  if ( vel < adata . minvel
       || ( v >= adata . pminvol && v <= adata . crbvol ) )
  {
    rnotch = dnch = 0.0 ;	// ®٤᤮ rnotch = 0.0
    return ;             	// Ű椯餤ʤ rnotch = 0.0
  }

  // ޤ褿餫ʤ餺ƹԼ֤ξ
  if ( vel < adata . fullvel )
  {
    rnx = vel - adata . minvel ;
    rnx /= adata . fullvel - adata . minvel ;
  }
  else
  {
    rnx = 1.0 ;
  }
  // ǾեΥå

  // ֥졼ǾեΥå
  train_ParamFunc *__pf = getNewParamFuncCalculator () ;
  __pf -> prepareMaximumEffort () ;
  double tfb = __pf -> getMaxBrakingEffort () ;
  delete __pf ;
  rnbx = fabs ( brakef () / tfb ) ;
//   rnbx = fabs ( brakef () / tracf ( vel , v ) ) ;

  // rnotch 
  if ( v < adata . poffvol )
  {
    // Ű㤱Хե
    rnotch = - fabs ( rnx ) ;
    if ( fabs ( rnx ) > rnbx )
    {
      rnotch = - rnbx ;
    }

    dnch = 0.0 ;
  }
  else if ( v < adata . pminvol )
  {
    // Ű㤱о
    rnotch = v - adata . pminvol ;
    rnotch /= adata . poffvol - adata . pminvol ;
    rnotch *= - rnx ;
    dnch = rnx / ( adata . pminvol - adata . poffvol ) ;
    if ( fabs ( rnotch ) > rnbx )
    {
      rnotch = - rnbx ;
      dnch = 0.0 ;
    }
  }
  else if ( v > adata . crfvol )
  {
    // Ű˹⤱ХեϹ
    rnotch = rnx ;
    dnch = 0.0 ;
  }
  else
  {
    // Ű⤱оϹ
    rnotch = v - adata . crbvol ;
    rnotch /= adata . crfvol - adata . crbvol ;
    rnotch *= rnx ;
    dnch = rnx / ( adata . crfvol - adata . crbvol ) ;
  }
  if ( fabs ( rnotch ) > INVLIM )
  {
    cpsww = true ;
  }
}
