// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Prof. SONE's Laboratory, the Univ. of Tokyo.)
// stnobj_s.hh --- class station_obj_stationstop_variation
// $Id: stnobj_s.hh,v 2.4 1994/12/27 11:49:38 rt Exp $

#include "globvar.hh"
#include "readdata.hh"
// #include "table.hh"
#include "enumerat.hh"
#include "matrix.hh"
#include "stnobj.hh"


#ifndef ___STNOBJ_S_HH
#define ___STNOBJ_S_HH		// Ƥ2٥󥯥롼ɤƤס

// 塦ȯֳݾڤŪȤإ֥ȥ饹
// ֻʬ fluctuation Ԥ碌ĥǽĤ
class station_obj_stationstop_variation
: public station_obj {

  private:

    // readfile ѿ
    bool sw_rf_disturbance;	// disturbance ޥɤ
    bool sw_disturbance_done;	// disturbance λ
    bool sw_delay_comm_yet;	// delay_comm ̤λ
    bool sw_disturb_control;	// ַԤؼ
    double tsim_distcomm;	// ̿Ԥ

  protected:

    double d_init;	// ֤٤餻 disturbance ޥɤǥå
    bool sw_disturb;	// αؤ֤٤餻
    control_disturbance_type cd_type;	// αؤ֤٤餻
    int control_station_object_number;	// αؤ֤򤫤
    double control_station_object_value;	//  []
    double control_station_object_time;
			// 򤫤ִ֡ʻ []
    const station_obj_stationstop_variation* control_stnobj_p;
			// 򤫤оݤȤʤ station_obj ؤΥݥ
    double tarr_delay_add;	// tarr_delay ǲäʬ
    double tdept_delay_add;	// tdept_delay ǲäʬ
    int tdept_delay_add_imove;	// ä٤

  protected:

    // ĥ饹Τ readfile 桼ƥƥ
    void readfile_additional_readfile(FILE*, commandvalue);
    void readfile_additional_bool_set();
    bool readfile_additional_bool_eval();

    // ֻʬե饯奨Τε
    void stationstop_variation_func( from_station&, int );
    void stationstop_variation_func_delay( from_station&, int );
    void stationstop_variation_func_delay_core( from_station&, int );
    void stationstop_variation_delay_comm();

    void membercopy(const station_obj_stationstop_variation&);
				// Хԡ

  public:

    station_obj_stationstop_variation();	// constructor
    station_obj_stationstop_variation
    (const station_obj_stationstop_variation&);	// constructor: X(X&)
    station_obj_stationstop_variation&
    operator=(const station_obj_stationstop_variation&);	// 黻

    void set_stnobj_ssvar_p(const station_obj_stationstop_variation* x)
        {control_stnobj_p = x;}	// оݤݥ󥿤ǥå

    int control_target_stnobj() {return control_station_object_number;}
    double control_amount() {return control_station_object_value;}
    double control_time() {return control_station_object_time;}
    control_disturbance_type control_type() {return cd_type;}

    double tdept_delay(const train*) const;	// tdept_deley ֤
    double tarr_delay(const train*) const;	// tarr_deley ֤
    void this_train_will_depart(const train*) const;	// ֽȯ
};

#endif /* ! ___STNOBJ_S_HH */
