// -- This may look like C code, but it's really C++ --
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Prof. SONE's Laboratory, the Univ. of Tokyo.)
// trmove.cc --- functions in class trainmotion, class traindata
// -----
// ChangeLog:
// 2009. 12. 25
//  Reshaped.
// -----


#include <cstdio>

#include "train.hh"

#define LOWSPEED 2.914
#define HIGHSPEED 1.65



// ž̷
double
trainmotion :: eqrot
()
{
  double wall_emp = wall ( 0 ) ;
  return wrotate * wall_emp / wall ( conges ) ;
}



// ʿóľǤ񹳡tf
double
train :: tresist
( double rtvel )
{
  double rt ;
  rt = ( rsc_ad + rsc_bd * rtvel ) * wdrive () ;
  rt += ( rsc_at + rsc_bt * rtvel ) * wtrail () ;
  rt += ( rsc_cc + rsc_cl * setnum ) * rtvel * rtvel ;
  if ( rtvel <= 3.0 )
  {
    rt *= LOWSPEED / HIGHSPEED ;
  }
  return rt / 1e3 ;
}
