// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// nextsta.hh --- class nextsta and related classes and structs
// -----
// ChangeLog:
// 2007. 11. 22
//  Removed fprintf(...).
// -----

#include "RS_Object.hh"
#include "DataInSection.hh"
#include "globvar.hh"
#include "readdata.hh"
#include "enumerat.hh"
#include "stnobj.hh"
#include "tinyxml.h"

#include <vector>
#include <iostream>
#include <stdexcept>

using std :: vector ;
using std :: cerr ;
using std :: endl ;



#ifndef ___NEXTSTA_HH
#define ___NEXTSTA_HH		// Ƥ2٥󥯥롼ɤƤס


/******************************************************************
 * struct _TrackProfileDataElement
 ******************************************************************/
struct _TrackProfileDataElement
{

  // -----
  // Declaration of initialiser class
  // ѥ饹
  // -----

  struct Init
  {
    TiXmlAttribute const * _v ;

    Init () { _v = 0 ; }
  } ;

  double _v ;

  _TrackProfileDataElement () { _v = 0 ; }
  _TrackProfileDataElement ( Init const & ) ;
  explicit _TrackProfileDataElement ( double _v_ ) : _v ( _v_ ) {}

  _TrackProfileDataElement ( _TrackProfileDataElement const & x )
    : _v ( x . _v ) {}

  _TrackProfileDataElement & operator= ( _TrackProfileDataElement const & x )
  { if ( & x  == this ) return * this ; _v = x . _v ; return * this ; }

} ;



/******************************************************************
 * class _TrackProfileDataSet
 ******************************************************************/

// Typedef
typedef DataInSection < _TrackProfileDataElement ,
                        _TrackProfileDataElement :: Init > GCV_Section ;

class _TrackProfileDataSet
  : public vector < GCV_Section >
{

private :

  double t_first ;
  double t_last ;

public :

  // Constructor
  _TrackProfileDataSet ( TiXmlNode const * ) ;

  // X(X&)
  _TrackProfileDataSet ( _TrackProfileDataSet const & x )
    : vector < GCV_Section > ( x ) , t_first ( x . t_first ) ,
      t_last ( x . t_last ) {}

  // Operator =
  _TrackProfileDataSet & operator= ( const _TrackProfileDataSet & x )
  { vector < GCV_Section > :: operator= ( x ) ; t_first = x . t_first ;
    t_last = x . t_last ; return * this ; }

  double getStartPosition () const { return t_first ; }
  double getEndPosition () const { return t_last ; }

private :

  // Default constructor prohibited
  explicit _TrackProfileDataSet () ;

} ;



// ----
// Forward declaration of class SOC_FeedForward_Data.
// SOC_FeedForward_Data 饹.
// ----
class SOC_FeedForward_Data ;


// ۡ®٥ǡ
struct gcvel
{
  double stp ; 	// ֳ
  double endp ;	// ֽλ ; endp > stp
  double grad ;	// ۡdirec = 1 ФФѡߥ
  double curve ;	// Ⱦ
  double vlimit ;	// ®

  gcvel () : stp ( 0 ) , endp ( 0 ) , grad ( 0 ) , curve ( 0 ) , vlimit ( 0 )
  {}
} ;



// ----
// Replacement to NoRefTable
// ----
class _GCV_Container
  : private vector < gcvel >
{
public :
  typedef size_type gc_size_type ;
  typedef iterator gc_iterator ;

  gc_iterator gc_begin () { return begin () ; }
  gc_iterator gc_end () { return end () ; }
  gc_size_type gc_size () const { return size () ; }
  void gc_push_back ( gcvel x ) { push_back ( x ) ; }

  _GCV_Container & substitute ( _GCV_Container const & x )
  { return operator= ( x ) ; }

  gcvel & getElement ( gc_size_type i )
  { try { return at ( i ) ; } catch ( std :: out_of_range )
    { cerr << "Error: subscript out of range (_GCV_Container)" << endl ;
      exit ( 26 ) ; } }
  
  gcvel const & getElement ( gc_size_type i ) const
  { try { return at ( i ) ; } catch ( std :: out_of_range )
    { cerr << "Error: subscript out of range (_GCV_Container)" << endl ;
      exit ( 26 ) ; } }

  void gc_renew () { clear () ; }
  void gc_renew ( gc_size_type ix ) { clear () ; reserve ( ix ) ; }

  _GCV_Container () : vector < gcvel > () {}
  _GCV_Container ( _GCV_Container const & x ) : vector < gcvel > ( x ) {}

} ;

  

// ش֤θ۶˴ؤǡ
class gradcrv
  : public _GCV_Container ,
    public virtual RS_Object ,
    public readdata
{

  string name_sjis ;
  void setNameSjis ( string const & x ) { name_sjis = x ; }

  _TrackProfileDataSet * _ds_g ;
  _TrackProfileDataSet * _ds_c ;
  _TrackProfileDataSet * _ds_v ;

  bool sw_ref_g ;
  bool sw_ref_c ;
  bool sw_ref_v ;

  string name_ref_g ;
  string name_ref_c ;
  string name_ref_v ;

public :

  // constructor
  gradcrv () : RS_Object () , _GCV_Container () ,
               _ds_g ( 0 ) , _ds_c ( 0 ) , _ds_v ( 0 ) {}
  gradcrv ( TiXmlNode const * ) ;

  // constructor: X(X&)
  gradcrv ( gradcrv const & x ) : RS_Object ( x ) , _GCV_Container ( x ) ,
                                  _ds_g ( 0 ) , _ds_c ( 0 ) , _ds_v ( 0 ) {}

  void getReferencedXmlDataSetsAndConvert
  ( map < string , vector < gradcrv * > :: size_type > const & ,
    vector < gradcrv * > const & ) ;

  void deleteXmlDataSets ()
  { if ( _ds_g ) delete _ds_g ; if ( _ds_c ) delete _ds_c ;
    if ( _ds_v ) delete _ds_v ; _ds_g = _ds_c = _ds_v = 0 ; }

  _TrackProfileDataSet const * getGradientDataSet () const
  { return _ds_g ; }
  _TrackProfileDataSet const * getCurvatureDataSet () const
  { return _ds_c ; }
  _TrackProfileDataSet const * getSpeedRestrictionDataSet () const
  { return _ds_v ; }

  // destructor ʤ

  // ѱ黻ҤΥС
  gradcrv & operator= ( gradcrv const & ) ;

  // gcvel ɲáʥǡåա
  gradcrv & operator+= ( gcvel const & ) ;

  // gcvel ǡν
  gradcrv & renewpos ( int , double ) ;

  // ե꡼
  int readfile ( FILE * ) ;

  // Getting name string for display
  string const & getNameSjis () const { return name_sjis ; }

} ;



// 2ĤĤʤfriend ס
gradcrv & operator+ ( gradcrv & , gradcrv & ) ;


class feeder ;
class diapattern ;



// αؤޤǤԤ˴ؤǡ
class nextsta
  : public gradcrv
{

private :

// ѿ
  int direc ;  	// 
  double startp ;	// ȯ
  double arp ;		// ã
  double arv ; 	// ɸ®, nxp = Pass_station  nonzero 
  double art ;		// ã
  int nfline ;  	// ֹ
  nextsta_pattern nxp ;	// ؾˡ
  double tstop ;	// ֻ
  double vnoff ;	// Υå®١ʰȤȤʤ
  int ndpt ;	// diapattern ֹ
  int ndp ;	// diapattern ֹ
  double nextsw ;	// Υǡؤ

  // isnextsw added 1997.10.6 to work around bug in
  // checking of twhole in dpt-rf.cc --- RT
  bool isnextsw ;	// nextsw ꤷ true
  nextsta * nxx ;	// μإǡ
  double bufcont ;	// ;͵ʬĴѿ

  dp_command dcmd ;	// ѿ
  double conges ;	// Ψ g_sw_conges_station  true ΤȤΤͭ

  // station_obj ϥݥ󥿤ǳǼ
  station_obj * x_stnobj ;	// μإǡˤä夹٤
  int n_stnobj ;	// stnobj Ĥ٤ station_obj ֹ
  int voie ;		// ٤
  int ilno ;		// ؤ˥ץϩֹ
  int olno ;		// ؤФϩֹ
  int notrw ;		// ؤԤĤ٤ֿ
  bool is_pass ;	// ̲֤Ǥ true

  // *********************************************************************
  // Mutables / const дؿѹǽѿ
  // *********************************************************************

  // pfi ܤϹ/Τ ޤǤϱشԻʬ򶸤碌
  mutable double pfcont ;

  // Իʬ碌򤷤
  mutable int pfi ;

  // ζ֤Ϻǽ餫 ontime_prec ǻֹ碌
  mutable bool ontprec ;

  // prt: ϹΨ, setprt: ϹΨåȤ true
  mutable double prt ;
  mutable bool setprt ;


  // ѿɬפʤ
  vector < gc_size_type > greq_gnum ;		// gradcrv Τʤֹ
  vector < string > greq_names ;	// gradcrv Τʤֹ
  vector < int > greq_renposf ; 	// renewpos ΤΥե饰
  vector < double > greq_gzpos ;	// renewpos ΤιΥ

  // ׵桢ǽϥ
  vector < gc_size_type > :: size_type greq_x ;

  // ѿϾ copy ޥɤǽǤ褦ˤʤäȤΤ
  bool sw_nreq ;	// readfile  copy ꤷ
  int nreq_kz ;	// copy Τѿ (ndpt)
  int nreq_kx ;	// Ʊ              (ndp)

  // ----
  // SOC curve related.
  // SOCִϢ.
  // ----
  SOC_FeedForward_Data const * _soc ;
  string _soc_name ;
  bool _wants_soc ;

  // ؿ

  // ----
  // Stepping forward in gcvel vector.
  // gcvel ٥ȥˤ1.
  // ----
  bool fpgrad ( gc_size_type & ) const ;

  // ----
  // Stepping backward in gcvel vector.
  // gcvel ٥ȥˤ1ĸ.
  // ----
  bool bpgrad ( gc_size_type & ) const ;
  // ۥǡθ֤߰(f)/(b)

  void chkdirec () const {		// ǧ롼
    if ( direc != 1 && direc != - 1 ) {
      cerr << "Error: int direc must be 1 or -1" << endl ;
      exit ( 15 ) ;	// error 15: ꥨ顼
    }
  }

public :

// ؿ
//	nextsta(int) ;		// constructor: gxx θĿ (int)
  nextsta ( nextsta & ) ;		// constructor: 
  nextsta () ;				// empty constructor
  ~nextsta () { nxx = 0 ; }	// destructor
  nextsta & operator= ( nextsta const & ) ;
  nextsta & operator= ( gradcrv const & ) ;  	// ѱ黻ҤΥС

  // ----
  // Reading the input file.
  // եɤ߹.
  // ----
  int readfile ( FILE * , char * ) ;
  bool readfile_xml ( TiXmlNode const * ) ;	// XML node

  // ѿʤϽ
  void setvar
  ( double , int , double , double , double , int , double , double) ;

  // ----
  // The first three of the below "set" functions use "mutable" variables
  // ʲѿåѴؿκǽ3Ĥ mutable ѿѤ
  // ----
  void setpf ( double x , int i ) const { pfcont = x ; pfi = i ; }
  void prate ( double x ) const { prt = x ; setprt = true ; }
  void set_ontprec () const { ontprec = true ; }
  void set_ndp ( int n ) { ndp = n ; }		// ndp Υå
  void set_ndpt ( int n ) { ndpt = n ; }	// ndpt Υå
  void prtreset () { setprt = false ; }
  void prtinit () { prtreset () ; prt = bufcont = pfcont = 0.0 ; }
  void setbuf ( double x ) { bufcont += x ; }
  void setdc ( dp_command x ) { dcmd = x ; }
  void set_nextnxx ( nextsta * x ) { nxx = x ; }
  void set_stnobj ( station_obj * x ) { x_stnobj = x ; }

  // greq_* Ȥ֤bool ֤ͤϡ true, ʤʤ false
  bool get_greq ( gc_size_type & , int & , double & ) ;
  bool get_greq ( map < string , vector < gradcrv * > :: size_type > const & ,
                  gc_size_type & , int & , double & ) ;

  // ۥǡθַ߰
  gc_size_type dpgrad ( double ) const ;

  // ۥǡθֹ߰碌
  void adjpgrad ( gc_size_type & , double ) const ;

  void arv_pass () ;			// arv ν

  void push_to_station ( to_station ) ;		// to_station ֥
  void push_to_station_init ( to_station ) ;	//  station_obj 
  void push_from_station_init ( from_station ) ;
			// from_station ֥Ȥ station_obj 
  double tarr_delay ( const train * ) const ;	// Ϥؼ٤ʬ

  bool prtset () const { return setprt ; }
  double bufdiff () const { return bufcont ; }
  double prate () const { return prt ; }
  double congestion () const { return conges ; }
  bool get_ontprec () const { return ontprec ; }

  // isnextswitch() added 1997.10.6 to work around bug in
  // checking of twhole in dpt-rf.cc
  bool isnextswitch () const { return isnextsw ; }
  double nextswitch () const { return nextsw ; }
  double parrive () const { return arp ; }
  double varrive () const { return arv ; }
  double tarrive () const { return art ; }
  double tarrive ( int ) const ;	// ontime , Ѥ
  double tarrive ( bool ) const ;	// setbuf ѡ˾Ѥ
  nextsta_pattern nxxptn () const { return nxp ; }
  double stoptime () const { return tstop ; }
  double pstart () const { return startp ; }
  nextsta * nextnxx () { return nxx ; }
  nextsta const * nextnxx () const { return nxx ; }
  station_obj * stnobj () const { return x_stnobj ; }
  int feedlinenumber () const { return nfline ; }
  int direction () const { return direc ; }
  int dptnum () const { return ndpt ; }
  int stnobjnum () const { return n_stnobj ; }
  int voienum () const { return voie ; }
  int ilinenum () const { return ilno ; }
  int olinenum () const { return olno ; }
  int trwaitnum () const { return notrw ; }
  bool pass_stn () const { return is_pass ; }
  int dpttbl () const { return ndp ; }		// ѿ
  gc_size_type dqgrad () const {	// ۥǡνذ
    chkdirec () ;
    if ( direc == 1 ) return ( gc_size () - 1 ) ;
    if ( direc == - 1 ) return 0 ;
    cerr << "Error: direction error in dqgrad()" << endl ;
    exit ( 1 ) ;
  }
  gc_size_type dsgrad () const {	// ۥǡεذ
    chkdirec () ;
    if ( direc == 1 ) return 0 ;
    if ( direc == - 1 ) return ( gc_size () - 1 ) ;
    cerr << "Error: direction error in dqgrad()" << endl ;
    exit ( 1 ) ;
  }
  void fwpgrad ( gc_size_type & zz ) const { chkdirec () ; fpgrad ( zz ) ; }
  void bkpgrad ( gc_size_type & zz ) const { chkdirec () ; bpgrad ( zz ) ; }
		// ۥǡθ֤߰(fw)/(bk)

  double epoint ( gc_size_type pgrad ) const {	// ǡλ֤
    chkdirec () ;
    if ( direc == 1 )
      return getElement ( pgrad ) . endp ;	// direc= 1 ʤ endp
    else return getElement ( pgrad ) . stp ;	//       -1 ʤ stp
  }
  double spoint ( gc_size_type pgrad ) const {	// ǡ֤ؿ
    chkdirec () ;
    if ( direc == 1 )
      return getElement ( pgrad ) . stp ;		// direc= 1 ʤ stp
    else return getElement ( pgrad ) . endp ;	//       -1 ʤ endp
  }
  
  double grad ( gc_size_type pgrad ) const
  { return getElement ( pgrad ) . grad ; }
  double curve ( gc_size_type pgrad ) const
  { return getElement ( pgrad ) . curve ; }
  double vlimit ( gc_size_type pgrad ) const ;
		// ΰ֤ۡȾ¡®٤֤ؿ

  double grad ( double pos ) const { return grad ( dpgrad ( pos ) ) ; }
  double curve ( double pos ) const { return curve ( dpgrad ( pos ) ) ; }
  double vlimit ( double pos ) const { return vlimit ( dpgrad ( pos ) ) ; }
		// а֤ۡȾ¡®٤֤ؿ

  double out_of_station () const ;

  // ----
  // SOC curve related.
  // SOCִϢ.
  // ----
  SOC_FeedForward_Data const * get_SOC_Curve () const { return _soc ; }
  string const & get_SOC_Key () const { return _soc_name ; }
  bool wants_SOC_Curve () const { return _wants_soc ; }
  void set_SOC_Curve ( SOC_FeedForward_Data const * x ) { _soc = x ; }

} ;



#endif /* ! ___NEXTSTA_HH */
