// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// rf_ffile.cc --- read data from files: F file
// -----
// ChangeLog:
// 2007. 11. 21
//  Redirected log messages to l_file.
// -----

#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <cstring>
#include <cctype>
#include <iostream>
#include <sstream>
#include <iomanip>

#include "kidenrt.hh"

//#define DEBUG


using std :: ostringstream ;
using std :: fixed ;
using std :: setprecision ;



// feeder.dat ɤե
void
feeder :: rf_ffile
()
{
  FILE * feeddat = fopen ( f_file , "r" ) ;
  if ( ! feeddat ) err_access ( f_file ) ;
  int sia ;
  double sda ;
  ostringstream o_ff ;
  while ( 1 )
  {
    getcommand ( feeddat , f_file ) ;
    if ( cmpcommand ( "feeders" ) )
    {
      // while ʸȴ
      break ;
    }
    else if ( cmpcommand ( "nominal_voltage" ) )
    {
      getdouble ( feeddat , f_file , nominal_volt ) ;
      o_ff . clear () ;
      o_ff . str ( "" ) ;
      o_ff << "nominal voltage = " << fixed << setprecision ( 1 )
           << nominal_volt << " " ;
      l_ofs << o_ff . str () << endl ;
    }
    else if ( cmpcommand ( "options" ) )
    {
      getcommand ( feeddat , f_file ) ;
      if ( cmpcommand ( "ccalresult" ) )
      {
	if ( g_sw_ccalresult )
	{
	  g_sw_ccalresult = false ;
	  l_ofs << "OK, toggled g_sw_ccalresult to false" << endl ;
	}
	else
	{
	  g_sw_ccalresult = true ;
	  l_ofs << "OK, toggled g_sw_ccalresult to true" << endl ;
	}
      }
      else if ( cmpcommand( "ssdirection" ) )
      {
	if ( g_sw_ss_direction )
	{
	  g_sw_ss_direction = false ;
	  l_ofs << "OK, toggled g_sw_ss_direction to false" << endl ;
	}
	else
	{
	  g_sw_ss_direction = true ;
	  l_ofs << "OK, toggled g_sw_ss_direction to true" << endl ;
	}
      }
      else if ( cmpcommand ( "kilowatt_subout" ) )
      {
	if ( g_sw_kilowatt_subout )
	{
	  g_sw_kilowatt_subout = false ;
	  l_ofs << "OK, toggled g_sw_kilowatt_subout to false" << endl ;
	}
	else
	{
	  g_sw_kilowatt_subout = true ;
	  l_ofs << "OK, toggled g_sw_kilowatt_subout to true" << endl ;
	}
      }
      else if ( cmpcommand ( "per_car_out" ) )
      {
	if ( g_sw_per_car_out )
	{
	  g_sw_per_car_out = false ;
	  l_ofs << "OK, toggled g_sw_per_car_out to false" << endl ;
	}
	else
	{
	  g_sw_per_car_out = true ;
	  l_ofs << "OK, toggled g_sw_per_car_out to true" << endl ;
	}
      }
      else if ( cmpcommand ( "nosetviold" ) )
      {
	if ( g_sw_nosetviold )
	{
	  g_sw_nosetviold = false ;
	  l_ofs << "OK, toggled g_sw_nosetviold to false" << endl ;
	}
	else
	{
	  g_sw_nosetviold = true ;
	  l_ofs << "OK, toggled g_sw_nosetviold to true" << endl ;
	}
      }
      else if ( cmpcommand ( "csv_has_noshibo" ) )
      {
	if ( g_sw_csv_has_noshibo )
	{
	  g_sw_csv_has_noshibo = false ;
	  l_ofs << "OK, toggled g_sw_csv_has_noshibo to false" << endl ;
	}
	else
	{
	  g_sw_csv_has_noshibo = true ;
	  l_ofs << "OK, toggled g_sw_csv_has_noshibo to true" << endl ;
	}
      }
      else if ( cmpcommand ( "csv_has_rnotch_for_capper" ) )
      {
	if ( g_sw_csv_has_rnotch_for_capper )
	{
	  g_sw_csv_has_rnotch_for_capper = false ;
	  l_ofs << "OK, toggled g_sw_csv_has_rnotch_for_capper to false"
                << endl ;
	}
	else
	{
	  g_sw_csv_has_rnotch_for_capper = true ;
	  l_ofs << "OK, toggled g_sw_csv_has_rnotch_for_capper to true"
                << endl ;
	}
      }
      else if ( cmpcommand ( "csv_without_quotation" ) )
      {
	if ( g_sw_csv_without_quotation )
	{
	  g_sw_csv_without_quotation = false ;
	  l_ofs << "OK, toggled g_sw_csv_without_quotation to false"
                << endl ;
	}
	else
	{
	  g_sw_csv_without_quotation = true ;
	  l_ofs << "OK, toggled g_sw_csv_without_quotation to true"
                << endl ;
	}
      }
      else err_eof ( f_file ) ;
    }
    else err_eof ( f_file ) ;
  }
  getint ( feeddat , f_file , feeders ) ;
  l_ofs << "feeder setvar = " <<  feeders << " " ;

  // dp_command ɤ߹
  getcommand ( feeddat , f_file ) ;

  //  : -Wall warning Τ
  dp_command dpcmx = No_comm ;
  if ( cmpcommand ( "Delay_yes" ) )
    dpcmx = Delay_yes ;
  else if ( cmpcommand ( "Buffer_yes" ) )
    dpcmx = Buffer_yes ;
  else if ( ! ( cmpcommand ( "No_comm" ) ) )
    err_eof ( f_file ) ;
  l_ofs << tmpch << endl ;

  // dp_command Υå
  for ( int i = 0 ; i < ndp; ++ i )
    getDPT ( i ) . setdc ( dpcmx ) ;

  // feedline γ
  for ( int i = 0 ; i < feeders ; ++ i )
  {
    feedline * x = new feedline ;
    if ( ! x )
    {
      std :: cerr << "Error: memory allocation fault" << std :: endl ;
      exit ( 37 ) ;
    }
    vec_fln . push_back ( x ) ;

    // *** feedline object ֹã
    getFLN ( i ) . setnfline ( i ) ;
    getFLN ( i ) . renewssc ( nss + ncar ) ;
  }
  getcommand ( feeddat , f_file ) ;
  cmpcommand ( "freeruns" , f_file ) ;
  getint ( feeddat , f_file , nfree ) ;
  l_ofs << "free running cycle(s) = " << nfree << endl ;
  getcommand ( feeddat , f_file ) ;
  cmpcommand ( "simulatings" , f_file ) ;
  getint ( feeddat , f_file , nsim ) ;
  l_ofs << "simulating cycle(s) = " << nsim << endl ;

  // ηĹ
  double sdb ;

  // : -Wall warning Τ
  feeder_shape fsp = Long ;

  for ( int i = 0 ; i < feeders ; ++ i )
  {
    getcommand ( feeddat , f_file ) ;
    if ( strcmp ( tmpch , "setfeedline" ) != 0 )
      err_eof ( f_file ) ;
    if ( gettwodbls ( feeddat , sda , sdb ) == EOF )
      err_eof ( f_file ) ;
    getcommand ( feeddat , f_file ) ;
    static char tcx [ TMPCHSIZ ] ;
    strcpy ( tcx , tmpch ) ;
    if ( strcmp ( tmpch , "Long" ) == 0 )
      fsp = Long ;
    else if ( strcmp ( tmpch , "0" ) == 0 )
    {
      fsp = Long ;
      strcpy ( tcx , "Long" ) ;
    }
    else if ( strcmp ( tmpch , "Circle" ) == 0 )
      fsp = Circle ;
    else if ( strcmp ( tmpch , "1" ) == 0 )
    {
      fsp = Circle ;
      strcpy ( tcx , "Circle" ) ;
    }
    else
      err_eof ( f_file ) ;
    o_ff . clear () ;
    o_ff . str ( "" ) ;
    o_ff << "feedline ( " << i << " ) set variables: " << fixed
         << setprecision ( 3 ) << sda << " " << setprecision ( 5 ) << sdb
         << " " << tcx ;
    l_ofs << o_ff . str () << endl ;
    getFLN ( i ) . setvar ( sda , sdb , fsp ) ;
  }

  // Ž³ǡ feedline, elecchar (sub)
  getcommand ( feeddat , f_file ) ;
  if ( strcmp ( tmpch , "ssfeederconnections" ) != 0 ) err_eof ( f_file ) ;
  if ( getint ( feeddat , sia ) == EOF ) err_eof ( f_file ) ;
  l_ofs << "number of substation/feeder connection data = " << sia << endl ;
  feedpos fp ;
  ssfeedconnect sfcn ;
  for ( int i = 0 ; i < sia ; ++ i )
  {
    gettwoints ( feeddat , f_file , fp . nfline , fp . csno ) ;
    getthreedbls ( feeddat , f_file , fp . pos , fp . sttimp , fp . endimp ) ;
    if ( fp . nfline < 0 || fp . nfline >= feeders
	 || fp . csno < 0 || fp . csno >= nss )
      err_eof ( f_file ) ;
    o_ff . clear () ;
    o_ff . str ( "" ) ;
    o_ff << "feedline( " << fp . nfline << " ) *= " << fp . csno << " "
         << fixed << setprecision ( 4 ) << fp . pos << " "
         << setprecision ( 5 ) << fp . sttimp << " " << fp . endimp ;
    l_ofs << o_ff . str () << endl ;
    getFLN ( fp . nfline ) *= fp ;
    sfcn = fp ;

    // Error not found. Add the connection data into substation.
    // 顼Ĥ餺ľܤ
    getSUB ( fp . csno ) . feedcon () += sfcn ;
  }
  fclose ( feeddat ) ;

  // 礭
  ymtx . renewmn ( ncss , ncss ) ;
  gff_xx . renewmn ( ncss , ncss ) ;
  gamma . renewmn ( ncss ) ;
  fvec . renewmn ( ncss ) ;

  // ñʥǡå
  bool patc = false ;
  for ( int i = 1 ; i < ndp ; ++ i )
  {
    if ( getDPT ( i ) . ptntime () != getDPT ( i - 1 ) . ptntime () )
      patc = true ;
  }
  if ( patc )
  {
    cerr << "Error: Cycle times must be uniform across all diagram patterns."
         << endl << " Check the N-file." << endl ;
    exit ( 1 ) ;
  }
  t_cyc = getDPT ( 0 ) . ptntime () ;
}
