// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Prof. SONE's Laboratory, the Univ. of Tokyo.)
// trn_cons.cc --- class train functions on nextmotion: nm_constv
// -----
// ChangeLog:
// 2009. 11. 27
//  Added AMANO_B comments. Headers fixed to new ISO C++ standards.
// -----

#include <cstdio>
#include <cstdlib>
#include <cmath>

#include "train.hh"

#define INVLIM 1e-5

//#define DEBUG
using std :: cerr ;
using std :: endl ;



// ®μַ׻
void
train :: nm_constv
( double tracff )
{

  enableMechanicalPowerCalculation () ;
  nposc () ;
  disableMechanicalPowerCalculation () ;
#ifdef DEBUG
  cerr << "nm_constv: car " << car_number () << ": nposc ended" << endl ;
  l_ofs << "nm_constv: car " << car_number () << ": nposc ended" << endl ;
#endif

  if ( g_sw_station_object_valid && g_sw_disttrain_ended )
  {
    if ( pos * direc ()
         >= nxx -> parrive () * direc () - nxx -> out_of_station () )
    {
      // ش֤߰᤮ǧ
      sw_x_btws = false ;
    }
  }

#ifdef DEBUG
  cerr << "nm_constv: car " << car_number () << ": sw_x_btws check end"
       << endl ;
  l_ofs << "nm_constv: car " << car_number () << ": sw_x_btws check end"
        << endl ;
#endif

  if ( nxx -> nxxptn () == Pass_pass
       || nxx -> nxxptn () == Station_pass )
  {
    // ̲ξ bklen ξǤ褤
    if ( nm_nxxps () )
    {
      return ;		// إǡ촹
    }
  }

#ifdef DEBUG
  cerr << "nm_constv: car " << car_number () << ": station pass check end"
       << endl ;
  l_ofs << "nm_constv: car " << car_number () << ": station pass check end"
        << endl ;
#endif

  if ( bklen () * direc () >= nxx -> parrive () * direc () )
  {
    // ե֥졼žξ
    stat = Brake ;
    brakev = nxx -> varrive () ;
    iamcoast = false ;
    iamconst = true ;
    rnotchold = rnotch = - 1.0 ;
    return ;
  }

#ifdef DEBUG
  cerr << "nm_constv: car " << car_number () << ": bklen check end"
       << endl ;
  l_ofs << "nm_constv: car " << car_number () << ": bklen check end"
        << endl ;
#endif

  if ( g_sw_station_object_valid && g_sw_disttrain_ended )
  {
    // ͭΤߥå
    double bkl_drx = bklen ( 0.0 ) * direc () ;

    if ( bkl_drx >= nxx -> parrive () * direc () - nxx -> out_of_station ()
         // && g_sw_stop_between_oriented
         && nxx -> stnobj () -> voie_occupied ( this ) )
    {
      // ե֥졼ξ: out_of_station ΰ֤ޤǤ
      // **** ش߻ظξ礫ı̤̤
      // **** out_of_station ΰ֤ޤǤ®0ˤʤʤ
      stat = Brake ;
      brakev = 0.0 ;		// ɸ®: 
      sw_btws = true ;		// شߤΤΥ֥졼ʤΤ true
      sw_x_btws = false ;	// ش֤߰᤮ǧ
      rnotchold = rnotch = - 1.0 ;
      return ;
    }
  }

#ifdef DEBUG
  cerr << "nm_constv: car " << car_number () << ": signal stop check end"
       << endl ;
  l_ofs << "nm_constv: car " << car_number () << ": signal stop check end"
        << endl ;
#endif

  if ( vlimitbrake () )
  {
    //  brake Ƚ
    return ;
  }
  
#ifdef DEBUG
  cerr << "nm_constv: car " << car_number () << ": vlimit check end"
       << endl ;
  l_ofs << "nm_constv: car " << car_number () << ": vlimit check end"
        << endl ;
#endif

  if ( nm_stnobj_brake () )
  {
    // ؤˤ֥졼
    return ;
  }
  
#ifdef DEBUG
  cerr << "nm_constv: car " << car_number () << ": signal brake check end"
       << endl ;
  l_ofs << "nm_constv: car " << car_number () << ": signal brake check end"
        << endl ;
#endif

  if ( nm_stnobj_power () )
  {
    // ؤˤϹ
    return ;
  }

#ifdef DEBUG
  cerr << "nm_constv: car " << car_number () << ": signal accel check end"
       << endl ;
  l_ofs << "nm_constv: car " << car_number () << ": signal accel check end"
        << endl ;
#endif

  if ( iamcoast )
  {
    // ƹΰˤ
    if ( tresist ( vel , pgrad ) >= 0
         || ( vel < nxx -> vlimit ( pgrad )
              || nxx -> vlimit ( pgrad ) < INVLIM ) )
    {
      // 񹳤ޤ®¤ˤʤ
      iamconst = false ;
      iamcoast = true ;		// ƹΰ
      stat = Coast ;
      rnotchold = rnotch = 0.0 ;
      return ;
    }
    else
    {
      stat = Const_vel ;
      return ;
    }
  }
  else
  {
    // Ϲΰˤ
    double ontx = ontimesub ( pos , pgrad , vel , t_sim ) ;
    double x_tard = 0.0 ;	// ٤ʬδ
    if ( g_sw_station_object_valid && g_sw_disttrain_ended )
    {
      // ͭΤߥå
      // **** nxx -> tarr_delay( this ) :      ̵ zero ʤΤ
      x_tard = nxx -> tarr_delay ( this ) ; // 줬̾
      if ( g_sw_stop_between_oriented && sw_x_btws )
      {
        // ش߻ظǱش֤߰᤮Ƥʤ
        x_tard = 0.0 ;	// ٤ʤȤƥѥ
      }
    }
    if ( ontx - tdept + taudx <= nxx -> tarrive ( pfirst ) + x_tard )
    {
      // Υåձžξ
      iamconst = false ;
      iamcoast = true ;		// ƹΰ
      if ( tresist ( vel , pgrad ) > 0
           || ( vel < nxx -> vlimit ( pgrad )
                || nxx -> vlimit ( pgrad ) < INVLIM ) )
      {
        stat = Coast ;
        rnotchold = rnotch = 0.0 ;
        return ;
      }
      else
      {
        stat = Const_vel ;
        return ;
      }
    }
  }

  if ( vel < nxx -> vlimit ( pgrad ) && iamconst )
  {
    stat = Power ;
    ontprec = nxx -> get_ontprec () ;
    iamcoast = false ;
    rnotchold = rnotch = 1.0 ;
  }
}
