// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// stn_head.cc --- functions for class station_obj: headway calculation
// -----
// ChangeLog:
// 2007. 11. 22
//  Redirected log messages to l_file.
// -----

#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <iostream>
#include <sstream>
#include <iomanip>

#include "stnobj.hh"
#include "train.hh"

//#define DEBUG


using std :: ostringstream ;
using std :: fixed ;
using std :: setprecision ;
using std :: setw ;


int arrivalcomp
( const void* p, const void* q ) {
    to_station* a = ( to_station* ) p;
    to_station* b = ( to_station* ) q;
    if ( a->tarrive > b->tarrive ) {
        return 1;
    } else if ( a->tarrive < b->tarrive ) {
        return -1;
    } else {
        return 0;
    }
}

// ֤η׻
void station_obj::headway_cal
() {
    //*****************************************************************
    // g_sw_station_object_valid  g_sw_disttrain_ended  true 
    // ȤˤΤ߸Ƥ֤
    //*****************************************************************
    register int i;

    // äȤ٤ʤη׻
    double f_d_a, f_a_a, f_d_d, f_d_p, f_a_p, f_p_a, f_p_d, f_p_p;
    double f_res;

#ifdef DEBUG
    cerr << "headway_cal: " ;
#endif

    switch ( stnobjtype ) {
    case Vanishing:
#ifdef DEBUG
      cerr << "Vanishing:" << endl ;
#endif
        for ( i = 0; i < number(); i++ ) {
            data[ i ].tarr_delay = 0.0;		// ݥ󥿡顼
        }
        break;
    case Doubletrack_no_cross:
#ifdef DEBUG
      cerr << "Doubletrack_no_cross:" << endl ;
#endif

        // ֤̲ᡦط
#ifdef DEBUG
      cerr << "From_station trains" << endl ;
#endif
        for ( i = 0; i < nvoie; i++ ) {
            if ( ! train_departure[ i ].is_at_station ) {
#ifdef DEBUG
              cerr << "Track " << i << ": no train" << endl ;
#endif
                continue;	// Ƥʤйͤɬפʤ
            }
            if ( train_departure[ i ].notrw > 0 ) {
                // Ԥ 1ʾ: Ȥˤȯֶػ
                // *** ԤƱͤȤʤ褦̤ݾ ***
                train_departure[ i ].do_not_depart = true;
                train_departure[ i ].tdept_delay = 0.0;
                if ( t_sim > train_departure[ i ].tdept ) {
                    train_departure[ i ].tdept_delay
                        = t_sim - train_departure[ i ].tdept;
                }
#ifdef DEBUG
                cerr << "Track " << i << ": prohibit departure" << endl ;
#endif
                continue;
            }
            // ط򸫤
            train_departure[ i ].do_not_depart = false;
            train_departure[ i ].tdept_delay = 0.0;
#ifdef DEBUG
            cerr << "Track " << i << ": deciding departure time" << endl ;
#endif
            for ( register int j = 0; j < nvoie; j++ ) {
                if ( i == j ) continue;
                if ( train_departure[ j ].is_at_station ) {
#ifdef DEBUG
                  cerr << "Track " << j << ": train waiting" << endl ;
#endif
                continue;	// Ƥʤйͤɬפʤ
            }
                if ( train_departure[ j ].is_pass ) {
                    // ̲--ȯֻ֤
                    f_p_d
                        = pass_depart[ 0 ]( j, i )
                        + train_departure[ j ].tdept
                        + train_departure[ j ].tdept_delay;
                    f_res = f_p_d
                        - train_departure[ i ].tdept;
#ifdef DEBUG
                    cerr << "Track " << j << ": pass_depart" << endl ;
#endif
                } else {
                    // ȯ--ȯֻ֤
                    f_d_d
                        = depart_depart[ 0 ]( j, i )
                        + train_departure[ j ].tdept
                        + train_departure[ j ].tdept_delay;
                    f_res = f_d_d
                        - train_departure[ i ].tdept;
#ifdef DEBUG
                    cerr << "Track " << j << ": depart_depart" << endl ;
#endif
                }

#ifdef DEBUG
                ostringstream o_x ;
                o_x << "f_res: " << fixed << setprecision ( 2 )
                    << setw ( 7 ) << f_res ;
                cerr << o_x . str () << endl ;
#endif

                if ( train_departure[ i ].tdept_delay < f_res ) {
                    train_departure[ i ].tdept_delay = f_res;
                }
            }
        }

        // ץ֤ȯ塦̲ط
        for ( i = 0; i < number(); i++ ) {
            int nvoie_j = data[ i ].voie;
            int nvoie_i;
            data[ i ].tarr_delay = 0.0;	// ޤϥ
            if ( i == 0 ) {	// ǽΥǡФƤƬ
#ifdef DEBUG
              cerr << "First train in to_station" << endl ;
#endif
                for ( nvoie_i = 0; nvoie_i < nvoie; nvoie_i++ ) {
                    // nvoie_i: ֤
                    // nvoie_j: ֤
                    if ( nvoie_i == nvoie_j ) {
                        // Ʊȯ
                        if ( ( ! train_departure[ nvoie_i ].is_pass )
                             && ( ! data[ i ].is_pass ) ) {
                            // ȯ--֤
                            f_d_a
                                = depart_arrival[ 0 ]( nvoie_i, nvoie_j )
                                + train_departure[ nvoie_i ].tdept
                                + train_departure[ nvoie_i ].tdept_delay;
                            f_res = f_d_a
                                - data[ i ].tarrive;
#ifdef DEBUG
                            cerr << "depart_arrival" << endl ;
#endif
                        } else if
                            ( train_departure[ nvoie_i ].is_pass
                              && ( ! data[ i ].is_pass ) ) {
                            // ̲--֤
                            f_p_a
                                = pass_arrival[ 0 ]( nvoie_i, nvoie_j )
                                + train_departure[ nvoie_i ].tdept
                                + train_departure[ nvoie_i ].tdept_delay;
                            f_res = f_p_a
                                - data[ i ].tarrive;
#ifdef DEBUG
                            cerr << "pass_arrival" << endl ;
#endif
                        } else if
                            ( ( ! train_departure[ nvoie_i ].is_pass )
                              && data[ i ].is_pass ) {
                            // ȯ--̲֤
                            f_d_p
                                = depart_pass[ 0 ]( nvoie_i, nvoie_j )
                                + train_departure[ nvoie_i ].tdept
                                + train_departure[ nvoie_i ].tdept_delay;
                            f_res = f_d_p
                                - data[ i ].tarrive;
#ifdef DEBUG
                            cerr << "depart_pass" << endl ;
#endif
                        } else {
                            // ̲--̲֤
                            f_p_p
                                = pass_pass[ 0 ]( nvoie_i, nvoie_j )
                                + train_departure[ nvoie_i ].tdept
                                + train_departure[ nvoie_i ].tdept_delay;
                            f_res = f_p_p
                                - data[ i ].tarrive;
#ifdef DEBUG
                            cerr << "pass_pass" << endl ;
#endif
                        }
                    } else {
                        // ȯ
                        if ( ( ! train_departure[ nvoie_i ].is_pass )
                             && ( ! data[ i ].is_pass ) ) {
                            // --֤
                            f_a_a
                                = arrival_arrival[ 0 ]( nvoie_i, nvoie_j )
                                + train_departure[ nvoie_i ].tarrive;
                            f_res = f_a_a
                                - data[ i ].tarrive;
#ifdef DEBUG
                            cerr << "arrival_arrival" << endl ;
#endif
                        } else if
                            ( train_departure[ nvoie_i ].is_pass
                              && ( ! data[ i ].is_pass ) ) {
                            // ̲--֤
                            f_p_a
                                = pass_arrival[ 0 ]( nvoie_i, nvoie_j )
                                + train_departure[ nvoie_i ].tdept
                                + train_departure[ nvoie_i ].tdept_delay;
                            f_res = f_p_a
                                - data[ i ].tarrive;
#ifdef DEBUG
                            cerr << "pass_arrival" << endl ;
#endif
                        } else if
                            ( ( ! train_departure[ nvoie_i ].is_pass )
                              && data[ i ].is_pass ) {
                            // --̲֤
                            f_a_p
                                = arrival_pass[ 0 ]( nvoie_i, nvoie_j )
                                + train_departure[ nvoie_i ].tarrive;
                            f_res = f_a_p
                                - data[ i ].tarrive;
#ifdef DEBUG
                            cerr << "arrival_pass" << endl ;
#endif
                        } else {
                            // ̲--̲֤
                            f_p_p
                                = pass_pass[ 0 ]( nvoie_i, nvoie_j )
                                + train_departure[ nvoie_i ].tdept
                                + train_departure[ nvoie_i ].tdept_delay;
                            f_res = f_p_p
                                - data[ i ].tarrive;
#ifdef DEBUG
                            cerr << "pass_pass" << endl ;
#endif
                        }
                    }
//                     if ( f_res < 0.0 ) f_res = 0.0;
#ifdef DEBUG
                    ostringstream o_y ;
                    o_y << "f_res: " << fixed << setprecision ( 2 )
                        << setw ( 7 ) << f_res ;
                    cerr << o_y . str () << endl ;
#endif
                    if ( data[ i ].tarr_delay < f_res ) {
                        data[ i ].tarr_delay = f_res;
                    }
                }
            } else {	// i > 0
                // 2ܰʹߤ֤֤ФΤǸƤ
                // voie_i: ֤
                // voie_j: ֤
#ifdef DEBUG
              cerr << "Successive train in to_station" << endl ;
#endif
                nvoie_i = data[ i - 1 ].voie;
//                 nvoie_j = data[ i ].voie;
                if ( nvoie_i == nvoie_j ) {
                    // Ʊȯ
                    if ( ( ! data[ i - 1 ].is_pass )
                         && ( ! data[ i ].is_pass ) ) {
                        // ȯ--֤
                        f_d_a
                            = depart_arrival[ 0 ]( nvoie_i, nvoie_j )
                            + data[ i - 1 ].tarrive
                            + data[ i - 1 ].tarr_delay
                            + data[ i - 1 ].tstop;
                        f_res = f_d_a
                            - data[ i ].tarrive;
#ifdef DEBUG
                        ostringstream o_z ;
                        o_z << "f_res: " << fixed << setprecision ( 2 )
                            << setw ( 7 ) << f_res ;
                        cerr << "departure-arrival" << endl
                             << o_z . str () << endl ;
#endif
                    } else if
                        ( data[ i - 1 ].is_pass
                          && ( ! data[ i ].is_pass ) ) {
                        // ̲--֤
                        f_p_a
                            = pass_arrival[ 0 ]( nvoie_i, nvoie_j )
                            + data[ i - 1 ].tarrive
                            + data[ i - 1 ].tarr_delay;
                        f_res = f_p_a
                            - data[ i ].tarrive;
                    } else if
                        ( ( ! data[ i - 1 ].is_pass )
                          && data[ i ].is_pass ) {
                        // ȯ--̲֤
                        f_d_p
                            = depart_pass[ 0 ]( nvoie_i, nvoie_j )
                            + data[ i - 1 ].tarrive
                            + data[ i - 1 ].tarr_delay
                            + data[ i - 1 ].tstop;
                        f_res = f_d_p
                            - data[ i ].tarrive;
                    } else {
                        // ̲--̲֤
                        f_p_p
                            = pass_pass[ 0 ]( nvoie_i, nvoie_j )
                            + data[ i - 1 ].tarrive
                            + data[ i - 1 ].tarr_delay;
                        f_res = f_p_p
                            - data[ i ].tarrive;
                    }
                } else {
                    // ȯ
                    if ( ( ! data[ i - 1 ].is_pass )
                         && ( ! data[ i ].is_pass ) ) {
                        // --֤
                        f_a_a
                            = arrival_arrival[ 0 ]( nvoie_i, nvoie_j )
                            + data[ i - 1 ].tarrive
                            + data[ i - 1 ].tarr_delay;
                        f_res = f_a_a
                            - data[ i ].tarrive;
                    } else if
                        ( data[ i - 1 ].is_pass
                          && ( ! data[ i ].is_pass ) ) {
                        // ̲--֤
                        f_p_a
                            = pass_arrival[ 0 ]( nvoie_i, nvoie_j )
                            + data[ i - 1 ].tarrive
                            + data[ i - 1 ].tarr_delay;
                        f_res = f_p_a
                            - data[ i ].tarrive;
                    } else if
                        ( ( ! data[ i - 1 ].is_pass )
                          && data[ i ].is_pass ) {
                        // --̲֤
                        f_a_p
                            = arrival_pass[ 0 ]( nvoie_i, nvoie_j )
                            + data[ i - 1 ].tarrive
                            + data[ i - 1 ].tarr_delay;
                        f_res = f_a_p
                            - data[ i ].tarrive;
                    } else {
                        // ̲--̲֤
                        f_p_p
                            = pass_pass[ 0 ]( nvoie_i, nvoie_j )
                            + data[ i - 1 ].tarrive
                            + data[ i - 1 ].tarr_delay;
                        f_res = f_p_p
                            - data[ i ].tarrive;
                    }
                }
//                 if ( f_res < 0.0 ) f_res = 0.0;
                if ( data[ i ].tarr_delay < f_res ) {
                    data[ i ].tarr_delay = f_res;
                }
            }
        }

        break;
    }	// switch ʸν
}

// ֤η׻
void station_obj::headway_cal_init
() {
    // ֤Ф notrw Ĥ
    // ̷ʤȲꤷȯͽ®ˤĤ
    for ( register int i = 0; i < nvoie; i++ ) {
        int xnotrw = 0;
        for ( register int j = 0; j < nvoie; j++ ) {
            if ( i == j )
                continue;
            if ( train_departure[ j ].tdept <
                 train_departure[ i ].tdept ) {
                xnotrw++;
            }
        }
        train_departure[ i ].notrw = xnotrw;
    }

    // to_station ֤򥽡
    // ̷ʤȲꤷͽ®
    if ( number() != 0 ) {
        qsort( data, number(), sizeof( to_station ), arrivalcomp );
    }

    // ַ׻
    headway_cal();
}
