// -- This may look like C code, but it's really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// SuppressCSV.hh --- function getSuppressCSVFlag
// -----
// ChangeLog:
// 2008. 1. 17
//  File created.
// -----


#ifndef ___SuppressCSV_HH
#define ___SuppressCSV_HH	// Ƥ2٥󥯥롼ɤƤס

#include <string>
#include <cstdarg>
#include "tinyxml.h"



// -----
// Searching for attribute "suppress_csv". If it is found and is set to
// "true", then return true. Otherwise return false.
// ° "suppress_csv" õ⤷줬ߤĤꡤĿ˥åȤ
// ʤСtrue ֤ۤξ false ֤
// -----
bool
findSuppressCSV
( const TiXmlNode * tn_in )
{
  const TiXmlAttribute * attr = tn_in -> ToElement () -> FirstAttribute () ;
  while ( attr )
  {
    if ( string ( attr -> Name () ) != "suppress_csv" )
    {
      continue ;
    }
    string sc_val = attr -> Value () ;
    if ( sc_val == "true" || sc_val == "True" || sc_val == "TRUE" )
    {
      return true ;
    }
    else
    {
      return false ;
    }
  }
  return false ;
}


#endif /* ! ___SuppressCSV_HH */
