// -- This may look like C code, but it's really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// globvar.hh --- defining global variables
// -----
// ChangeLog:
// 2007. 11. 10
//  New global variables related to the processing of "current working
//  directories".
// 2007. 10. 15
//  New global variables for selecting XML-based input file:
//  "bool ?_xml" and "string s_file_str" in section FILES_NAMES_VARS.
// -----

#include <cmath>
#include <string>
#include <fstream>

#ifndef ___GLOBVAR_HH
#define ___GLOBVAR_HH	// Ƥ2٥󥯥롼ɤƤס

// __GLOB_MAIN_ROUTINE ޥ򤳤Υե򥤥󥯥롼ɤ
// ƤȡΥإåեϤΤޤޥᥤ롼Ѥ
// ʤäƤ褦ˤ롣ΤФᥤ롼եǤ
/***************************************************************/
// #define __GLOB_MAIN_ROUTINE
// #include "globvar.hh"
/***************************************************************/
// Ȥ롣ʳΥեǤ __GLOB_MAIN_ROUTINE  #define
// ɬפϤʤ

using std :: string ;
using std :: ofstream ;



#ifndef __EXT_DISTTRAIN_ENDED 	// ֽ֤Ͻλ
#ifdef __GLOB_MAIN_ROUTINE
bool g_sw_disttrain_ended = false;	// default value = false
#else					// disttrain() λ true
extern bool g_sw_disttrain_ended;
#endif
#define __EXT_DISTTRAIN_ENDED
#endif /* ! __EXT_DISTTRAIN_ENDED */

#ifndef __EXT_USE_STNOBJ_SSVAR		// station_obj γĥפ
#ifdef __GLOB_MAIN_ROUTINE
bool g_sw_use_stnobj_ssvar = false;	// default value = false
#else
extern bool g_sw_use_stnobj_ssvar;
#endif
#define __EXT_USE_STNOBJ_SSVAR
#endif /* ! __EXT_USE_STNOBJ_SSVAR */

#ifndef __EXT_STATION_OBJECT_VALID 	// إ֥Ȥͭ
#ifdef __GLOB_MAIN_ROUTINE
bool g_sw_station_object_valid = false;	// default value = false
#else
extern bool g_sw_station_object_valid;
#endif
#define __EXT_STATION_OBJECT_VALID
#endif /* ! __EXT_STATION_OBJECT_VALID */

#ifndef __EXT_STOP_BETWEEN_ORIENTED 	// ش߻ظο
#ifdef __GLOB_MAIN_ROUTINE
bool g_sw_stop_between_oriented = false;	// default value = false
#else
extern bool g_sw_stop_between_oriented;
#endif
#define __EXT_STOP_BETWEEN_ORIENTED
#endif /* ! __EXT_STOP_BETWEEN_ORIENTED */

#ifndef __EXT_FREERUN_CYCLE 	// ե꡼󥵥Ǥ
#ifdef __GLOB_MAIN_ROUTINE
bool g_sw_freerun_cycle = false;	// default value = false ѹ
#else					// disttrain Ǥ false Ȥ뤿
extern bool g_sw_freerun_cycle;
#endif
#define __EXT_FREERUN_CYCLE
#endif /* ! __EXT_FREERUN_CYCLE */

#ifndef __EXT_CCALRESULT 	// ϩ׻η̤ǤФݤ
#ifdef __GLOB_MAIN_ROUTINE
bool g_sw_ccalresult = false;	// default value = false
#else
extern bool g_sw_ccalresult;
#endif
#define __EXT_CCALRESULT
#endif /* ! __EXT_CCALRESULT */

#ifndef __EXT_SS_DIRECTION 	// Ž̤ήǤФ
#ifdef __GLOB_MAIN_ROUTINE
bool g_sw_ss_direction = false;		// default value = false
#else
extern bool g_sw_ss_direction;
#endif
#define __EXT_SS_DIRECTION
#endif /* ! __EXT_SS_DIRECTION */

#ifndef __EXT_ONT_PREC		// Υåհַ׻٥С
#ifdef __GLOB_MAIN_ROUTINE
bool g_sw_ont_prec = false;		// default value = false
#else
extern bool g_sw_ont_prec;
#endif
#define __EXT_ONT_PREC
#endif /* ! __EXT_ONT_PREC */

#ifndef __EXT_SPECIFY_TDEPT	// tdept  trainvar ޥɤǻ
#ifdef __GLOB_MAIN_ROUTINE
bool g_sw_specify_tdept = false;	// default value = false
#else
extern bool g_sw_specify_tdept;
#endif
#define __EXT_SPECIFY_TDEPT
#endif /* ! __EXT_SPECIFY_TDEPT */

#ifndef __EXT_KILOWATT_SUBOUT 	// Ž̤νϤ kW 
#ifdef __GLOB_MAIN_ROUTINE
bool g_sw_kilowatt_subout = false;	// default value = false
#else
extern bool g_sw_kilowatt_subout;
#endif
#define __EXT_KILOWATT_SUBOUT
#endif /* ! __EXT_KILOWATT_SUBOUT */

#ifndef __EXT_PER_CAR_OUT 	// ֽϤְʬ: ʿԥ
#ifdef __GLOB_MAIN_ROUTINE
bool g_sw_per_car_out = false;	// default value = false
#else
extern bool g_sw_per_car_out;
#endif
#define __EXT_PER_CAR_OUT
#endif /* ! __EXT_PER_CAR_OUT */

#ifndef __EXT_NOSETVIOLD 	// ͤ1ΦȤˤȤġס
#ifdef __GLOB_MAIN_ROUTINE
bool g_sw_nosetviold = false;
#else
extern bool g_sw_nosetviold;
#endif
#define __EXT_NOSETVIOLD
#endif /* ! __EXT_NOSETVIOLD */

#ifndef __EXT_MORIYA_IEN 	// ֤βΨȤ
/********************************************************************
*  g_moriya_ien_hajime, g_moriya_ien_owari  feedline ǡ *
* ˻ꤵ٤ΤʥˤäưۤʤϤ*
* ץߥ󥰤ݤʤΤǤΤޤޤˤƤ롣                *
********************************************************************/
#ifdef __GLOB_MAIN_ROUTINE
bool g_sw_moriya_ien = false;	// ȤȤ true
double g_moriya_ien_hajime;		// Ȥ֤λ¦
double g_moriya_ien_owari;		// Ȥ֤ν¦
#else
extern bool g_sw_moriya_ien;
extern double g_moriya_ien_hajime;
extern double g_moriya_ien_owari;
#endif
#define __EXT_MORIYA_IEN
#endif /* ! __EXT_MORIYA_IEN */

#ifndef __EXT_CONGES_STATION 	// ΨؤȤѹ
#ifdef __GLOB_MAIN_ROUTINE
bool g_sw_conges_station = false;	// default value = false
#else
extern bool g_sw_conges_station;
#endif
#define __EXT_CONGES_STATION
#endif /* ! __EXT_CONGES_STATION */

#ifndef __EXT_SUBSTN_CTL_A 	// Žꥢ륿 A
#ifdef __GLOB_MAIN_ROUTINE
bool g_sw_substn_ctl_a = false;	// default value = false
#else
extern bool g_sw_substn_ctl_a;
#endif
#define __EXT_SUBSTN_CTL_A
#endif /* ! __EXT_SUBSTN_CTL_A */

#ifndef __EXT_CSV_HAS_NOSHIBO 	// CSVե˲ǽή
#ifdef __GLOB_MAIN_ROUTINE
bool g_sw_csv_has_noshibo = false;	// default value = false
#else
extern bool g_sw_csv_has_noshibo ;
#endif
#define __EXT_CSV_HAS_NOSHIBO
#endif /* ! __EXT_CSV_HAS_NOSHIBO */

#ifndef __EXT_CSV_HAS_RNOTCH_FOR_CAPPER // CSVե capper rnotch 
#ifdef __GLOB_MAIN_ROUTINE
bool g_sw_csv_has_rnotch_for_capper = false;	// default value = false
#else
extern bool g_sw_csv_has_rnotch_for_capper ;
#endif
#define __EXT_CSV_HAS_RNOTCH_FOR_CAPPER
#endif /* ! __EXT_CSV_HAS_RNOTCH_FOR_CAPPER */

#ifndef __EXT_CSV_WITHOUT_QUOTATION 	// CSVեŰĤʤ
#ifdef __GLOB_MAIN_ROUTINE
bool g_sw_csv_without_quotation = false ;	// default value = false
#else
extern bool g_sw_csv_without_quotation ;
#endif
#define __EXT_CSV_WITHOUT_QUOTATION
#endif /* ! __EXT_CSV_WITHOUT_QUOTATION */

#ifndef __EXT_NFREE 	// ߥ졼󤷤β
#ifdef __GLOB_MAIN_ROUTINE
int nfree;
#else
extern int nfree;
#endif
#define __EXT_NFREE
#endif /* ! __EXT_NFREE */

#ifndef __EXT_N_SIMCYCLE 	// ߥ졼Υ
#ifdef __GLOB_MAIN_ROUTINE
int n_simcycle = 0;
#else
extern int n_simcycle;
#endif
#define __EXT_N_SIMCYCLE
#endif /* ! __EXT_N_SIMCYCLE */

#ifndef __EXT_N_INC_NFREE 	// ߥ졼Υ
#ifdef __GLOB_MAIN_ROUTINE
int n_inc_nfree = -10;
#else
extern int n_inc_nfree;
#endif
#define __EXT_N_INC_NFREE
#endif /* ! __EXT_N_INC_NFREE */

#ifndef __EXT_ONTPREC_DELAY_SET 	// ontprec åȽ٤
#ifdef __GLOB_MAIN_ROUTINE
double ontprec_delay_set = 0.6;
#else
extern double ontprec_delay_set;
#endif
#define __EXT_ONTPREC_DELAY_SET
#endif /* ! __EXT_ONTPREC_DELAY_SET */

#ifndef __EXT_STARTSTOP_PARAMETER 	// شԻʬѹ
#ifdef __GLOB_MAIN_ROUTINE
double startstop_parameter = 0.0;	// : شԻʬû
#else
extern double startstop_parameter;
#endif
#define __EXT_STARTSTOP_PARAMETER
#endif /* ! __EXT_STARTSTOP_PARAMETER */

#ifndef __EXT_T_SIM 	// ߥ졼λ
#ifdef __GLOB_MAIN_ROUTINE
double t_sim = 0 ;
double t_cyc = 0 ;
#else
extern double t_sim ;
extern double t_cyc ;
#endif
#define __EXT_T_SIM
#endif /* ! __EXT_T_SIM */

#ifndef __EXT_GLOB_HEAD 	// ܻ֡ʤҤɤåϥå
#ifdef __GLOB_MAIN_ROUTINE
double glob_head;
#else
extern double glob_head;
#endif
#define __EXT_GLOB_HEAD
#endif /* ! __EXT_GLOB_HEAD */

#ifndef __EXT_GLOB_T_SV 	// ֻʬΤߤ˴Ϳʤʬ
#ifdef __GLOB_MAIN_ROUTINE
double glob_t_sv;
#else
extern double glob_t_sv;
#endif
#define __EXT_GLOB_T_SV
#endif /* ! __EXT_GLOB_T_SV */

#ifndef __EXT_NOMINALVOLT	// ΥߥʥŰ
#ifdef __GLOB_MAIN_ROUTINE
double nominal_volt = 1500.0 ;
#else /* __GLOB_MAIN_ROUTINE */
extern double nominal_volt ;
#endif /* ! __GLOB_MAIN_ROUTINE */
#define __EXT_NOMINALVOLT
#endif /* ! __EXT_NOMINALVOLT */

// ׻Ԥ. ̣ ccal.cc ߤ衣 gc_ccalfail_failsub 
// elecchar.cc gc_ccalfail_failcar  gc_ccalfail_failctp  trteta.cc
// 򤽤줾ߤ衣
#ifndef __EXT_CCALFAIL
#ifdef __GLOB_MAIN_ROUTINE
extern const int	gc_ccalfail_failnum = 3 ;
extern const double	gc_ccalfail_faildif = 1.0 ;
extern const double	gc_ccalfail_faildiv = 1.0 ;
extern const double	gc_ccalfail_failsub = 1000.0 ;
extern const double	gc_ccalfail_failcar = 10.0 ;
extern const int	gc_ccalfail_failctp = 100 ;
extern const int	gc_ccalfail_circ    = 250 ;
extern const double	gc_ccal_termination = 0.1 ;
#else /* __GLOB_MAIN_ROUTINE */
extern const int	gc_ccalfail_failnum ;
extern const double	gc_ccalfail_faildif ;
extern const double	gc_ccalfail_faildiv ;
extern const double	gc_ccalfail_failsub ;
extern const double	gc_ccalfail_failcar ;
extern const int	gc_ccalfail_failctp ;
extern const int	gc_ccalfail_circ ;
extern const double	gc_ccal_termination ;
#endif /* ! __GLOB_MAIN_ROUTINE */
#define __EXT_CCALFAIL
#endif /* ! __EXT_CCALFAIL */

#ifndef __EXT_DELTAH	// ߥ졼߻
#ifdef __GLOB_MAIN_ROUTINE
double deltah ;
double cal_deltah ;
#else /* __GLOB_MAIN_ROUTINE */
extern double deltah ;
extern double cal_deltah ;
#endif /* ! __GLOB_MAIN_ROUTINE */
#define __EXT_DELTAH
#endif /* ! __EXT_DELTAH */

#ifndef __EXT_VLIMITMIKOMI 	// ®¤˸;͵ʬ
#ifdef __GLOB_MAIN_ROUTINE
double g_vlimitmikomi = 0.0;
#else
extern double g_vlimitmikomi;
#endif
#define __EXT_VLIMITMIKOMI
#endif /* ! __EXT_VLIMITMIKOMI */

#ifndef FILENAME_MAX
#define FILENAME_MAX 512	// ե̾ʸκĹġפˤ
#endif /* ! FILENAME_MAX */

#ifndef TMPCHSIZ
#define TMPCHSIZ 1024	// readdata ʸκĹ
#endif /* ! TMPCHSIZ */

#ifndef __EXT_TMPCH	// readdata 饹Ѥʸ¢ѿ
#ifdef __GLOB_MAIN_ROUTINE
char tmpch[TMPCHSIZ];
#else /* __GLOB_MAIN_ROUTINE */
extern char tmpch[TMPCHSIZ];
#endif /* ! __GLOB_MAIN_ROUTINE */
#define __EXT_TMPCH
#endif /* ! __EXT_TMPCH */

#ifndef __FILES_NAMES_VARS
#define __FILES_NAMES_VARS
#ifdef __GLOB_MAIN_ROUTINE
string current_directory = "" ;
string current_drive = "" ;
bool is_backslash = false ;
string g_file_str = string ( "G.xml" ) ;
string g_dir_str = string ( "" ) ;
string g_drive_str = string ( "" ) ;
char g_file[FILENAME_MAX] = "gradcurv.dat";
bool g_xml = false ;
string n_file_str = string ( "N.xml" ) ;
string n_dir_str = string ( "" ) ;
string n_drive_str = string ( "" ) ;
char n_file[FILENAME_MAX] = "nextsta.dat";
bool n_xml = false ;
string s_file_str = string ( "S.xml" ) ;
string s_dir_str = string ( "" ) ;
string s_drive_str = string ( "" ) ;
char s_file[FILENAME_MAX] = "ssdata.dat";
bool s_xml = false ;
string f_file_str = string ( "F.xml" ) ;
string f_dir_str = string ( "" ) ;
string f_drive_str = string ( "" ) ;
char f_file[FILENAME_MAX] = "feeder.dat";
bool f_xml = false ;
string p_file_str = string ( "P.xml" ) ;
string p_dir_str = string ( "" ) ;
string p_drive_str = string ( "" ) ;
char p_file[FILENAME_MAX] = "pbdata.dat";
bool p_xml = false ;
char r_file[FILENAME_MAX] = "result.dat";
bool r_xml = false ;
char l_file[FILENAME_MAX] = "result.log";
bool l_xml = false ;
ofstream l_ofs ;
char c_file[FILENAME_MAX] = "nogi.csv" ;
bool use_c_file = false ;
char h_file[FILENAME_MAX] = "headway.dat";
bool h_xml = false ;
char t_file[FILENAME_MAX] = "trdist.dat";
bool t_xml = false ;
char d_defa[FILENAME_MAX] = "";
#else /* __GLOB_MAIN_ROUTINE */
extern string current_working_directory ;
extern bool is_backslash ;
extern string g_file_str ;
extern string g_dir_str ;
extern string g_drive_str ;
extern char g_file[FILENAME_MAX];
extern bool g_xml ;
extern string n_file_str ;
extern string n_dir_str ;
extern string n_drive_str ;
extern char n_file[FILENAME_MAX];
extern bool n_xml ;
extern string s_file_str ;
extern string s_dir_str ;
extern string s_drive_str ;
extern char s_file[FILENAME_MAX];
extern bool s_xml ;
extern string f_file_str ;
extern string f_dir_str ;
extern string f_drive_str ;
extern char f_file[FILENAME_MAX];
extern bool f_xml ;
extern string p_file_str ;
extern string p_dir_str ;
extern string p_drive_str ;
extern char p_file[FILENAME_MAX];
extern bool p_xml ;
extern char r_file[FILENAME_MAX];
extern bool r_xml ;
extern char l_file[FILENAME_MAX];
extern bool l_xml ;
extern ofstream l_ofs ;
extern char c_file[FILENAME_MAX];
extern bool use_c_file ;
extern char h_file[FILENAME_MAX];
extern bool h_xml ;
extern char t_file[FILENAME_MAX];
extern bool t_xml ;
extern char d_defa[FILENAME_MAX];
#endif /* ! __GLOB_MAIN_ROUTINE */
#endif /* ! __FILES_NAMES_VARS */

#ifndef INVLIM
#define INVLIM 1e-5 			// ǤϺ־פ
#endif /* ! INVLIM */

#ifndef DINVLIM
#define DINVLIM INVLIM / 2		// INVLIM Ⱦʬ
#endif /* ! DINVLIM */

#ifndef LONGLENGTH
#define LONGLENGTH 100 			// ĹΥŬͿƤ褤
#endif /* ! LONGLENGTH */

#ifndef SEIGENYOKUSEI
#define SEIGENYOKUSEI 2			// ®¤ɸkm/h
#endif /* ! SEIGENYOKUSEI */

#ifndef GOLDENDIVISION
#define GOLDENDIVISION	( sqrt(5) - 1 ) / 2		// ʬ
#endif /* ! GOLDENDIVISION */

#ifndef PI
#define	PI	3.14159265358979323846
#endif	/* ! PI */

#ifndef EXP
#define	EXP	2.718281828
#endif	/* ! EXP */

#include "rtsscmds.hh"

#endif /* ! ___GLOBVAR_HH */
