// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// rtss_iconv.cc --- implementing iconv related functions
// -----
// ChangeLog:
// 2007. 11. 8
//  File created.
// -----


#include "rtss_iconv.hh"
#include <iostream>
#include <cstdlib>
#include <cstring>

using std :: cerr ;
using std :: endl ;
using std :: strlen ;


void
convertFromUTF8ToSJIS
( const char * pin ,
  char * pout ,
  size_t olen )
{
#ifdef SJIS_ICONV
  iconv_t cd = iconv_open ( "SHIFT_JIS" , "UTF-8" ) ;
  if ( cd == ( iconv_t ) ( - 1 ) ) {
    cerr << "ERROR: ICONV initialisation failed" << endl ;
    exit ( 1 ) ;
  }	  
  size_t ilen = strlen ( pin ) ;
  size_t rlen = iconv ( cd , & pin , & ilen , & pout , & olen ) ;
  if ( rlen == ( size_t ) ( - 1 ) ) {
    cerr << "ERROR: ICONV conversion failed" << endl ;
    exit ( 1 ) ;
  }
  * pout = '\0' ;
  iconv_close ( cd ) ;
#else
  cerr << "ERROR: Function \"convertFromUTF8ToSJIS()\" must not be used."
       << endl << " You must add \"-DSJIS_ICONV\" to activate this function."
       << endl ;
#endif // SJIS_ICONV
}
