// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// trn_pass.cc --- class train functions on nextmotion: nm_nxxps
// -----
// ChangeLog:
// 2007. 11. 22
//  Redirected log messages to l_file.
// -----

#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <iostream>
#include <sstream>
#include <iomanip>

#include "train.hh"

using std :: fixed ;
using std :: ostringstream ;
using std :: setprecision ;
using std :: setw ;



#define INVLIM 1e-5

//#define DEBUG
//#define PRATEBUG

#define DELAY_ALLOWED 	3	// Ec_auto ƹ˵٤[sec]
			// ƹΥͥ륮ֵѤˤ٥٤ɻߤΤ


// Station_pass, Pass_pass  nxx 촹
bool
train :: nm_nxxps
()
{
  // data check
  if ( nxx -> nextnxx () -> nxxptn () != Pass_pass
       && nxx -> nextnxx () -> nxxptn () != Pass_station )
  {
    l_ofs << "Error: nextsta_pattern data not correct" << endl ;
    cerr  << "Error: nextsta_pattern data not correct" << endl ;
    exit ( 13 ) ;
  }

  if ( pos * direc () >= nxx -> parrive () * direc () - DINVLIM )
  {
    // μإǡ˰ܹԤ뤷ʤ
    double tde = tdept - taudx ;	// إǡȯ٤ʬη
    taudx = t_sim - nxx -> tarrive ( true ) - tde ;
    ostringstream o_p ;
    o_p << "car " << carno << ": pos = " << fixed << setprecision ( 3 )
        << pos << ", direc " << direc () << "(" << nxx -> dptnum () << "-"
        << nxx -> dpttbl () << "), delay " << setprecision ( 2 )
        << taudx << " sec." ;
    l_ofs << o_p . str ()  << endl ;
    cerr << o_p . str ()  << endl ;
    nxx -> setpf ( taudx , pfirst ) ;		// ٤̿
    if ( fabs ( taudx ) > ontprec_delay_set )
    {
      // ٤줬礭ʤ
      if ( g_sw_freerun_cycle && ( ! nxx -> get_ontprec () )
           && n_inc_nfree != n_simcycle )
      {
        // ե꡼ ontprec ̤åȤʤ nfree 
        ++ nfree ;
        l_ofs << "nfree increased to " << nfree << endl ;
        cerr << "nfree increased to " << nfree << endl ;

        // nfree 12ٹԤʤ
        n_inc_nfree = n_simcycle ;
      }
      nxx -> set_ontprec () ;			// ontprec 򥻥å
    }

    tdept = t_sim ;	// ֻʬ¸ߤʤ
    prate = ptime / nxx -> tarrive ( true ) ;		// ϹΨ
    nxx -> prate ( prate ) ;				// ϹΨ̿
    addlen () ;					// ԵΥ
    stpos = pos = nxx -> nextnxx () -> pstart () ;	// ְֹ
    setNextstaPointer ( nxx -> nextnxx () ) ;
    pgrad = nxx -> dpgrad ( pos ) ;			// إǡ
    ptime = 0.0 ;					// ϹԻֹ
    if ( g_sw_station_object_valid )
    {
      if ( g_sw_disttrain_ended )
      {
        // to_station ǡ from_station ִ
        stnobj_now -> from_station_generate ( this ) ;
        stnobj_now -> this_train_will_depart ( this ) ;	// ̲
      }
      stnobj_now = nxx -> stnobj () ;
      if ( g_sw_disttrain_ended )
      {
        // disttrain λΤ߹Ԥ
        // to_station 򿷤 station_obj ̿,
#ifdef DEBUG
        cerr << "communicate with the new station_obj" << endl ;
#endif
        stnobj_comm () ;	// ַ׻򿷤˹Ԥ
      }
    }	// 촹

    double ontx = ontimesub ( pos , pgrad , vel , t_sim ) ;

    double x_tard = 0.0 ;	// ٤ʬδ
    if ( g_sw_station_object_valid && g_sw_disttrain_ended )
    {
      // ͭΤߥå
      // **** nxx->tarr_delay ( this ) : ̵ zero ʤΤ
      x_tard = nxx -> tarr_delay ( this ) ;	// 줬̾
      if ( g_sw_stop_between_oriented && sw_x_btws )
      {
        // ش߻ظǱش֤߰᤮Ƥʤ
        x_tard = 0.0 ;	// ٤ʤȤƥѥ
      }
    }

    if ( ontx - tdept + taudx < nxx -> tarrive ( pfirst ) + x_tard )
    {
      // ֥졼֤ؤž
      stat = Brake ;
      brakev = - 1.0 ;	// ɸ®١ontime Brake 
      rnotchold = rnotch = - 1.0 ;
      iamcoast = true ;			// ƹΰ
      iamconst = false ;
    }
    else
    {
      // ϹԾ֤ؤž
      iamcoast = false ;				// Ϲΰ
      iamconst = true ;
      cpsw = false ;					// cpsw ꥻå
      if ( vel >= nxx -> vlimit ( pgrad ) 
           && nxx -> vlimit ( pgrad ) >= INVLIM
           /* && tresist ( vel , pgrad ) < 0 */ )
      {
        // ®¤ˤ뢪®Ԥž
        stat = Const_vel ;
      }
      else
      {
        // ϹԾ֤ž
        stat = Power ;
        rnotchold = rnotch = 1.0 ;
      }
    }
    return true ;
  }
  else
  {
    return false ;
  }
}
