// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Prof. SONE's Laboratory, the Univ. of Tokyo.)
// disttrn.cc --- class feeder functions: disttrain
// $Id: disttrn.cc,v 2.4 1994/12/27 11:47:32 rt Exp $


#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <iostream>
#include <vector>

#include "kidenrt.hh"

//#define DEBUG

using std :: cerr ;
using std :: endl ;
using std :: vector ;


// ־֤ν
void
feeder :: disttr_trinit
()
{
  int cz = 0 ;		// Ǥ˽λ֤
  for ( int i = 0 ; i < ndp ; ++ i )
  {
    for ( int j = cz ; j < cz + getDPT ( i ) . car_number () ; ++ j )
    {
      getCAR ( j ) . setvar
	( getDPT ( i ) . initpos () , getDPT ( i ) . initvel () ,
	  getDPT ( i ) . carstat () , getDPT ( i ) . departuretime () ,
	  getDPT ( i ) . delaytime () , 0.0 ) ;
      getCAR ( j ) . setNextstaPointer_for_disttrain
        ( getDPT ( i ) . initnxx () ) ;
      getCAR ( j ) . setstatold ( Stn_stop ) ;
    }
    cz += getDPT ( i ) . car_number () ;	// ο֤Ϥ⤦λ
  }
}    

/*********************************************************************
 TODO: ֽ֤ꡣ 1994. Oct. 21. --- RT

 ֽ֤֤֤δֳ֤ˤʤˤ˷ˤ
 ɤΤ褦ˤͿ뤫  ʤȤ֤ʳǤϤΤ褦
 ꤬ʤϰ֤Τߤ  ֤ʳǤ
 ߥ졼󳫻ϸ̵뤹ץˤ뤫  ֤ʳ
 ꤬ǤʤΤϡ֤Ť᤮Ƥ뤳Ȥ
 狼äȤˤǤ˱֤ΤΥ֥졼򤫤ϤƤ硣
 ʳϡʴŪˤϡˤ٤OKΤϤdisttrain κ
 ʳȤǿμ갷ѹɬפ뤬ݤ
 ɤ⤦ĤϽ֤ʳǤθ褦ˤˡ
 Ϥʤݡ

 ֤ˤĤơǽʬˤƤѥ1
 ĤǽǡФ褤ѥʣǽ
 ߥ졼ȤɬʤС֤ǽϰĤΥ
 ѥˤ֤ˤĤƤƱǤ뤳Ȥݾڤ뤫顢
 ѥ󤴤Ȥ֥֥Ȥ򥳥ԡǤ롪  ֥֥
 Υԡ򤷤ä߷סɬפ롣

*********************************************************************/

// ֤ν֤
void
feeder :: disttrain
()
{
  l_ofs << "Disttrain start" << endl ;

  // ִֿ
  vector < int > tt ;

  // ֥ѥ˥
  for ( int i = 0 ; i < ndp ; ++ i )
    tt . push_back ( 0 ) ;

  // Initializing time
  t_sim = 0.0 ;

  // ξξ֤ν
  disttr_trinit () ;
  int cz ;
  bool sw_initial_data_not_printed = true ;
  while ( 1 )
  {
    cz = 0 ;

    // ַ׻Ű
    for ( int i = 0 ; i < ndp ; ++ i )
    {
      // ֤ν֤ؤã
      if ( tt [ i ] < getDPT ( i ) . car_number ()
           && t_sim >= getDPT ( i ) . wholetime ()
           * tt [ i ] / getDPT ( i ) . car_number ()
           + getDPT ( i ) . phasevalue () )
      {
        cerr << "Reached: car " << cz + tt [ i ]
             << " pos: " << getCAR ( cz + tt [ i ] ) . position ()
             << " vel: " << getCAR ( cz + tt [ i ] ) . velocity ()
             << " time: " << t_sim << endl ;
        l_ofs << "Reached: car " << cz + tt [ i ]
              << " pos: " << getCAR ( cz + tt [ i ] ) . position ()
              << " vel: " << getCAR ( cz + tt [ i ] ) . velocity ()
              << " time: " << t_sim << endl ;
        getCAR ( cz + tt [ i ] ) . zlenrun () ;
        getCAR ( cz + tt [ i ] ) . setstpos () ;
        getCAR ( cz + tt [ i ] ) . resettd ( t_sim ) ;
        ++ ( tt [ i ] ) ;
      }
      // ֤ư  
      for ( int j = cz + tt [ i ] ;
            j < cz + getDPT ( i ) . car_number () ; ++ j )
      {
#ifdef DEBUG
        cerr << "Searching: car " << j << " pos: "
             << getCAR ( j ) . position () << " vel: "
             << getCAR ( j ) . velocity () << " time: " << t_sim << endl ;
        l_ofs << "Searching: car " << j << " pos: "
              << getCAR ( j ) . position () << " vel: "
              << getCAR ( j ) . velocity () << " time: " << t_sim << endl ;
#endif
        // Get the notch rate
        getCAR ( j ) . notchrate () ;
#ifdef DEBUG
        l_ofs << "Notchrate ended" << endl ;
#endif
        // Ű
        getCAR ( j ) . teta_vi () ;
#ifdef DEBUG
        l_ofs << "Theta-vi ended" << endl ;
#endif
        runtrsub ( j ) ;
#ifdef DEBUG
        cerr << "dpt: " << i ;
        cerr << ", car: " << j << " calculation ended" << endl ;
#endif
      }
      cz += getDPT ( i ) . car_number () ;
    }

    // λȽ
    int swend = 1 ;
    for ( int i = 0 ; i < ndp ; ++ i )
    {
      swend = swend && ( tt [ i ] == getDPT ( i ) . car_number () ) ;
    }
    if ( swend ) break ;

    // λƤʤ increment t_sim
    t_sim += deltah ;
    sw_initial_data_not_printed = false ;
  }

  if ( g_sw_station_object_valid )
  {
    for ( int i = 0 ; i < ncar; ++ i )
    {
      // station_obj ̿򤫤
      getCAR ( i ) . stnobj_init () ;
    }
    for ( int i = 0 ; i < stnobj . number () ; ++ i )
    {
      stnobj [ i ] -> headway_cal_init () ;
    }
  }
  g_sw_disttrain_ended = true ;
  l_ofs << "Disttrain ended" << endl ;
}
