// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Prof. SONE's Laboratory, the Univ. of Tokyo.)
// feedline.hh --- class feedline holding feeder line data
// $Id: feedline.hh,v 2.4 1994/12/27 12:03:47 rt Exp $

#include "globvar.hh"
#include "enumerat.hh"
#include "elecchar.hh"
#include "feed_y.hh"
#include "RS_Object.hh"

#ifndef ___FEEDLINE_HH
#define ___FEEDLINE_HH		// Ƥ2٥󥯥롼ɤƤס

#ifndef NODELIM
#define NODELIM 1e-3		// ֥κǾĹ
#endif /* ! NODELIM */




// ǡ
class feedline
  : public virtual RS_Object
{
  string name_sjis ;

  int nfline ;			// ֹ
  int ssc ;			// ³ƤŽ
  int car ;			// ξ
  feedpos * css ;		// ³Žǡ
  int maxcss ;			// css κ
  feeder_shape shape ;		// η
  double feedlength ;		// Ĺ
  double frf ;			// 
  feed_y fdx ;			// feed_y ǡȺѤ
  void impcal ( int , int , feedpos * , bran_node & , feed_y & ) ;
				// branch impedance η׻
public :

  void setNameSjis ( string const & x ) { name_sjis = x ; }
  feedline () ;			// empty constructor
  ~feedline () { delete css ; }	// destructor
  feedline ( feedline const & ) ;	// X(X&) ػ
  feedline & operator= ( feedline const & ) ;	// ػ

  void renewssc ( int ) ;	// ssc, car ѹ
  void clearcar () { car = 0 ; }	// ξǡ

  // ѿΥå
  void setvar ( double l , double ff , feeder_shape x = Long )
  { feedlength = l ; frf = ff ; shape = x ; }

  void setnfline ( int i ) { nfline = i ; }	// ֹν

  double feederlength () const { return feedlength ; }
  feed_y & fdsort () { return fdx ; }
  feeder_shape feedshape () const { return shape ; }	// ѿ
  feedline & operator+= ( feedpos & ) ;	// ǡʬˤä
  feedline & operator*= ( feedpos & ) ;	// ǡŽʬˤä
  feed_y & sortx () ;	// Υȡ֥

  // Getting name string for display
  string const & getNameSjis () const { return name_sjis ; }
} ;


#endif /* ! ___FEEDLINE_HH */
