// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// stn_rf.cc --- functions for class station_obj: readfile
// -----
// ChangeLog:
// 2007. 11. 22
//  Redirected log messages to l_file.
// -----

#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <iostream>
#include <sstream>
#include <iomanip>

#include "stnobj.hh"

using std :: cerr ;
using std :: endl ;
using std :: ostringstream ;
using std :: fixed ;
using std :: setprecision ;
using std :: setw ;



//#define DEBUG



// ե꡼
int
station_obj :: readfile
( FILE * hpoint )
{

  ostringstream o_x ;

  cerr << endl ;

  commandvalue comval ;

  // å򥻥å
  bool sw_niolno = false , sw_nvoie = false , sw_stnobjtype = false ;
  bool sw_stopoutof = false ;
  readfile_additional_bool_set () ;	// ɲʬåå

  while ( ! ( sw_niolno && sw_nvoie && sw_stnobjtype && sw_stopoutof
	      && readfile_additional_bool_eval () ) )
  {
    comval = getcommandvalue ( hpoint , h_file ) ;
    switch ( comval )
    {
    case IOLINENUMBER :
      err_eof ( sw_niolno , h_file ) ;
      getint ( hpoint , h_file , niolno ) ;
      l_ofs << "Number of lines approaching the station: " << niolno << endl ;
      break ;

    case TRACKNUMBER :
      err_eof ( sw_nvoie , h_file ) ;
      getint ( hpoint , h_file , nvoie ) ;
      l_ofs << "Number of tracks in the station: " << nvoie << endl ;
      break ;

    case STATION_OBJECT_TYPE :
      err_eof ( sw_stnobjtype , h_file ) ;
      getcommand ( hpoint , h_file ) ;
      l_ofs << "station_obj type: " << tmpch << endl ;
      if ( cmpcommand ( "Doubletrack_no_cross" ) )
      {
	stnobjtype = Doubletrack_no_cross ;
      }
      else if ( cmpcommand ( "Vanishing" ) )
      {
	stnobjtype = Vanishing ;
      }
      else
	err_eof ( h_file ) ;
      break ;

    case STOP_OUT_OF_STATION :
      err_eof ( sw_stopoutof , h_file ) ;
      getdouble ( hpoint , h_file , out_of_station ) ;
      o_x . clear () ;
      o_x . str ( "" ) ;
      o_x << "Stop out of station: " << fixed << setprecision ( 3 )
          << setw ( 10 ) << out_of_station << " km" ;
      l_ofs << o_x . str () << endl ;
      break ;

    default :
      readfile_additional_readfile ( hpoint , comval ) ;
      // readfile ɲäƹԤ롼 (virtual ؿ)
      break ;
    }
  }

  // Doubletrack_no_cross Ǥ niolno = 1 ǤʤȤ
  if ( stnobjtype == Doubletrack_no_cross && niolno != 1 )
    err_eof ( h_file ) ;

  // λ
  arrv_dept_pass_table_set ( depart_arrival ) ;
  arrv_dept_pass_table_set ( arrival_depart ) ;
  arrv_dept_pass_table_set ( arrival_arrival ) ;
  arrv_dept_pass_table_set ( depart_depart ) ;
  arrv_dept_pass_table_set ( depart_pass ) ;
  arrv_dept_pass_table_set ( arrival_pass ) ;
  arrv_dept_pass_table_set ( pass_arrival ) ;
  arrv_dept_pass_table_set ( pass_depart ) ;
  arrv_dept_pass_table_set ( pass_pass ) ;

  train_departure . setnum ( nvoie ) ;

  notrwtab . setnum ( nvoie ) ;
  for ( int i = 0 ; i < nvoie ; ++ i )
  {
    notrwtab [ i ] = false ;
  }

  for ( int i = 0 ; i < niolno ; ++ i )
  {
    bool sw_dept_arrv = false , sw_arrv_dept = false ;
    bool sw_arrv_arrv = false , sw_dept_dept = false ;
    bool sw_dept_pass = false , sw_arrv_pass = false ;
    bool sw_pass_arrv = false , sw_pass_dept = false ;
    bool sw_pass_pass = false ;
    while ( ! ( sw_dept_arrv && sw_arrv_dept
		&& sw_arrv_arrv && sw_dept_dept
		&& sw_dept_pass && sw_arrv_pass
		&& sw_pass_arrv && sw_pass_dept
		&& sw_pass_pass ) )
    {
      comval = getcommandvalue ( hpoint , h_file ) ;
      switch ( comval )
      {
      case DEPART_ARRIVAL :
	err_eof ( sw_dept_arrv , h_file ) ;
	l_ofs << "depart_arrival[ " << i << " ]:" << endl ;
	rf_arrv_dept_pass_table ( hpoint , depart_arrival , i ) ;
	break ;
      case ARRIVAL_DEPART :
	err_eof ( sw_arrv_dept , h_file ) ;
	l_ofs << "arrival_depart[ " << i << " ]:" << endl ;
	rf_arrv_dept_pass_table ( hpoint , arrival_depart , i ) ;
	break ;
      case ARRIVAL_ARRIVAL :
	err_eof ( sw_arrv_arrv , h_file ) ;
	l_ofs << "arrival_arrival[ " << i << " ]:" << endl ;
	rf_arrv_dept_pass_table ( hpoint , arrival_arrival , i ) ;
	break ;
      case DEPART_DEPART :
	err_eof ( sw_dept_dept , h_file ) ;
	l_ofs << "depart_depart[ " << i << " ]:" << endl ;
	rf_arrv_dept_pass_table ( hpoint , depart_depart , i ) ;
	break ;
      case DEPART_PASS :
	err_eof ( sw_dept_pass , h_file ) ;
	l_ofs << "depart_pass[ " << i << " ]:" << endl ;
	rf_arrv_dept_pass_table ( hpoint , depart_pass , i ) ;
	break ;
      case ARRIVAL_PASS :
	err_eof ( sw_arrv_pass , h_file ) ;
	l_ofs << "arrival_pass[ " << i << " ]:" << endl ;
	rf_arrv_dept_pass_table ( hpoint , arrival_pass , i ) ;
	break ;
      case PASS_ARRIVAL :
	err_eof ( sw_pass_arrv , h_file ) ;
	l_ofs << "pass_arrival[ " << i << " ]:" << endl ;
	rf_arrv_dept_pass_table ( hpoint , pass_arrival , i ) ;
	break ;
      case PASS_DEPART :
	err_eof ( sw_pass_dept , h_file ) ;
	l_ofs << "pass_depart[ " << i << " ]:" << endl ;
	rf_arrv_dept_pass_table ( hpoint , pass_depart , i ) ;
	break ;
      case PASS_PASS :
	err_eof ( sw_pass_pass , h_file ) ;
	l_ofs << "pass_pass[ " << i << " ]:" << endl ;
	rf_arrv_dept_pass_table ( hpoint , pass_pass , i ) ;
	break ;
      default :
	err_eof ( h_file ) ;
	break ;
      }
    }
  }

  return 1 ;
}




// Ǿ֥ǡ
void
station_obj :: arrv_dept_pass_table_set
( RefTable < matrix > & adp )
{
  int dn = niolno * niolno ;
  adp . setnum ( dn ) ;
  for ( int i = 0 ; i < dn ; ++ i )
  {
    adp [ i ] . renewmn ( nvoie , nvoie ) ;
  }
}



// Ǿ֥ǡΥե꡼
void
station_obj :: rf_arrv_dept_pass_table
( FILE * hpoint ,
  RefTable < matrix > & adp ,
  int ix )
{
  ostringstream o_x ;
  for ( int i = 0 ; i < nvoie ; ++ i )
  {
    for ( int j = 0 ; j < nvoie ; ++ j )
    {
      getdouble ( hpoint , h_file , adp [ ix ] ( i , j ) ) ;
      o_x . clear () ;
      o_x . str ( "" ) ;
      o_x << "   " << fixed << setprecision ( 2 ) << setw ( 7 )
          << adp [ ix ] ( i , j ) ;
      l_ofs << o_x . str () ;
    }
    l_ofs << endl ;
  }
}
