// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Prof. SONE's Laboratory, the Univ. of Tokyo.)
// stnobj.hh --- class station_obj and related classes and structs
// $Id: stnobj.hh,v 2.4 1994/12/27 11:49:38 rt Exp $

#include "globvar.hh"
#include "readdata.hh"
#include "RefTable.hh"
#include "enumerat.hh"
#include "matrix.hh"

#ifndef ___STNOBJ_HH
#define ___STNOBJ_HH		// Ƥ2٥󥯥롼ɤƤס

class train;	// ƤʤȤޤ

// ؤ˸äƤ֤򼨤ǡ
struct to_station {
    const train* tr_ptr;	// ֥֥ȤؤΥݥ
    int ilno;	// ؤ˥ץϩֹ
    int voie;	// ٤
    int notrw;	// ؤԤġԤˤ٤֤ܿ
    int olno;	// ؤФϩֹ
    bool is_pass;	// αؤ̲
    double taudx;	// ֤ؽȯ˻äƤ٤
    double tarrive;	// 夹٤, θѤߤǤʤ
    double tarr_delay;	// 夹٤αθѤߤΤΤ
			// ǤʤΤȤκ
    double tstop;	// ͽʬ

    to_station() {
        tr_ptr = 0;
        tstop = tarr_delay = tarrive = -3600;
        ilno = olno = voie = 0;
        is_pass = false;
    }
};

// غǡ¤
struct from_station {
    const train* tr_ptr;	// ֥֥ȤؤΥݥ
    int voie;	// ֤ȯ֤
    int notrw;	// ؤԤġԤˤ٤֤ܿ
    int olno;	// ֤ؤФϩֹ
    double tarrive;	// ֤夷
    bool is_pass;	// ̲֤Ǥץե饰
    bool is_at_station;	// ָ߱ؤˤޤץե饰
    bool do_not_depart;	// ֽȯƤϤʤץե饰
    double tdept;	// ȯ֤٤, ͽ
    double tdept_delay;	// ȯ֤, ͤͽۤȤκ
    double taudx;	// ֤ؽȯ˻äƤ٤

    from_station() {
        tr_ptr = 0;
        tdept = tdept_delay = tarrive = -3600;
        voie = 0;
        is_pass = is_at_station = false;
        do_not_depart = true;
    }
};

// 塦ȯֳݾڤŪȤإ֥ȥ饹
class station_obj
: public NoRefTable<to_station>, public readdata {

  private:
    // ƥȤ򤹤 public ꤹȤ褤

    bool first_headcal_ended;	// ǽ headway_cal ä true

    int stnno;			// αؤαֹ
    int niolno;			// ؤ˥ץϩο
    int nvoie;				// αؤˤϩ
    station_obj_type stnobjtype;	// 
    double out_of_station;	// شֻ߰
//     const station_obj* nextstnobj;	// ٤ station_obj

    // Ǿ֥ǡ
    RefTable<matrix> depart_arrival;	// ȯָ弡ޤ
    RefTable<matrix> arrival_depart;	// 弡ȯ֤ޤ
    RefTable<matrix> arrival_arrival;	// 弡ޤ
    RefTable<matrix> depart_depart;		// ȯָ弡ȯ֤ޤ
    RefTable<matrix> depart_pass;		// ȯָ弡̲ޤ
    RefTable<matrix> arrival_pass;		// 弡̲ޤ
    RefTable<matrix> pass_arrival;		// ̲弡ޤ
    RefTable<matrix> pass_depart;		// ̲弡ȯ֤ޤ
    RefTable<matrix> pass_pass;		// ̲弡̲ޤ

    RefTable<from_station> warp_queue;	// ĥդԤ

    RefTable<bool> notrwtab;	// notrw [i]ż֤ true

  protected:
    RefTable<from_station> train_departure;	// ֤ȯ֥ǡ

    void error26_name() {
	fprintf(stderr, "Error: subscript out of range in\n");
	fprintf(stderr, "       station_obj object to_station data call\n");
    }

    void arrv_dept_pass_table_set(RefTable<matrix>&);

    void rf_arrv_dept_pass_table(FILE*, RefTable<matrix>&, int);

  protected:

    void membercopy(const station_obj&);	// Хԡ

    // ֽȯδط
    void this_train_will_depart_aaa(const train*) const;
    void this_train_will_depart_baa(const train*) const;

    // ĥ饹Τ readfile 桼ƥƥ
    virtual void readfile_additional_readfile(FILE* h, commandvalue x)
        {err_eof(h_file);}	// ĥʤ硢δؿƤФȰ۾
    virtual void readfile_additional_bool_set() {return;}
    virtual bool readfile_additional_bool_eval() {return true;}

    // ֻʬե饯奨Τε
    virtual void stationstop_variation_func
    (from_station& x, int i) {return;}
    
  public:

    station_obj();	// constructor
			// destructor ʤ
    station_obj(const station_obj& x)
    : NoRefTable<to_station>(x) {}		// constructor: X(X&)
    station_obj& operator=(const station_obj&);	// 黻

    int which_in_train_departure
    (const train*) const;	// train_departure θ
  int which_in_to_station ( train const * ) const ;	// to_station θ

    double outofstn_pos() const {return out_of_station;}
				// out_of_station ֤

    void remove(int);		// to_station κ

    int readfile(FILE*);	// ե꡼
    
    void set_stnno(int i) {stnno = i;}		// ֹ楻å
    int get_stnno() const {return stnno;}	// ֹ

    void from_station_init(const from_station) const;
				// ֽλ from_station 
    void to_station_init(to_station) const;
				// ֽλ to_station 

    bool voie_occupied(const train*) const;
		// to_station ֤夹٤: true

    void headway_cal_init();	// ַ׻, ֽλ
    void headway_cal();		// ַ׻

    bool do_not_depart(const train*) const;	// do_not_depart ֤

    virtual double tdept_delay(const train*) const;	// tdept_deley ֤
  virtual double tarr_delay ( train const * ) const ;	// tarr_deley ֤

    virtual void this_train_will_depart(const train*) const;	// ֽȯ

    void from_station_generate(const train*) const;
	// to_station ǡ from_station ǡ֤
    void from_station_warp(from_station) const;
	// from_station ǡȤꥻå
};

#endif /* ! ___STNOBJ_HH */
