// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// trn_powr.cc --- class train functions on nextmotion: nm_power
// -----
// ChangeLog:
// 2007. 11. 22
//  Redirected log messages to l_file.
// -----

#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <iostream>

#include "train.hh"

#define INVLIM 1e-5

// Ϲμֱ黻
void
train :: nm_power
( double tracff )
{

  // ----
  // NOTE: 2010. 1. 20 -- emrn no longer used.
  // ----
  // tracff *= emrn ;	// added 04 Jun 92
  //                    // ȯɻߥ르ꥺΤ

  iamcoast = false ;
  iamconst = true ;
  enableMechanicalPowerCalculation () ;
  npos ( tracff ) ;
  disableMechanicalPowerCalculation () ;

  // ----
  // Accumulating acceleration time.
  // ϹԻ֤ѻ.
  // ----
  ptime += deltah ;

  if ( g_sw_station_object_valid && g_sw_disttrain_ended )
  {
    if ( pos * direc()
         >= nxx -> parrive () * direc () - nxx -> out_of_station () )
    {
      // ش֤߰᤮ǧ
      sw_x_btws = false ;
    }

  }

  double bkl_drx = bklen () * direc () ;

  if ( bkl_drx >= nxx -> parrive () * direc () )
  {
    // ե֥졼ξʱش߻ظ

    stat = Brake ;
    brakev = nxx -> varrive () ;
    sw_btws = false ;		// شߤΤΥ֥졼ǤϤʤ
    sw_x_btws = false ;		// ش֤߰᤮ǧ
    rnotchold = rnotch = - 1.0 ;
    return ;			// off-brake
  }

  if ( g_sw_station_object_valid && g_sw_disttrain_ended )
  {
    // ͭΤߥå
    bkl_drx = bklen ( 0.0 ) * direc () ;

    if ( bkl_drx >= nxx -> parrive () * direc () - nxx -> out_of_station ()
         // && g_sw_stop_between_oriented
         && nxx -> stnobj () -> voie_occupied ( this ) )
    {
      // ե֥졼ξ: out_of_station ΰ֤ޤǤ
      // **** ش߻ظξ礫ı̤̤
      // **** out_of_station ΰ֤ޤǤ®0ˤʤʤ
      stat = Brake ;
      brakev = 0.0 ;	// ɸ®: 
      sw_btws = true ;	// شߤΤΥ֥졼ʤΤ true
      rnotchold = rnotch = - 1.0 ;

      return ;
    }
  }

  if ( vlimitbrake () )
  {
    // ®¤ˤ brake
    return ;
  }

  // ͽۻ
  double ontx = ontimesub ( pos , pgrad , vel , t_sim ) ;

  double x_tard = 0.0 ;	// ٤ʬδ
  if ( g_sw_station_object_valid && g_sw_disttrain_ended )
  {
    // ͭΤߥå
    // **** nxx->tarr_delay( this ) : ̵ zero ʤΤ
    x_tard = nxx -> tarr_delay ( this ) ;	// 줬̾
    if ( g_sw_stop_between_oriented && sw_x_btws )
    {
      // ش߻ظǱش֤߰᤮Ƥʤ
      x_tard = 0.0 ;	// ٤ʤȤƥѥ
    }
  }

  if ( ontx - tdept + taudx <= nxx -> tarrive ( pfirst ) + x_tard )
  {
    // شԻʬξˤ
    // *** Coast ޤ Const_vel 
    iamconst = false ;
    iamcoast = true ;	// ϹԾֽλ
    ++ pfirst ;

    // شԻʬξˤܡĤŤ
    // **** ξ֤
    sw_btws = false ;	// شߤΤΥ֥졼ǤϤʤ
    if ( tresist ( vel, pgrad ) > 0
         || ( vel < nxx -> vlimit ( pgrad )
              || nxx -> vlimit ( pgrad ) < INVLIM ) )
    {
      // ®٤ˤʤ
      //  -> Coast ֤
      // **** ®٤®٤㤤
      // **** ®٤®ٰʾƹԻ®٤
      stat = Coast ;
      rnotchold = rnotch = 0.0 ;
      return ;					// ontime ž
    }
    else
    {
      // ®٤ˤҤä륱
      //  -> Const_vel ֤
      // **** ®٤®ٰʾƹԻ®٤ʤ
      stat = Const_vel ;
      return ;
    }
  }

  if ( nm_stnobj_brake () )
  {
    // 渽Ѳˤ֥졼򤫤٤
    return ;
  }

  if ( vel >= nxx -> vlimit ( pgrad )
       && nxx -> vlimit ( pgrad ) >= INVLIM )
  {
    // ®٤ˤҤä -> ϹԾ֤λʤޤ®Ԥ
    //  -> Const_vel ֤
    // **** ®٤®ٰʾƹԻ®٤ʤ
    // **** ϹԾ֤Τޤ
    iamcoast = false ;
    iamconst = true ;
    stat = Const_vel ;
  }
  return ;
}
