// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// trn_stno.cc --- class train functions on nextmotion: nm_stnobj
// -----
// ChangeLog:
// 2007. 11. 22
//  Redirected log messages to l_file.
// -----

#include <cstdio>
#include <cstdlib>
#include <cmath>

#include "matrix.hh"
#include "train.hh"

#define INVLIM 1e-5




// ֱ黻: station_obj ̿ˤäѹ
// *** Ϲԡƹԡ®Ի΢֥졼
bool
train :: nm_stnobj_brake
()
{
  if ( g_sw_station_object_valid && g_sw_disttrain_ended )
  {
    // ͭΤߥå

    double ontx = ontimesub ( pos , pgrad , vel , t_sim ) ;

    double x_tard = nxx -> tarr_delay ( this ) ;
    if ( g_sw_stop_between_oriented && sw_x_btws )
    {
      // ش߻ظǱش֤߰᤮Ƥʤ
      x_tard = 0.0 ;	// ٤ʤȤƥѥ
    }

    if ( ontx - tdept + taudx
         < nxx -> tarrive ( pfirst ) + x_tard - deltah * 2.0 )
    {
      // ֤ -> ֥졼
      stat = Brake ;
      brakev = - 1.0 ;	// ɸ®١ontime Brake 
      rnotchold = rnotch = - 1.0 ;
      iamcoast = true ;			// ƹΰ
      iamconst = false ;
      return true ;
    }
  }
  return false ;
}



// ֱ黻: station_obj ̿ˤäѹ
// *** ƹԡ®ԡ֥졼΢®
bool
train :: nm_stnobj_power
()
{
  if ( g_sw_station_object_valid && g_sw_disttrain_ended )
  {
    // ͭΤߥå

    double ontx = ontimesub ( pos , pgrad , vel , t_sim ) ;

    double x_tard = nxx -> tarr_delay ( this ) ;
    if ( g_sw_stop_between_oriented && sw_x_btws )
    {
      // ش߻ظǱش֤߰᤮Ƥʤ
      x_tard = 0.0 ;	// ٤ʤȤƥѥ
    }

    if ( ontx - tdept + taudx
         >= nxx -> tarrive ( pfirst ) + x_tard + deltah * 2.0 )
    {
      // ֤٤Ƥ -> ϹԤ
      // pfirst ϤΥ롼ǤϤʤ
      iamconst = true ;
      iamcoast = false ;	// Ϲΰ
      cpsw = false ;		// cpsw ꥻå
      if ( vel >= nxx -> vlimit ( pgrad ) && nxx -> vlimit ( pgrad ) >= INVLIM
           && tresist ( vel , pgrad ) < 0 )
      {
        
        train_ParamFunc *__pf = getNewParamFuncCalculator () ;
        __pf -> prepareMaximumEffort () ;
        double tfp = __pf -> getMaxTractiveEffort () ;
        delete __pf ;
        // ----
        // 2010. 1. 19 NOTE --- tracf(vel,v,-1) returns maximum regenerative
        // effort. tracf(vel,v,-1)>=tresist(vel,pgrad) would mean that (1)
        // both regenerative effort and the train resistance (sum of running
        // resistance and gradient resistance) are negative, and
        // (2) fabs(tracf(vel,v,-1))<=fabs(tresist(vel,pgrad)), i.e. the
        // train cannot maintain speed at the down gradient. Probably tracf
        // (vel,v,-1) is a bug and should be tracf(vel,v,1). Hence use tfp.
        // ----
//         if ( tracf ( vel , v , -1.0 ) >= tresist ( vel , pgrad ) )
        if ( tfp >= tresist ( vel , pgrad ) )
        {
          // Ϥ®ԤݻǤ
          stat = Const_vel ;
        }
        else
        {
          // Ϥ®ԤݻǤۤɳݤǤʤ
          stat = Power ;
          rnotchold = rnotch = 1.0 ;
        }
      }
      else
      {
        stat = Power ;			// ϹԾ֤ž
        rnotchold = rnotch = 1.0 ;
      }
      return true ;
    }
  }
  return false ;
}
