// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Prof. SONE's Laboratory, the Univ. of Tokyo.)
// trstncom.cc --- communication between classes train & station_obj
// $Id: trstncom.cc,v 2.4 1994/12/27 11:49:38 rt Exp $

#include <cstdio>
#include <cstdlib>
#include <cmath>

#include "train.hh"

#define INVLIM 1e-5

//#define DEBUG
//#define CVPRINT	// V1, V2 ͤǤФ

#define NO_JERK

#define MINCL	10.0
#define REGEN_OFF_TETA	5.0

// station_obj Ϳ to_station ν
to_station train::to_station_emit
() {
    to_station push_val;
    push_val.tr_ptr = this;		// ֤ؤΥݥ
    push_val.voie = nxx->voienum();	// ٤
    push_val.ilno = nxx->ilinenum();	// ؤ˥ץϩֹ
    push_val.olno = nxx->olinenum();	// ؤФϩֹ
    push_val.notrw = nxx->trwaitnum();	// ؤԤĤ٤ֿ
    push_val.is_pass = nxx->pass_stn();	// ̲֤Ǥ뤫ɤ
    push_val.taudx = taudx;		// ֤ؽȯ˻äƤ٤
    push_val.tarrive = tdept - taudx
        + nxx->tarrive( pfirst );	// ֤׻
    push_val.tarr_delay = 0.0;		// Ȥꤢ
    push_val.tstop = nxx->stoptime();	// ֤֡׻ʬ
    return push_val;
}

// station_obj Ϳ from_station ν
from_station train::from_station_emit
() {
    from_station push_val;
    push_val.tr_ptr = this;		// ֤ؤΥݥ
    push_val.voie = nxx->voienum();	// ٤
    push_val.olno = nxx->olinenum();	// ؤФϩֹ
    push_val.notrw = nxx->trwaitnum();	// ؤԤĤ٤ֿ(Ȥꤢ)
    push_val.is_pass = nxx->pass_stn();	// ̲֤Ǥ뤫ɤ
    push_val.is_at_station = true;	// ȤꤢǤ
    push_val.do_not_depart = false;	// Ȥꤢ
    push_val.tarrive = tarr_real;	// 
    push_val.taudx = taudx;		// ֤ؽȯ˻äƤ٤
    push_val.tdept = tdept;		// tdept Ϸ׻ƤȤ
    push_val.tdept_delay = 0.0;		// Ȥꤢ
    return push_val;
}

void train::stnobj_init
() {
    if ( carstat() == Stn_stop ) {
        push_from_station_init( from_station_emit() );
    } else {
        push_to_station_init( to_station_emit() );	// ַ׻ʤ
    }
}



// station_obj  to_station Ϳ
void
train :: stnobj_comm
() {
  // nxx->push_to_station( to_station_emit() );		// ַ׻
  if ( g_sw_station_object_valid )
  {
    station_obj * _stnobj = nxx -> stnobj () ;
    to_station emitted = to_station_emit () ;
#ifdef DEBUG
    cerr << "train::stnobj_comm(): pushing emitted, Car No. " ;
    cerr << emitted . tr_ptr -> car_number () << ", stnobj.get_stnno (): " ;
    cerr << _stnobj -> get_stnno () << endl ;
#endif
    ( * _stnobj ) += emitted ;
#ifdef DEBUG
    cerr << "train::stnobj_comm(): pushed emitted, Car No. " ;
    cerr << ( * _stnobj ) [ _stnobj -> number () - 1 ] . tr_ptr
      -> car_number () ;
    cerr << ", stnobj.get_stnno (): " ;
    cerr << _stnobj -> get_stnno () << endl ;
#endif
    _stnobj -> headway_cal () ;
  }
}



// to_station ֥Ȥ station_obj ˤ
// ʤΤǻַ׻ƱˤϹԤʤ
void train::push_to_station_init
( to_station emitted ) {
    if ( g_sw_station_object_valid ) {
#ifdef DEBUG
        cerr << "push_to_station_init: pushing emitted, Car No. ";
        cerr << emitted.tr_ptr->car_number() << ", stnobj.get_stnno(): ";
        cerr << x_stnobj->get_stnno() << "\n";
#endif
        stnobj_now->to_station_init( emitted );
#ifdef DEBUG
        cerr << "push_to_station_init: pushed emitted, Car No. ";
        cerr << ( *x_stnobj )[x_stnobj->number() - 1].tr_ptr->car_number();
        cerr << ", stnobj.get_stnno(): ";
        cerr << x_stnobj->get_stnno() << "\n";
#endif
    }
}

// from_station ֥Ȥ station_obj ˤ
// ʤΤǻַ׻ƱˤϹԤʤ
void train::push_from_station_init
( from_station emitted ) {
    if ( g_sw_station_object_valid ) {
#ifdef DEBUG
        cerr << "push_from_station_init: pushing emitted, Car No. ";
        cerr << emitted.tr_ptr->car_number() << ", stnobj.get_stnno(): ";
        cerr << x_stnobj->get_stnno() << "\n";
#endif
        stnobj_now->from_station_init( emitted );
#ifdef DEBUG
        cerr << "push_from_station_init: pushed emitted, Car No. ";
        cerr << x_stnobj->train_departure[0].tr_ptr->car_number();
        cerr << ", stnobj.get_stnno(): ";
        cerr << x_stnobj->get_stnno() << "\n";
#endif
    }
}
