// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// Expandable.hh --- template classes SimpleExpandable & Expandable
// -----
// ChangeLog:
// 2007. 11. 19
//  Merged into the source of RTSS.
// 2004. 6. 5
//  Original date on the file --- OOMTS of Birmingham University
// -----

// -----
// Remark:
//  This file makes it easy to expand the program at a later date.
// Classes, structs and typedefs:
//  template <PP> class SimpleExpandable
//  template <PP, CA> class Expandable
// -----

#ifndef Expandable_HH
#define Expandable_HH

#include <cstdlib>
#include <string>
#include <vector>
#include <iostream>

using std :: vector ;
using std :: string ;
using std :: cerr ;
using std :: endl ;

/******************************************************************
 * class SimpleExpandable
 ******************************************************************/

template < typename PP >
class SimpleExpandable
{

public :

  // Various classes needed
  class ObjectCreator
  {
  public :
    virtual PP * create () const = 0 ;
    void add_to_creators_list ( char const * ) ;
  } ;

  friend class ObjectCreator ;


  struct ObjectCreatorEntry
  {
    ObjectCreatorEntry
    ( ObjectCreator const * , char const * ) ;
    ObjectCreator const * creator ;
    string object_type ;
  } ;

  class ObjectCreatorsList
    : public vector < ObjectCreatorEntry >
    {
    public:
      ObjectCreatorsList ()
	: vector < ObjectCreatorEntry > () {}
    } ;

private :

  static ObjectCreatorsList * & object_creators () ;

  // Add another object creator
  static void add_object_creator ( ObjectCreatorEntry const & ) ;

public :

  // Constructor
  SimpleExpandable () {} ;

  // Create object of type PP, return pointer
  static PP * create ( char const * ) ;
  static PP * create ( string const & ) ;
} ;


/******************************************************************
 * class Expandable
 ******************************************************************/

template < typename PP , typename CA >
class Expandable
{

public :

  // Various classes needed
  class ObjectCreator
  {
  public :
    virtual PP * create () const = 0 ;
    virtual PP * create ( CA const & ) const = 0 ;
    void add_to_creators_list ( char const * ) ;
  } ;

  friend class ObjectCreator ;


  struct ObjectCreatorEntry
  {
    ObjectCreatorEntry
    ( ObjectCreator const * , char const * ) ;
    ObjectCreator const * creator ;
    string object_type ;
  } ;

  class ObjectCreatorsList
    : public vector < ObjectCreatorEntry >
    {
    public :
      ObjectCreatorsList ()
	: vector < ObjectCreatorEntry > () {}
    } ;

private :

  static ObjectCreatorsList * & object_creators () ;

  // Add another object creator
  static void add_object_creator ( ObjectCreatorEntry const & ) ;

public :

  // Constructor
  Expandable () {} ;

  // Create object of type PP, return pointer
  static PP * create ( char const * ) ;
  static PP * create ( string const & ) ;
  static PP * create ( char const * , CA const & ) ;
  static PP * create ( string const & , CA const & ) ;
} ;


/******************************************************************
 *  Function definitions
 ******************************************************************/

template < typename PP >
typename SimpleExpandable < PP > :: ObjectCreatorsList * &
SimpleExpandable < PP > :: object_creators ()
{
  static typename SimpleExpandable < PP > :: ObjectCreatorsList *
    x = new typename SimpleExpandable < PP > :: ObjectCreatorsList ;
  return x ;
}



template < typename PP , typename CA >
typename Expandable < PP , CA > :: ObjectCreatorsList * &
Expandable < PP , CA > :: object_creators ()
{
  static typename Expandable < PP , CA > :: ObjectCreatorsList *
    x = new typename Expandable < PP , CA > :: ObjectCreatorsList ;
  return x ;
}



template < typename PP >
SimpleExpandable < PP > :: ObjectCreatorEntry :: ObjectCreatorEntry
( typename SimpleExpandable < PP > :: ObjectCreator const * creator_in ,
  char const * object_type_in )
{
  creator = creator_in ;
  object_type = object_type_in ;
}



template < typename PP , typename CA >
Expandable < PP , CA > :: ObjectCreatorEntry :: ObjectCreatorEntry
( typename Expandable < PP , CA > :: ObjectCreator const * creator_in ,
  char const * object_type_in )
{
  creator = creator_in ;
  object_type = object_type_in ;
}



template < typename PP >
PP *
SimpleExpandable < PP > :: create
( string const & object_type_in )
{
  ObjectCreatorsList * creators
    = SimpleExpandable < PP > :: object_creators () ;
  for ( typename ObjectCreatorsList :: const_iterator
          ii = creators -> begin () ; ii != creators -> end () ; ++ ii )
  {
    string const & s_i = ii -> object_type ;
    if ( s_i == object_type_in
	 && s_i . length () == object_type_in . length () )
      return ii -> creator -> create () ;
  }
  // ### We should consider throwing an error.
  cerr << "Error: Creator for \"" << object_type_in << "\" not found."
       << endl ;
  exit ( 1 ) ;
  return 0 ;
}



template < typename PP , typename CA >
PP *
Expandable < PP , CA > :: create
( string const & object_type_in ,
  CA const & ca_in )
{
  ObjectCreatorsList * creators
    = Expandable < PP , CA > :: object_creators () ;
  for ( typename ObjectCreatorsList :: const_iterator
          ii = creators -> begin () ; ii != creators -> end () ; ++ ii )
  {
    string const & s_i = ii -> object_type ;
    if ( s_i == object_type_in
	 && s_i . length () == object_type_in . length () )
      return ii -> creator -> create ( ca_in ) ;
  }
  // ### We should consider throwing an error.
  cerr << "Error: Creator for \"" << object_type_in << "\" not found."
       << endl ;
  exit ( 1 ) ;
  return 0 ;
}



template < typename PP , typename CA >
PP *
Expandable < PP , CA > :: create
( string const & object_type_in )
{
  ObjectCreatorsList * creators
    = Expandable < PP , CA > :: object_creators () ;
  for ( typename ObjectCreatorsList :: const_iterator
          ii = creators -> begin () ; ii != creators -> end () ; ++ ii )
  {
    string const & s_i = ii -> object_type ;
    if ( s_i == object_type_in
	 && s_i . length () == object_type_in . length () )
      return ii -> creator -> create () ;
  }
  // ### We should consider throwing an error.
  cerr << "Error: Creator for \"" << object_type_in << "\" not found."
       << endl ;
  exit ( 1 ) ;
  return 0 ;
}



template < typename PP >
PP *
SimpleExpandable < PP > :: create
( char const * object_type_in )
{
  return create ( string ( object_type_in ) ) ;
}



template < typename PP , typename CA >
PP *
Expandable < PP , CA > :: create
( char const * object_type_in ,
  CA const & ca_in )
{
  return create ( string ( object_type_in ) , ca_in ) ;
}



template < typename PP , typename CA >
PP *
Expandable < PP , CA > :: create
( char const * object_type_in )
{
  return create ( string ( object_type_in ) ) ;
}



template < typename PP >
void
SimpleExpandable < PP > :: add_object_creator
( typename SimpleExpandable < PP > :: ObjectCreatorEntry const &
  object_creator_in )
{
  ObjectCreatorsList * creators
    = SimpleExpandable < PP > :: object_creators () ;
  creators -> push_back ( object_creator_in ) ;
}



template < typename PP , typename CA >
void
Expandable < PP , CA > :: add_object_creator
( typename Expandable < PP , CA > :: ObjectCreatorEntry const &
  object_creator_in )
{
  ObjectCreatorsList * creators
    = Expandable < PP , CA > :: object_creators () ;
  creators -> push_back ( object_creator_in ) ;
}



template < typename PP >
void
SimpleExpandable < PP > :: ObjectCreator :: add_to_creators_list
( char const * object_type_in )
{
  SimpleExpandable < PP > :: add_object_creator
    ( ObjectCreatorEntry ( this , object_type_in ) ) ;
}


template < typename PP , typename CA >
void
Expandable < PP , CA > :: ObjectCreator :: add_to_creators_list
( char const * object_type_in )
{
  Expandable < PP , CA > :: add_object_creator
    ( ObjectCreatorEntry ( this , object_type_in ) ) ;
}

#endif	// Expandable_HH
