// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// simulate.cc --- simulation routine
// -----
// ChangeLog:
// 2008. 1. 18
//  Cleared up the CSV file write routine in the feeder::simccalresult()
//  member function.
// 2007. 11. 21
//  Redirected log messages to l_file.
// -----


#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <iostream>
#include <fstream>
#include <sstream>
#include <iomanip>

#include "kidenrt.hh"

using std :: cerr ;
using std :: endl ;
using std :: ofstream ;
using std :: ostringstream ;
using std :: fixed ;
using std :: setprecision ;
using std :: setw ;



FILE * estimss ;

//#define DEBUG

#define TPANVPSEP 50    // ѥŰ histogram  TPANVPSEP  
#define TPANVPLOW 900   // TPANVPLOW  
#define TPANVPHIGH 1800 // TPANVPHIGH  ޤǷ׻
const int TPANVPSTEP = ( TPANVPHIGH - TPANVPLOW ) / TPANVPSEP + 2 ;
                        // step: 10ʾ夢뤳Ȥ˾ޤ

double tpanvp [ TPANVPSTEP ] ;    // ϹԼ֥ѥŰҥȥ
double tpanvpeak ;           // ϹԼ֥ѥŰԡ
double tpanvbottom ;         // ϹԼ֥ѥŰܥȥ
double tpanvmean = 0.0 ;     // ϹԼ֥ѥŰʿ
double tpanvmv ;
double tpanvmvt ;
bool sw_tpanvpbset ;         // ϹԼ֥ѥŰԡܥȥॻåȺѤ

double tregendead = 0.0 ;    // 

#define TSSCSEP 500     // Žή histogram  TSSCSEP  
#define TSSCLOW -5000   // TSSCLOW - TSSCSEP 
#define TSSCHIGH 16000  // TSSCHIGH  ޤǷ׻
const int TSSCSTEP = ( TSSCHIGH - TSSCLOW ) / TSSCSEP + 2 ;
                        // step: 10ʾ夢뤳Ȥ˾ޤ
double tssc [ TSSCSTEP ] ;                // ŽήΥҥȥ

#define GRTSSCSEP 500   // ײή histogram  GRTSSCSEP  
#define GRTSSCLOW -15000    // GRTSSCLOW - GRTSSCSEP 
#define GRTSSCHIGH 0    // GRTSSCHIGH  ޤǷ׻
const int GRTSSCSTEP = ( GRTSSCHIGH - GRTSSCLOW ) / GRTSSCSEP + 2 ;
                        // step: 10ʾ夢뤳Ȥ˾ޤ
double grtssc [ GRTSSCSTEP ] ;            // Žײή histogram

double rpower [ 2 ] , rpsupp [ 2 ] ;     // ϩ, ǽ
double rtpower [ 2 ] , ptpower [ 2 ] ;   // ϡϹ
double ppower [ 2 ] , spower [ 2 ] ;     // ϩϹ, Ž
double srpower [ 2 ] ;                   // Ž
double mpower [ 2 ] ;                    // ξΥѥưؼ
double mbpower [ 2 ] ;                   // ξΥ֥졼ѥưؼ
double mepower [ 2 ] ;                   // mpower Τŵʬ
double mbepower [ 2 ] ;                  // mbpower Τŵʬ
double renrgy = 0.0 ;                    // ϩͥ륮
double resupp = 0.0 ;                    // ǽͥ륮
double penrgy = 0.0 ;                    // ϩϹԥͥ륮
double rtenrgy = 0.0 ;                   // ͥ륮
double ptenrgy = 0.0 ;                   // Ϲԥͥ륮
double senrgy = 0.0 ;                    // Žϥͥ륮
double srenrgy = 0.0 ;                   // Žͥ륮
double menrgy = 0.0 ;                    // ξΥͥ륮ưؼ
double meenrgy = 0.0 ;                   // menrgy ŵʬ
double mbenrgy = 0.0 ;                   // ξΥ֥졼ͥ륮ưؼ
double mbeenrgy = 0.0 ;                  // mbenrgy ŵʬ
double * sqc1 , * nsqc1 , * psqc1 ;      // ήΣ(+/-, -, +)
double * sqc2 , * nsqc2 , * psqc2 ;      // ήΣ(+/-, -, +)
double * rmsc , * nrmsc , * prmsc ;      // ңͣή(+/-, -, +)
double ptime = 0.0 ;                     // ϹԻ
double xptime = 0.0 ;                    // Ϲԡ׾֤Ǥ
double ddhh = 0.0 ;                      // ʬ֡ǽ 0.0

void prhistog ( double , int , int , int , double * , ofstream & ) ;

// Initialization routine (non-member function)
void
shokika
( int nss )
{

  // Initialising substation current histogram
  for ( int i = 0 ; i < TSSCSTEP ; ++ i )
    tssc [ i ] = 0.0 ;

  // Initialising substation total regen current histogram
  for ( int i = 0 ; i < GRTSSCSTEP ; ++ i )
    grtssc [ i ] = 0.0 ;

  // Initialising pantograph voltage histogram of accelerating trains
  for ( int i = 0 ; i < TPANVPSTEP ; ++ i )
    tpanvp [ i ] = 0.0 ;

  // Regenerated main circuit power, "regeneratable" power
  rpower [ 0 ] = rpsupp [ 0 ] = 0.0 ;

  // Main circuit accelerating power consumption, substation input power
  ppower [ 0 ] = spower [ 0 ] = 0.0 ;

  // Regenerating power, accelerating power
  rtpower [ 0 ] = ptpower [ 0 ] = 0.0 ;

  // Substation regen power, train pantograph voltage
  srpower [ 0 ] = tpanvmv = 0.0 ;

  // Power at wheel rim
  mpower [ 0 ] = 0.0 ;
  mepower [ 0 ] = 0.0 ;

  // Brake power at wheel rim
  mbpower [ 0 ] = 0.0 ;
  mbepower [ 0 ] = 0.0 ;

  // Square of currents
  sqc1 = new double [ nss ] ;
  sqc2 = new double [ nss ] ;

  // RMS currents
  rmsc = new double [ nss ] ;

  // Square of negative currents
  nsqc1 = new double [ nss ] ;
  nsqc2 = new double [ nss ] ;

  // RMS negative currents
  nrmsc = new double [ nss ] ;

  // Square of positive currents
  psqc1 = new double [ nss ] ;
  psqc2 = new double [ nss ] ;

  // RMS positive currents
  prmsc = new double [ nss ] ;

  for ( int i = 0 ; i < nss ; ++ i )
  {
    rmsc [ i ] = sqc1 [ i ] = sqc2 [ i ] = 0.0 ;
    nrmsc [ i ] = nsqc1 [ i ] = nsqc2 [ i ] = 0.0 ;
    prmsc [ i ] = psqc1 [ i ] = psqc2 [ i ] = 0.0 ;
  }

  sw_tpanvpbset = false ;
}


// Substitution function (non-member)
void
irekae
( double & a , double & b )
{
  a = b ;
  b = 0.0 ;
}


void sepstep
 ( double clval ,
   int lw ,
   int sep ,
   int stp ,
   double * x )
{
  double fld = clval - double ( lw ) + double ( sep ) ;
  int n = ( int ) floor ( fld / sep ) ;
  if ( n < 0 )
  {
    n = 0 ;
  }
  if ( n > stp - 1 )
  {
    n = stp - 1 ;
  }
#ifdef DEBUG_X
  l_ofs << "sepstep, n, step = " << n << " " << stp << endl ;
#endif
  x [ n ] += ddhh ;
}


// Subroutine around the circuit analysis
void
feeder :: simccsub
( int & cctt )
{
#ifdef DEBUG_X
  l_ofs << "before ccal..." << endl ;
#endif

  // Calculate Y-matrix
  ycal () ;

#ifdef DEBUG_X
  l_ofs << "before ycal..." << endl ;
#endif

  if ( g_sw_substn_ctl_a )
  {
    // Substation voltage control, type A
    simcc_ssctl_a ( cctt ) ;
  }
  else
  {
    simcccore ( cctt ) ;
  }

#ifdef DEBUG_X
  l_ofs << "end of ccal..." << endl ;
#endif

  if ( cctt )
  {
    // Calculation ended successfully

    // ----
    // Calculate voltage and current of the ESS
    // ----
    simCalculateESDVoltagesAndCurrents () ;

    if ( g_sw_ss_direction )
    {
      // Only when this switch is true branch current vector is calculated
      simssdirec () ;
    }
    if ( g_sw_ccalresult )
    {
      // Output circuit analysis result at each iteration
      simccalresult () ;
    }
  }
  else
  {
    // Calculation abnormally terminated
    l_ofs << "ccal failed!" << endl ;
  }
}



// Subroutine around circuit analysis, "the core"
void
feeder :: simcccore
( int & cctt )
{
  // emcc ( false ) ;

#ifdef DEBUG_X
  l_ofs << "before ccal..." << endl ;
#endif

  // ϩ׻ｪλ ccal() ֤ true
  cctt = ccal () ;
//   if ( ! ccal () )
//   {
//     emcc ( true ) ;
//     l_ofs << "ccal first try failed!" << endl ;
//     cctt = ccal () ;   // Re-try
//   }
//   else
//   {
//     cctt = 1 ;    // cctt = 1: ׻
//   }
}



// Output circuit analysis result at each iteration
void
feeder :: simccalresult
()
{
  ostringstream o_cr ;
  l_ofs << "CCALRESULT" << endl ;
  for ( int i = 0 ; i < ncss ; ++ i )
  {
    if ( i < nss )
      l_ofs << "SUB " ;
    else
      l_ofs << "TRN " ;
    o_cr . clear () ;
    o_cr . str ( "" ) ;
    o_cr << setw ( 3 ) << i << " " << fixed << setprecision ( 1 )
         << setw ( 8 ) << getCSD ( i ) -> volt () << " " << setw ( 8 )
         << getCSD ( i ) -> ampere () ;
    l_ofs << o_cr . str () ;
    if ( i < nss )
    {
      if ( g_sw_substn_ctl_a )
      {
	// Žꥢ륿Ű桦A
	// sub [ i ] . getsubcntl () 
        o_cr . clear () ;
        o_cr . str ( "" ) ;
        o_cr << " " << fixed << setprecision ( 6 ) << setw ( 8 )
             << getSUB ( i ) . getsubcntl () ;
	l_ofs << o_cr . str () ;
      }
      if ( g_sw_ss_direction )
      {
	l_ofs << "  2" << endl ;
	for ( sscon :: size_type j = 0 ;
              j < getSUB ( i ) . feedcon () . number () ; ++ j )
	{
          l_ofs << "  FLN  " ;
          o_cr . clear () ;
          o_cr . str ( "" ) ;
          o_cr << " " << setw ( 3 )
               << getSUB ( i ) . feedcon () [ j ] . nfline << "  " << fixed
               << setprecision ( 1 ) << setw ( 8 )
               << getSUB ( i ) . feedcon () [ j ] . sttcurr << "  "
               << setw ( 8 ) << getSUB ( i ) . feedcon () [ j ] . endcurr ;
          l_ofs << o_cr . str () << endl ;
	}
      }
      else
      {
	l_ofs << "  -1" << endl ;
      }
    }
    else
    {
      o_cr . clear () ;
      o_cr . str ( "" ) ;
      o_cr << "  " << setw ( 3 ) << getCAR ( i - nss ) . direc () << " "
           << setw ( 2 ) << getCAR ( i - nss ) . carstat () << " " << fixed
           << setprecision ( 2 ) << setw ( 5 )
           << getCAR ( i - nss ) . velocity () << " " << setprecision ( 4 )
           << setw ( 8 ) << getCAR ( i - nss ) . position () << " "
           << getCAR ( i - nss ) . gradnumber () ;
      l_ofs << o_cr . str () << endl ;
    }
  }

  // : FδؿϤäƲ¤ -- 
  // CSV: , SUB, TRN ȤŰήȰ(֤Τ)
  if ( use_c_file )
  {
    string __quot = g_sw_csv_without_quotation ? "" : "\"" ;
    if ( nogi_header_required )
    {
      nogi_header_required = false ;
      csvout_nogi << __quot << "Time" << __quot ;
      for ( int i = 0 ; i < ncss ; ++ i )
      {
        getCSD ( i ) -> writeHeaderToCSV ( csvout_nogi ) ;
      }
      csvout_nogi << endl ;
    }
    csvout_nogi << " " << t_sim  ;
    for ( int i = 0 ; i < ncss ; ++ i )
    {
      getCSD ( i ) -> writeToCSV ( csvout_nogi ) ;
    }
    csvout_nogi << endl ;
  }

  l_ofs << "ENDCCALRESULT" << endl ;
}



// Žή
void
feeder :: simssdirec
()
{
  //*************************************************************
  // ³ hh  ֥ɥߥ󥹹 dy  ccal ()  
  // μ¹ͿΤȤǤϲƷ׻ʤ    
  //*************************************************************
  // ֥ή٥ȥ = dy * ht * ΡŰ ׻

  static matrix tmp_va ;
  tmp_va . renewmn ( ncss ) ;               // ΰ

  for ( int i = 0 ; i < ncss ; ++ i )
    tmp_va ( i ) = getCSD ( i ) -> volt () ;     // Ű
  static matrix tmp_htvn ;

  ht = feedy . h () ;                     // ***  ht  ***
  dy = feedy . branchadmittance () ;      // ***  dy  ***

  tmp_htvn = ht * tmp_va ;
  tmp_va = dy * tmp_htvn ;     // ֥ή ( νǷ׻:® )
  bran_node ck ;

  // ήꥻå
  // Zero-resetting the directional current at substations.
  for ( int i = 0 ; i < nss ; ++ i )
  {
    for ( sscon :: size_type j = 0 ;
          j < getSUB ( i ) . feedcon () . number () ; ++ j )
    {
      int i_fln = getSUB ( i ) . feedcon () [ j ] . nfline ;
      double x_pos = getSUB ( i ) . feedcon () [ j ] . pos ;
      getSUB ( i ) . directional_curr_start ( i_fln , x_pos , 0 ) ;
      getSUB ( i ) . directional_curr_end ( i_fln , x_pos , 0 ) ;
    }
  }
  
  for ( diagmatrix :: size_type i = 0 ; i < dy . row () ; ++ i )
  {
    // ----
    // This gives the start and end nodes of Branch i
    // ----
    ck = feedy . getElement ( i ) ;

    if ( ck . startnode < nss )
    {
      getSUB ( ck . startnode ) . directional_curr_end  // branch ε
	( ck . nfline , ck . startpos , tmp_va ( i ) ) ;     // Žν¦
    }
    if ( ck . endnode < nss )
    {
      getSUB ( ck . endnode ) . directional_curr_start  // branch ν
	( ck . nfline , ck . endpos , tmp_va ( i ) ) ;     // Žε¦
    }
  }
}



// ʬ׻ޤΥ֥롼
void
feeder :: siminteg
()
{
  irekae ( rpower [ 1 ] , rpower [ 0 ] ) ;               // 
  irekae ( ppower [ 1 ] , ppower [ 0 ] ) ;               // Ϲ
  irekae ( rtpower [ 1 ] , rtpower [ 0 ] ) ;             // 
  irekae ( ptpower [ 1 ] , ptpower [ 0 ] ) ;             // Ϲ
  irekae ( rpsupp [ 1 ] , rpsupp [ 0 ] ) ;               // ǽ
  irekae ( mpower [ 1 ] , mpower [ 0 ] ) ;	// ưؼѥ
  irekae ( mepower [ 1 ] , mepower [ 0 ] ) ;	// mpower Τŵʬ
  irekae ( mbpower [ 1 ] , mbpower [ 0 ] ) ;	// ưؼ֥졼ѥ
  irekae ( mbepower [ 1 ] , mbepower [ 0 ] ) ;	// mbpower Τŵʬ
  for ( int i = 0 ; i < ncar ; ++ i )
  {
#ifdef MORIYAIEN
    if ( getCAR ( i ) . position () >= MORIYA )
    {
      mpower [ 0 ] += getCAR ( i ) . getMechanicalPower () ;
      mepower [ 0 ] += getCAR ( i ) . getMechanicalPower ()
        * getCAR ( i ) . getRatioOfElectricEffortInMechPower () ;
      if ( getCAR ( i ) . getMechanicalPower () < 0 )
      {
        mbpower [ 0 ] -= getCAR ( i ) . getMechanicalPower () ;
        mbepower [ 0 ] -= getCAR ( i ) . getMechanicalPower ()
          * getCAR ( i ) . getRatioOfElectricEffortInMechPower () ;
      }
    }
    if ( getCAR ( i ) . rnotchvl () < 0.0
	 && getCAR ( i ) . position () >= MORIYA )
    {
      rpower [ 0 ]
        += getCAR ( i ) . volt () * getCAR ( i ) . sibori () / 1000.0 ;
      rpsupp [ 0 ]
        += getCAR ( i ) . volt () * getCAR ( i ) . asibori () / 1000.0 ;
    }
    else if ( getCAR ( i ) . rnotchvl () > 0.0
	      && getCAR ( i ) . position () >= MORIYA )
    {
      ppower [ 0 ] -= getCAR ( i ) . volt () * getCAR ( i ) . ampere () / 1000.0 ;
    }
#else
    mpower [ 0 ] += getCAR ( i ) . getMechanicalPower () ;
    mepower [ 0 ] += getCAR ( i ) . getMechanicalPower ()
      * getCAR ( i ) . getRatioOfElectricEffortInMechPower () ;
    if ( getCAR ( i ) . getMechanicalPower () < 0 )
    {
      mbpower [ 0 ] -= getCAR ( i ) . getMechanicalPower () ;
      mbepower [ 0 ] -= getCAR ( i ) . getMechanicalPower ()
        * getCAR ( i ) . getRatioOfElectricEffortInMechPower () ;
    }
    if ( getCAR ( i ) . rnotchvl () < 0.0 )
    {
      rpower [ 0 ]
        += getCAR ( i ) . volt () * getCAR ( i ) . sibori () / 1000.0 ;
      rpsupp [ 0 ]
        += getCAR ( i ) . volt () * getCAR ( i ) . asibori () / 1000.0 ;
    }
    else if ( getCAR ( i ) . rnotchvl () > 0.0 )
    {
      ppower [ 0 ] -= getCAR ( i ) . volt () * getCAR ( i ) . sibori () / 1000.0 ;
    }
#endif
    if ( getCAR ( i ) . ampere () > 0.0 )
    {
      rtpower [ 0 ] += getCAR ( i ) . volt () * getCAR ( i ) . ampere () / 1000.0 ;
    }
    else
    {
      ptpower [ 0 ] -= getCAR ( i ) . volt () * getCAR ( i ) . ampere () / 1000.0 ;
    }
  }

  irekae ( spower [ 1 ] , spower [ 0 ] ) ;               // Ž
  irekae ( srpower [ 1 ] , srpower [ 0 ] ) ;             // Ž
  for ( int i = 0 ; i < nss ; ++ i )
  {
    irekae ( getSUB ( i ) . power () [ 1 ] , getSUB ( i ) . power () [ 0 ] ) ;
    irekae ( getSUB ( i ) . rpower () [ 1 ] , getSUB ( i ) . rpower () [ 0 ] ) ;
    double suba = getSUB ( i ) . ampere () ;
    spower [ 0 ] += getSUB ( i ) . volt () * suba / 1000.0 ;
    if ( suba < 0.0 )
    {
      srpower [ 0 ] -= getSUB ( i ) . volt () * suba / 1000.0 ;
    }
    sqc2 [ i ] = sqc1 [ i ] ;                      // Žңͣή
    sqc1 [ i ] = suba * suba ;
    psqc2 [ i ] = psqc1 [ i ] ;                    // Žңͣή
    if ( suba >= 0.0 )                        // ( positive )
      psqc1 [ i ] = suba * suba ;
    else psqc1 [ i ] = 0.0 ;
    nsqc2 [ i ] = nsqc1 [ i ] ;                    // Žңͣή
    if ( suba < 0.0 )                         // ( negative )
      nsqc1 [ i ] = suba * suba ;
    else nsqc1 [ i ] = 0.0 ;
    getSUB ( i ) . power () [ 0 ]                       // Ž襨ͥ륮
      = getSUB ( i ) . volt () * suba / 1000.0 ;    // 
    if ( suba < 0.0 )
      getSUB ( i ) . rpower () [ 0 ] = getSUB ( i ) . volt () * suba / 1000.0 ;
    getSUB ( i ) . energy () += ddhh
      * ( getSUB ( i ) . power () [ 0 ] + getSUB ( i ) . power () [ 1 ] ) / 2.0 ;
    getSUB ( i ) . renergy () += ddhh
      * ( getSUB ( i ) . rpower () [ 0 ] + getSUB ( i ) . rpower () [ 1 ] ) / 2.0 ;
    if ( g_sw_ss_direction )
    {
      // Ž̥ͥ륮
      for ( sscon :: size_type j = 0 ;
            j < getSUB ( i ) . feedcon () . number () ; ++ j )
      {
	irekae ( getSUB ( i ) . feedcon () [ j ] . sttpower [ 1 ] ,
		 getSUB ( i ) . feedcon () [ j ] . sttpower [ 0 ] ) ;
	irekae ( getSUB ( i ) . feedcon () [ j ] . endpower [ 1 ] ,
		 getSUB ( i ) . feedcon () [ j ] . endpower [ 0 ] ) ;
	// towards the beginning of line
        getSUB ( i ) . feedcon () [ j ] . sttpower [ 0 ] =
          getSUB ( i ) . feedcon () [ j ] . sttcurr * getSUB ( i ) . volt () ;
        getSUB ( i ) . feedcon () [ j ] . sttcurr = 0.0 ;
        getSUB ( i ) . feedcon () [ j ] . sttenrgy
          += ddhh * 
          ( getSUB ( i ) . feedcon () [ j ] . sttpower [ 0 ]
            + getSUB ( i ) . feedcon () [ j ] . sttpower [ 1 ] ) / 2000.0 ;
	// towards the end of line
        getSUB ( i ) . feedcon () [ j ] . endpower [ 0 ] =
          getSUB ( i ) . feedcon () [ j ] . endcurr * getSUB ( i ) . volt () ;
        getSUB ( i ) . feedcon () [ j ] . endcurr = 0.0 ;
        getSUB ( i ) . feedcon () [ j ] . endenrgy
          += ddhh * 
          ( getSUB ( i ) . feedcon () [ j ] . endpower [ 0 ]
            + getSUB ( i ) . feedcon () [ j ] . endpower [ 1 ] ) / 2000.0 ;
      }
    }
  }

  // ˡˤʬ
  renrgy += ddhh * ( rpower [ 0 ] + rpower [ 1 ] ) / 2.0 ;
  resupp += ddhh * ( rpsupp [ 0 ] + rpsupp [ 1 ] ) / 2.0 ;
  penrgy += ddhh * ( ppower [ 0 ] + ppower [ 1 ] ) / 2.0 ;
  senrgy += ddhh * ( spower [ 0 ] + spower [ 1 ] ) / 2.0 ;
  rtenrgy += ddhh * ( rtpower [ 0 ] + rtpower [ 1 ] ) / 2.0 ;
  ptenrgy += ddhh * ( ptpower [ 0 ] + ptpower [ 1 ] ) / 2.0 ;
  srenrgy += ddhh * ( srpower [ 0 ] + srpower [ 1 ] ) / 2.0 ;
  menrgy += ddhh * ( mpower [ 0 ] + mpower [ 1 ] ) / 2.0 ;
  mbenrgy += ddhh * ( mbpower [ 0 ] + mbpower [ 1 ] ) / 2.0 ;
  meenrgy += ddhh * ( mepower [ 0 ] + mepower [ 1 ] ) / 2.0 ;
  mbeenrgy += ddhh * ( mbepower [ 0 ] + mbepower [ 1 ] ) / 2.0 ;
  for ( int i = 0 ; i < nss ; ++ i ) {
    rmsc [ i ] += ddhh * ( sqc1 [ i ] + sqc2 [ i ] ) / 2.0 ;
    prmsc [ i ] += ddhh * ( psqc1 [ i ] + psqc2 [ i ] ) / 2.0 ;
    nrmsc [ i ] += ddhh * ( nsqc1 [ i ] + nsqc2 [ i ] ) / 2.0 ;
  }

  // ϹԼ֥ѥŰ
  tpanvmv = 0.0 ;
  tpanvmvt = 0.0 ;
  for ( int i = 0 ; i < ncar ; ++ i )
  {
    // Ϲԡ׾֤Ǥ
    if ( getCAR ( i ) . carstat () == Power )
      xptime += ddhh ;

    // rnotch ΤȤΤϹԻ
    if ( getCAR ( i ) . rnotchvl () > 0.0 )
    {
      ptime += ddhh ;
      tpanvmvt += ddhh ;
      tpanvmv += getCAR ( i ) . volt () ;
      sepstep ( getCAR ( i ) . volt () , TPANVPLOW , TPANVPSEP ,
		TPANVPSTEP , tpanvp ) ;
      if ( sw_tpanvpbset )
      {
	if ( getCAR ( i ) . volt () < tpanvbottom )
	{
	  tpanvbottom = getCAR ( i ) . volt () ;
	}
	if ( getCAR ( i ) . volt () > tpanvpeak )
	{
	  tpanvpeak = getCAR ( i ) . volt () ;
	}
      }
      else
      {
	sw_tpanvpbset = true ;
	tpanvbottom = tpanvpeak = getCAR ( i ) . volt () ;
      }
    }
  }
  tpanvmean += ddhh * tpanvmv ;
  setpeak () ;                                  // ŽήΥԡ
  double grtsx = 0.0 ;

  // ŽήΥҥȥ
  for ( int i = 0 ; i < nss ; ++ i )
  {
    //      if ( getSUB ( i ) . ampere () > ispeak )
    //          ispeak = getSUB ( i ) . ampere () ;
    sepstep ( getSUB ( i ) . ampere () , TSSCLOW , TSSCSEP , TSSCSTEP , tssc ) ;
    if ( getSUB ( i ) . ampere () < 0 )
      grtsx += getSUB ( i ) . ampere () ;
  }
  sepstep ( grtsx , GRTSSCLOW , GRTSSCSEP , GRTSSCSTEP , grtssc ) ;
}



// ߥ졼ץ
void
feeder :: simulation
()
{

  ostringstream o_sim ;

  deltah = 0.25 ;                                      // ֹ
  cal_deltah = deltah ;        // ׻ѻֹ
  readfile () ;						// ѿ
  disttrain () ;					// ֽ

  t_sim = 0.0 ;                                        // 
  double xx , xx_stt ;
  for ( int k = 0 ; k < ndp ; ++ k )
  {
    getDPT ( k ) . prtinit () ;
  }

  // simulation ϾޤǶ
  l_ofs << "free run till simulation starts..." << endl ;
  g_sw_freerun_cycle = true ;
  if ( nfree == 0 )
  {
    g_sw_freerun_cycle = false ;
    goto FREEEND ;
  }
  if ( ! g_sw_nosetviold )
  {
    for ( int k = 0 ; k < ncss ; ++ k )
    {
      getCSD ( k ) -> teta () = 0 ;
      getCSD ( k ) -> teta_vi () ;
    }
    setviold () ;
  }
  while ( 1 )
  {
    o_sim . clear () ;
    o_sim . str ( "" ) ;
    o_sim << "t_sim = " << fixed << setprecision ( 2 ) << t_sim ;
    l_ofs << o_sim . str () << endl ;
    int cctt ;
    simccsub ( cctt ) ;                           // ϩ׻
    if ( ! cctt )
    {
      // ׻۾ｪλ
      cal_deltah += deltah ;
      restorevi () ;
    }
    else
    {
      // -----
      // Renew the electrical state variables that all objects have.
      // ٤ƤΥ֥ȤͭŵŪѿ򹹿
      // -----
      simRenewElectricalStates () ;
      cal_deltah = deltah ;                              // ʬ
#ifdef DEBUG_X
      l_ofs << "before tellimp..." << endl ;
#endif
      tellimp () ;                  // ֤SS .  Cc ,Cl Ͷ
#ifdef DEBUG_X
      l_ofs << "after tellimp , before autodreg" << endl ;
#endif
      for ( int j = 0 ; j < ncar ; ++ j )
      {	//  V1 , V2 ͤ Cc ,Cl ͤѤ
	getCAR ( j ) . autodreg () ;
        getCAR ( j ) . regendead ( ddhh , tregendead ) ;
      }
    }
#ifdef DEBUG_X
    l_ofs << "after autodreg" << endl ;
#endif
    if ( ! g_sw_nosetviold )
    {
      setviold () ;
    }
#ifdef DEBUG_X
    l_ofs << "before runtrain ... " << endl ;
#endif
    runtrain () ;                                     // ֤ư
#ifdef DEBUG_X
    l_ofs << "runtrain end" << endl ;
#endif
    for ( int j = 0 ; j < ndp ; ++ j )
      getDPT ( j ) . setbuf () ;
    t_sim += deltah ;
#ifdef DEBUG_X
    l_ofs << "time incremented ..." << endl ;
#endif

    // ߥ졼󥵥
    if ( t_sim >= t_cyc * n_simcycle )
      ++ n_simcycle ;

    // 󤷥
    if ( t_sim >= t_cyc * nfree )
    {
      g_sw_freerun_cycle = false ;
      break ;
    }
  }

 FREEEND :	// ʤꤳ뤳Ȥ⤢
  // ----
  // Setting origin of distance.
  // Υå
  // ----
  xx_stt = 0.0 ;
  for ( int i = 0 ; i < ncar ; ++ i )
  {
    xx_stt += getCAR ( i ) . runlen () ;
  }

  // ----
  // Setting ESS Initial SOC.
  // ----
  for ( int i = 0 ; i < ncss ; ++ i )
  {
    getCSD ( i ) -> setStartSOC () ;
  }

  // simulation 
  shokika ( nss ) ;
  bool last = false ;                  // ϩ׻ exit ʤ true
  double tsim_stt = t_sim ;            // ߥ졼󳫻ϻ
  while ( 1 )
  {
    o_sim . clear () ;
    o_sim . str ( "" ) ;
    o_sim << "t_sim = " << fixed << setprecision ( 2 ) << t_sim ;
    l_ofs << o_sim . str () << endl ;
    int cctt ;
    simccsub ( cctt ) ;                               // ϩ׻
    if ( ! cctt )
    {
      // ׻۾ｪλʬʤ
      ddhh += deltah ;
      cal_deltah = ddhh ;
      restorevi () ;
    }
    else
    {
      // -----
      // Renew the electrical state variables that all objects have.
      // ٤ƤΥ֥ȤͭŵŪѿ򹹿
      // -----
      simRenewElectricalStates () ;
      tellimp () ;                  // SS .  Cc ,Cl Ͷ
      for ( int j = 0 ; j < ncar ; ++ j )
      {
	//  V1 , V2 ͤ Cc ,Cl ͤѹ ( Ea_cvauto0  )
	getCAR ( j ) . autodreg () ;

        getCAR ( j ) . regendead ( ddhh , tregendead ) ;
      }
      siminteg () ;                 // ߥ졼ʬ ( ˡ )
      ddhh = deltah ;                              // ʬ
      cal_deltah = ddhh ;
    }

    // Ǹ && ϩ黻ｪλʤ齪λ
    if ( last && cctt )
      break ;

    for ( int j = 0 ; j < ndp ; ++ j )
      getDPT ( j ) . setbuf () ;
    if ( ! g_sw_nosetviold )
    {
      setviold () ;                 // ɲ 92.10.13
    }

    runtrain () ;                                     // ֤ư
    t_sim += deltah ;

    // ߥ졼󥵥
    if ( t_sim >= t_cyc * n_simcycle )
      ++ n_simcycle ;

    // λȽ (  )
    if ( t_sim >= t_cyc * ( nfree + nsim )
	 + ( nfree == 0 ? deltah : 0.0 ) )
      last = true ;
  }

  // ߥ졼Υη׻
  xx = 0.0 ;
  for ( int i = 0 ; i < ncar ; ++ i )
    xx += getCAR ( i ) . runlen () ;

  // ׻̤ν
  double ts_l = t_sim - tsim_stt ;
  ofstream fresult ;
  fresult. open ( r_file ) ;
  if ( fresult . fail () )
  {
    cerr  << "Error: Result file \"" << r_file << "\" open failed." << endl ;
    l_ofs << "Error: Result file \"" << r_file << "\" open failed." << endl ;
    exit ( 1 ) ;
  }
  fresult
    << "     ***** SIMULATION RESULT by RTSS ver. " << RTSS_VERSION
    << " *****" << endl << endl
    << "Total Powering time          =" << fixed << setprecision ( 2 )
    << setw ( 9 ) << ptime << endl
    << "Total Power-Status time      =" << setw ( 9 ) << xptime << endl ;
  if ( g_sw_per_car_out )
  {
    fresult
      << "Regeneratable energy per car =" << fixed << setprecision ( 3 )
      << setw ( 11 ) << resupp / ( 1000.0 * nsim * ncar ) << " MJ /"
      << setw ( 12 ) << resupp / ( ts_l * nsim * ncar ) << " kW"
      << endl
      << "Regenerated energy per car   =" << fixed << setprecision ( 3 )
      << setw ( 11 ) << rtenrgy / ( 1000.0 * nsim * ncar ) << " MJ /"
      << setw ( 12 ) << rtenrgy / ( ts_l * nsim * ncar ) << " kW"
      << endl
      << " (Main circult only)         =" << fixed << setprecision ( 3 )
      << setw ( 11 ) << renrgy / ( 1000.0 * nsim * ncar ) << " MJ /"
      << setw ( 12 ) << renrgy / ( ts_l * nsim * ncar ) << " kW"
      << endl
      << "Powering energy per car      =" << fixed << setprecision ( 3 )
      << setw ( 11 ) << ptenrgy / ( 1000.0 * nsim * ncar ) << " MJ /"
      << setw ( 12 ) << ptenrgy / ( ts_l * nsim * ncar ) << " kW"
      << endl
      << " (Main circuit only)         =" << fixed << setprecision ( 3 )
      << setw ( 11 ) << penrgy / ( 1000.0 * nsim * ncar ) << " MJ /"
      << setw ( 12 ) << penrgy / ( ts_l * nsim * ncar ) << " kW"
      << endl
      << "Energy at wheel rim          =" << fixed << setprecision ( 3 )
      << setw ( 11 ) << menrgy / ( 1000.0 * nsim * ncar ) << " MJ /"
      << setw ( 12 ) << menrgy / ( ts_l * nsim * ncar ) << " kW"
      << endl
      << " (electrical only)           =" << fixed << setprecision ( 3 )
      << setw ( 11 ) << meenrgy / ( 1000.0 * nsim * ncar ) << " MJ /"
      << setw ( 12 ) << meenrgy / ( ts_l * nsim * ncar ) << " kW"
      << endl
      << "Braking energy at wheel rim  =" << fixed << setprecision ( 3 )
      << setw ( 11 ) << mbenrgy / ( 1000.0 * nsim * ncar ) << " MJ /"
      << setw ( 12 ) << mbenrgy / ( ts_l * nsim * ncar ) << " kW"
      << endl
      << " (electrical only)           =" << fixed << setprecision ( 3 )
      << setw ( 11 ) << mbeenrgy / ( 1000.0 * nsim * ncar ) << " MJ /"
      << setw ( 12 ) << mbeenrgy / ( ts_l * nsim * ncar ) << " kW"
      << endl ;
  }
  else
  {
    fresult
      << "Regeneratable energy         =" << fixed << setprecision ( 3 )
      << setw ( 11 ) << resupp / 1000.0 << " MJ /"
      << setw ( 12 ) << resupp / ts_l << " kW" << endl
      << "Regenerated energy           =" << fixed << setprecision ( 3 )
      << setw ( 11 ) << rtenrgy / 1000.0 << " MJ /"
      << setw ( 12 ) << rtenrgy / ts_l << " kW" << endl
      << " (Main circult only)         =" << fixed << setprecision ( 3 )
      << setw ( 11 ) << renrgy / 1000.0 << " MJ /"
      << setw ( 12 ) << renrgy / ts_l << " kW" << endl
      << "Powering energy              =" << fixed << setprecision ( 3 )
      << setw ( 11 ) << ptenrgy / 1000.0 << " MJ /"
      << setw ( 12 ) << ptenrgy / ts_l << " kW" << endl
      << " (Main circuit only)         =" << fixed << setprecision ( 3 )
      << setw ( 11 ) << penrgy / 1000.0 << " MJ /"
      << setw ( 12 ) << penrgy / ts_l << " kW" << endl
      << "Energy at wheel rim          =" << fixed << setprecision ( 3 )
      << setw ( 11 ) << menrgy / 1000.0 << " MJ /"
      << setw ( 12 ) << menrgy / ts_l << " kW" << endl
      << " (electrical only)           =" << fixed << setprecision ( 3 )
      << setw ( 11 ) << meenrgy / 1000.0 << " MJ /"
      << setw ( 12 ) << meenrgy / ts_l << " kW" << endl
      << "Braking energy at wheel rim  =" << fixed << setprecision ( 3 )
      << setw ( 11 ) << mbenrgy / 1000.0 << " MJ /"
      << setw ( 12 ) << mbenrgy / ts_l << " kW" << endl
      << " (electrical only)           =" << fixed << setprecision ( 3 )
      << setw ( 11 ) << mbeenrgy / 1000.0 << " MJ /"
      << setw ( 12 ) << mbeenrgy / ts_l << " kW" << endl ;
  }
  fresult
    << "Energy consumed by trains    =" << fixed << setprecision ( 3 )
    << setw ( 11 ) << ( ptenrgy - rtenrgy ) / 1000.0 << " MJ /"
    << setw ( 12 ) << ( ptenrgy - rtenrgy ) / ts_l << " kW" << endl
    << "Feeder loss                  =" << fixed << setprecision ( 3 )
    << setw ( 11 ) << ( senrgy - ptenrgy + rtenrgy ) / 1000.0 << " MJ /"
    << setw ( 12 ) << ( senrgy - ptenrgy + rtenrgy ) / ts_l << " kW" << endl
    << "Substation inflow energy     =" << fixed << setprecision ( 3 )
    << setw ( 11 ) << ( senrgy + srenrgy ) / 1000.0 << " MJ /"
    << setw ( 12 ) << ( senrgy + srenrgy ) / ts_l << " kW" << endl
    << "Substation outflow energy    =" << fixed << setprecision ( 3 )
    << setw ( 11 ) << srenrgy / 1000.0 << " MJ /"
    << setw ( 12 ) << srenrgy / ts_l << " kW" << endl
    << "Substation input energy      =" << fixed << setprecision ( 3 )
    << setw ( 11 ) << senrgy / 1000.0 << " MJ /"
    << setw ( 12 ) << senrgy / ts_l << " kW" << endl
    << "Regeneration Invalidness Rate =" << fixed << setprecision ( 6 )
    << setw ( 9 ) << 1.0 - renrgy / resupp << endl
    << "Regeneration Disabled time    =" << fixed << setprecision ( 2 )
    << setw ( 9 ) << tregendead << endl
    << "Regeneration Rate             =" << fixed << setprecision ( 6 )
    << setw ( 9 ) << rtenrgy / ptenrgy << endl
    << " (Main circuit only)          =" << fixed << setprecision ( 6 )
    << setw ( 9 ) << renrgy / penrgy << endl ;
  
  double meanvel ;
  meanvel = xx - xx_stt ;
  fresult << "Run Length = " << fixed << setprecision ( 3 ) << setw ( 10 )
          << meanvel << endl ;
  meanvel *= 3600.0 / ( ncar * t_cyc * nsim ) ;
  fresult << "Velocity = " << fixed << setprecision ( 3 ) << setw ( 10 )
          << meanvel << endl ;

  // ----
  // Output SOC-related results
  // ----
  ostringstream oss_soc ;
  ostringstream oss_head ;
  oss_soc << endl << endl
          << "Energy[SOC] of ESS's: init, max, min, final [MJ, %]" << endl ;
  for ( int i = 0 ; i < ncss ; ++ i )
  {
    oss_head . clear () ;
    oss_head . str ( "" ) ;
    if ( i < nss )
    {
      oss_head << " SUB " ; 
    }
    else
    {
      oss_head << " TRN " ;
    }
    oss_head << setw ( 3 ) << i << ":" ;
    getCSD ( i ) -> printSOCStoredResults ( fresult , oss_soc , oss_head ) ;
  }

  fresult
    << endl << endl
    << "Pantograph voltage peak/bottom/mean value of powering cars:" << endl
    << "  " << fixed << setprecision ( 3 ) << setw ( 11 ) << tpanvpeak
    << " [V peak] / " << setw ( 11 ) << tpanvbottom << " [V bottom] / "
    << setw ( 11 ) << tpanvmean / ptime << " [V mean]" << endl << endl
    << "Pantograph voltage of powering cars" << endl ;
  prhistog ( ptime , TPANVPLOW , TPANVPSEP , TPANVPSTEP , tpanvp , fresult ) ;
  fresult << "Substation Current Histogram" << endl ;
  double tsx = ts_l * nss ;
  prhistog ( tsx , TSSCLOW , TSSCSEP , TSSCSTEP , tssc , fresult ) ;
  fresult << "Total Substation Regenerative Current Histogram" << endl ;
  prhistog ( tsx , GRTSSCLOW , GRTSSCSEP , GRTSSCSTEP , grtssc , fresult ) ;
  fresult << "Substation Peak Current" << endl ;
  short int hyoji = 0 ;
  for ( int i = 0 ; i < nss ; ++ i )
  {
    fresult << " No." << setw ( 2 ) << i << ": " << fixed
            << setprecision ( 1 ) << setw ( 8 ) << getSUB ( i ) . peakcur () ;
    if ( hyoji == 2 )
    {
      fresult << endl ;
      hyoji = 0 ;
    }
    else
    {
      ++ hyoji ;
    }
  }
  if ( hyoji != 0 ) fresult << endl ;
  fresult << "Substation Negative Peak Current" << endl ;
  hyoji = 0 ;
  for ( int i = 0 ; i < nss ; ++ i )
  {
    fresult << " No." << setw ( 2 ) << i << ": " << fixed
            << setprecision ( 1 ) << setw ( 8 )
            << getSUB ( i ) . npeakcur () ;
    if ( hyoji == 2 )
    {
      fresult << endl ;
      hyoji = 0 ;
    }
    else
    {
      ++ hyoji ;
    }
  }
  if ( hyoji != 0 ) fresult << endl ;
  fresult << "Substation Maximum Voltage" << endl ;
  hyoji = 0 ;
  for ( int i = 0 ; i < nss ; ++ i )
  {
    fresult << " No." << setw ( 2 ) << i << ": " << fixed
            << setprecision ( 1 ) << setw ( 8 )
            << getSUB ( i ) . peakvolt () ;
    if ( hyoji == 2 )
    {
      fresult << endl ;
      hyoji = 0 ;
    }
    else
    {
      ++ hyoji ;
    }
  }
  if ( hyoji != 0 ) fresult << endl ;
  fresult << "Substation Minimum Voltage" << endl ;
  hyoji = 0 ;
  for ( int i = 0 ; i < nss ; ++ i )
  {
    fresult << " No." << setw ( 2 ) << i << ": " << fixed
            << setprecision ( 1 ) << setw ( 8 )
            << getSUB ( i ) . bottomvolt () ;
    if ( hyoji == 2 )
    {
      fresult << endl ;
      hyoji = 0 ;
    }
    else
    {
      ++ hyoji ;
    }
  }
  if ( hyoji != 0 ) fresult << endl ;
  if ( g_sw_kilowatt_subout )
  {
    fresult << "Substation Energy in [kW] (total, inflow, outflow)" << endl ;
    for ( int i = 0 ; i < nss ; ++ i )
    {
      fresult
        << " No." << setw ( 2 ) << i << ": " << fixed << setprecision ( 3 )
        << setw ( 10 ) << getSUB ( i ) . energy () / ts_l << " " << setw ( 10 )
        << ( getSUB ( i ) . energy () - getSUB ( i ) . renergy () ) / ts_l
        << " " << setw ( 10 ) << - getSUB ( i ) . renergy () / ts_l << endl ;
    }
  }
  else
  {
    fresult << "Substation Energy in [MJ] (total, inflow, outflow)" << endl ;
    for ( int i = 0 ; i < nss ; ++ i )
    {
      fresult
        << " No." << setw ( 2 ) << i << ": " << fixed << setprecision ( 3 )
        << setw ( 10 ) << getSUB ( i ) . energy () / 1000 << " " << setw ( 10 )
        << ( getSUB ( i ) . energy () - getSUB ( i ) . renergy () ) / 1000
        << " " << setw ( 10 ) << - getSUB ( i ) . renergy () / 1000 << endl ;
    }
  }
  if ( g_sw_ss_direction )
  {
    // ̽Ϥ򤷤ȤΤ
    fresult << endl << "Substation Directional Energy and  Peak Current in " ;
    if ( g_sw_kilowatt_subout )
    {
      fresult << "[kW][A]" << endl ;
      for ( int i = 0 ; i < nss ; ++ i )
      {
        fresult << "No." << setw ( 2 ) << i << ": 2" << endl ;
        for ( sscon :: size_type j = 0 ;
              j < getSUB ( i ) . feedcon () . number () ; ++ j )
        {
          fresult
            << " Feedline No." << setw ( 2 ) << j << " STT: " << fixed
            << setprecision ( 3 ) << setw ( 11 )
            << getSUB ( i ) . feedcon () [ j ] . sttenrgy / ts_l
            << " [kW] , " << setw ( 11 )
            << getSUB ( i ) . feedcon () [ j ] . endpeak << " [A] , "
            << setw ( 12 ) << - getSUB ( i ) . feedcon () [ j ] . endnpeak
            << " [A]" << endl
            << " Feedline No." << setw ( 2 ) << j << " END: " << fixed
            << setprecision ( 3 ) << setw ( 11 )
            << getSUB ( i ) . feedcon () [ j ] . endenrgy / ts_l
            << " [kW] , " << setw ( 11 )
            << getSUB ( i ) . feedcon () [ j ] . sttpeak << " [A] , "
            << setw ( 12 ) << - getSUB ( i ) . feedcon () [ j ] . sttnpeak
            << " [A]" << endl ;
        }
      }
    }
    else
    {
      fresult << "[MJ][A]" << endl ;
      for ( int i = 0 ; i < nss ; ++ i )
      {
        fresult << "No." << setw ( 2 ) << i << ": 2" << endl ;
        for ( sscon :: size_type j = 0 ;
              j < getSUB ( i ) . feedcon () . number () ; ++ j )
        {
          fresult
            << " Feedline No." << setw ( 2 ) << j << " STT: " << fixed
            << setprecision ( 3 ) << setw ( 11 )
            << getSUB ( i ) . feedcon () [ j ] . sttenrgy / 1000
            << " [MJ] , " << setw ( 11 )
            << getSUB ( i ) . feedcon () [ j ] . endpeak << " [A] , "
            << setw ( 12 ) << - getSUB ( i ) . feedcon () [ j ] . endnpeak
            << " [A]" << endl
            << " Feedline No." << setw ( 2 ) << j << " END: " << fixed
            << setprecision ( 3 ) << setw ( 11 )
            << getSUB ( i ) . feedcon () [ j ] . endenrgy / 1000
            << " [MJ] , " << setw ( 11 )
            << getSUB ( i ) . feedcon () [ j ] . sttpeak << " [A] , "
            << setw ( 12 ) << - getSUB ( i ) . feedcon () [ j ] . sttnpeak
            << " [A]" << endl ;
        }
      }
    }
  }
  fresult << endl << "Substation RMS Current (total, positive, negative)"
          << endl ;
  for ( int i = 0 ; i < nss ; ++ i )
  {
    fresult << " No." << setw ( 2 ) << i << ": " << fixed
            << setprecision ( 1 ) << setw ( 8 ) << sqrt ( rmsc [ i ] / ts_l )
            << " " << setw ( 8 ) << sqrt ( prmsc [ i ] / ts_l ) << " "
            << setw ( 8 ) << sqrt ( nrmsc [ i ] / ts_l ) << endl ;
  }
  fresult << endl << endl << "simulated time = " << fixed
          << setprecision ( 3 ) << ts_l << endl ;
  fresult . close () ;
}


// histogram ϥ롼
void
prhistog
( double tsx ,
  int lw ,
  int sep ,
  int stp ,
  double * tblhyoji ,
  ofstream & fresult )
{
  fresult << "      -" << setw ( 6 ) << lw << ":" << fixed
          << setprecision ( 6 ) << tblhyoji [ 0 ] / tsx << "  "
          << setw ( 6 ) << lw << "-" << setw ( 6 ) << lw + sep << ":"
          << tblhyoji [ 1 ] / tsx << "  " << setw ( 6 )
          << lw + sep << "-" << setw ( 6 ) << lw + sep * 2 << ":"
          << tblhyoji [ 2 ] / tsx << endl ;
  int npp = int ( floor ( ( stp - 1 ) / 3 ) ) ;
  for ( int i = 1 ; i <= npp ; ++ i )
  {
    int k1 = i * 3 ;
    int k2 = k1 + 1 ;
    int k3 = k2 + 1 ;
    int v1 = lw + sep * ( k1 - 1 ) ;
    int v2 = lw + sep * k1 ;
    int v3 = lw + sep * k2 ;
    int v4 = lw + sep * k3 ;
    if ( i != npp )
      fresult << setw ( 6 ) << v1 << "-" << setw ( 6 ) << v2 << ":" << fixed
              << setprecision ( 6 ) << tblhyoji [ k1 ] / tsx << "  "
              << setw ( 6 ) << v2 << "-" << setw ( 6 ) << v3 << ":"
              << tblhyoji [ k2 ] / tsx << "  " << setw ( 6 )
              << v3 << "-" << setw ( 6 ) << v4 << ":"
              << tblhyoji [ k3 ] / tsx << endl ;
    else if ( k2 == stp )
      fresult << setw ( 6 ) << v1 << "-      :" << fixed
              << setprecision ( 6 ) << tblhyoji [ k1 ] / tsx << endl << endl ;
    else if ( k3 == stp )
      fresult << setw ( 6 ) << v1 << "-" << setw ( 6 ) << v2 << ":" << fixed
              << setprecision ( 6 ) << tblhyoji [ k1 ] / tsx << "  "
              << setw ( 6 ) << v2 << "-      :"
              << tblhyoji [ k2 ] / tsx << endl << endl ;
    else
      fresult << setw ( 6 ) << v1 << "-" << setw ( 6 ) << v2 << ":" << fixed
              << setprecision ( 6 ) << tblhyoji [ k1 ] / tsx << "  "
              << setw ( 6 ) << v2 << "-" << setw ( 6 ) << v3 << ":"
              << tblhyoji [ k2 ] / tsx << "  " << setw ( 6 )
              << v3 << "-      :"
              << tblhyoji [ k3 ] / tsx << endl << endl ;
  }
}



// -----
// Renew the electrical state variables that all objects have.
// ٤ƤΥ֥ȤͭŵŪѿ򹹿
// -----
void
feeder :: simRenewElectricalStates
()
{
  for ( int i = 0 ; i < ncss ; ++ i )
  {
    getCSD ( i ) -> renewElectricalStates () ;
  }
}



// -----
// Calculate voltages and currents of all ESD's
// -----
void
feeder :: simCalculateESDVoltagesAndCurrents
()
{
  for ( int i = 0 ; i < ncss ; ++ i )
  {
    getCSD ( i ) -> calculateESDVoltageAndCurrent () ;
  }
}
