// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// stn_s_rf.cc
// --- functions for class station_obj_stationstop_variation: readfile
// -----
// ChangeLog:
// 2007. 11. 22
//  Redirected log messages to l_file.
// -----

#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <iostream>
#include <sstream>
#include <iomanip>

#include "stnobj_s.hh"

//#define DEBUG

using std :: ostringstream ;
using std :: fixed ;
using std :: setprecision ;
using std :: setw ;



// ޥɤߤȤꥹåν롼
void
station_obj_stationstop_variation :: readfile_additional_bool_set
()
{
  sw_rf_disturbance = false ;
}



// ޥɤߤȤꥹåɾ롼
bool
station_obj_stationstop_variation :: readfile_additional_bool_eval
()
{
  return sw_rf_disturbance ;
}



// ե꡼ɡstation_obj::readfile ɲä
void
station_obj_stationstop_variation :: readfile_additional_readfile
( FILE * hpoint ,
  commandvalue comval )
{

  switch ( comval )
  {

  case DISTURBANCE:
    // ֤٤餻뤫ݤ *****************************************
    // ߥ졼󥵥ǽ˱ؤ夷֤٤餻
    // ʤ Yes, Ǥʤʤ No 롣Yes ξ硢³
    // ٱطΥޥɤ************************************
    err_eof ( sw_rf_disturbance , h_file ) ;
    getcommand ( hpoint , h_file ) ;
    if ( cmpcommand ( "yes" ) || cmpcommand ( "Yes" )
	 || cmpcommand ( "YES" ) )
    {
      sw_disturb = true ;
      cerr << "Yes, disturbance willl occur on station_obj No. " ;
      cerr << get_stnno () << "\n" ;
    }
    else if ( cmpcommand ( "no" ) || cmpcommand ( "No" )
	      || cmpcommand ( "NO" ) )
    {
      sw_disturb = false ;
      cerr << "No, disturbance will NOT occur on station_obj No. " ;
      cerr << get_stnno () << "\n" ;
    }
    else
    {
      err_eof ( h_file ) ;
    }
    break ;

  default:
    err_eof ( h_file ) ;
  }

  if ( ! sw_disturb )
  {
    return ;	// ٤ϤҤʤ, readfile ⽪λ
  }

  bool sw_disttime = false ;
  bool sw_cd_type = false ;
  bool sw_cstnobjn = false ;
  bool sw_cstnobjv = false ;
  bool sw_cstnobjt = false ;

  ostringstream o_x ;
  while ( ! ( sw_disttime && sw_cd_type && sw_cstnobjn
	      && sw_cstnobjv && sw_cstnobjt ) )
  {

    comval = getcommandvalue ( hpoint , h_file ) ;

    switch ( comval )
    {

    case DISTURBANCE_TIME:
      // ֤٤餻 ******************************************
      // ߥ졼󥵥ǽ˱ؤ夷֤ؤĥ
      // դ롣
      // g_sw_freerun_cycle = false ȤʤäȤǺǽ夷֤
      // λؤ֡
      // ³϶ʸβ˽äƻ֤Ĵᡣ***********************
      err_eof ( sw_disttime , h_file ) ;
      getdouble ( hpoint , h_file , d_init ) ;
      o_x . clear () ;
      o_x . str ( "" ) ;
      o_x << fixed << setprecision ( 2 ) << setw ( 10 ) << d_init ;
      l_ofs << "Initial disturbance time: " << o_x . str () << endl ;
      break ;

    case CONTROL_DISTURBANCE_TYPE:
      // ٱμ ****************
      // ٱμҤ٤롣
      // Without_control: ʤˤ⤷ʤ
      // Stop_at_station: ؽȯ޻
      // Slow_down_between: شԻʬ俭
      err_eof ( sw_cd_type , h_file ) ;
      getcommand ( hpoint , h_file ) ;
      cerr << "control_disturbance_type: " ;
      if ( cmpcommand ( "Without_control" ) )
      {
	cd_type = Without_control ;
	cerr << "Without_control" << endl ;
      }
      else if ( cmpcommand ( "Stop_at_station" ) )
      {
	cd_type = Stop_at_station ;
	cerr << "Stop_at_station" << endl ;
      }
      else if ( cmpcommand ( "Slow_down_between" ) )
      {
	cd_type = Slow_down_between ;
	cerr << "Slow_down_between" << endl ;
      }
      else
      {
	err_eof ( h_file ) ;
      }
      break ;

    case CONTROL_STATION_OBJ_NUMBER:
      // 򤫤뤿 station_obj ֹ ******************
      // disturbance ޥɤ٤줿֤֤򤫤롣
      // Υȥоݤꡣ******************************
      err_eof ( sw_cstnobjn , h_file ) ;
      if ( cd_type == Without_control )
      {
	// Υޥɼ¹ cd_type 򥻥åȤ衪
	err_eof ( h_file ) ;
      }
      getint ( hpoint , h_file , control_station_object_number ) ;
      cerr << "Controlling station_obj No. " ;
      cerr << control_station_object_number << endl ;
      break ;

    case CONTROL_STATION_OBJ_VALUE:
      // ̡ñ̡á *****************
      // ȯ޻ߡޤϱٱ̤򼨤
      err_eof ( sw_cstnobjv , h_file ) ;
      if ( cd_type == Without_control )
      {
	// Υޥɼ¹ cd_type 򥻥åȤ衪
	err_eof ( h_file ) ;
      }
      getdouble ( hpoint , h_file , control_station_object_value ) ;
      o_x . clear () ;
      o_x . str ( "" ) ;
      o_x << fixed << setprecision ( 2 ) << setw ( 10 )
          << control_station_object_value << " [sec]" ;
      l_ofs << "Controlling station_obj for " << o_x . str () << endl ;
      break ;

    case CONTROL_STATION_OBJ_TIME:
      // 򤫤Ϥñ̡á ***********
      // ٱ䤹֤Фл֤Ǽ
      err_eof ( sw_cstnobjt , h_file ) ;
      if ( cd_type == Without_control )
      {
	// Υޥɼ¹ cd_type 򥻥åȤ衪
	err_eof ( h_file ) ;
      }
      getdouble ( hpoint , h_file , control_station_object_time ) ;
      getdouble ( hpoint , h_file , control_station_object_value ) ;
      o_x . clear () ;
      o_x . str ( "" ) ;
      o_x << fixed << setprecision ( 2 ) << setw ( 10 )
          << control_station_object_time << " [sec] after arrival" ;
      l_ofs << "Controlling station_obj at " << o_x . str () << endl ;
      break ;

    default:
      err_eof ( h_file ) ;
    }
  }
}
