// This may look like C code, but it is really -*- C++ -*-
// RTSS --- Railway Total System Simulator
// (c) TAKAGI Ryo (at Kogakuin University)
// stnobj.cc --- functions for class station_obj
// -----
// ChangeLog:
// 2007. 11. 22
//  Redirected log messages to l_file.
// -----

#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <iostream>
#include <sstream>
#include <iomanip>

#include "stnobj.hh"
#include "train.hh"


using std :: ostringstream ;
using std :: fixed ;
using std :: setprecision ;
using std :: setw ;



//#define DEBUG

// constructor
station_obj::station_obj
() : NoRefTable<to_station> () {
    first_headcal_ended = false;
    stnno = niolno = nvoie = 0;
    stnobjtype = Doubletrack_no_cross;
}

// 
void station_obj::membercopy
( const station_obj& x ) {
    nvoie = x.nvoie;
    stnobjtype= x.stnobjtype;
    depart_arrival = x.depart_arrival;
    arrival_depart = x.arrival_depart;
    arrival_arrival = x.arrival_arrival;
    depart_depart = x.depart_depart;
}

// 黻Ҥ overload
station_obj& station_obj::operator=
( const station_obj& x ) {
    if (&x == this) return *this;
    NoRefTable<to_station>::operator=( x );
    membercopy( x );
    return *this;
}

// to_station ֥Ȥ
void station_obj::remove
( int nrm ) {
    if ( nrm < 0 || nrm >= num ) {
        error26_name();		// 顼å
        exit( 26 );
    }
    while ( ++nrm < num ) {
        data[ nrm - 1 ] = operator[]( nrm );
    }
    num--;
    return;
}

// train_departure ˥ݥ󥿤򸫤Ĥ
int station_obj::which_in_train_departure
( const train* trptr_arg ) const {
    int imove = 0;
    int sw_nomove = -1;
    station_obj* stox = ( station_obj* ) this;	// const cast
    while ( imove < nvoie ) {
        if ( trptr_arg != stox->train_departure[ imove ].tr_ptr ) {
            imove++;
        } else {
            sw_nomove = 0;
            break;
        }
    }
    if ( sw_nomove ) {
      l_ofs << "Error: no train like this seems to be departing." << endl
            << "Error:  Car No. " << trptr_arg -> car_number () << ", CS No. "
            << trptr_arg -> cs_number () << endl
            << "Error:  Stnobj No. " << get_stnno ()
            << ", train_departure[0].tarrive " ;
      ostringstream o_x ;
      o_x << fixed << setprecision ( 4 ) << setw ( 10 )
          << stox -> train_departure [ 0 ] . tarrive ;
      l_ofs << o_x . str () << endl ;
      cerr << "Error: no train like this seems to be departing." << endl
           << "Error:  Car No. " << trptr_arg -> car_number () << ", CS No. "
           << trptr_arg -> cs_number () << endl
           << "Error:  Stnobj No. " << get_stnno ()
           << ", train_departure[0].tarrive " << o_x . str () << endl ;
      exit ( 61 ) ;
    }
    return imove ;
}



// to_station ˥ݥ󥿤򸫤Ĥ
int
station_obj :: which_in_to_station
( train const * trptr_arg )
  const
{
  int imove = 0 ;
  int sw_nomove = - 1 ;
  while ( imove < number () )
  {
    if ( trptr_arg != operator[] ( imove ) . tr_ptr )
    {
      ++ imove ;
    }
    else
    {
      sw_nomove = 0 ;
      break ;
    }
  }
  if ( sw_nomove )
  {
    ostringstream o_x ;
    o_x << fixed << setprecision ( 4 ) << setw ( 10 )
        << data [ 0 ] . tarrive ;
    l_ofs << "Error: station_obj does not contain this train" << endl
          << "Error:   Car No. " << trptr_arg -> car_number () << ", CS No. "
          << trptr_arg -> cs_number () << endl
          << "Error:   Stnobj No. " << get_stnno () << ", to_station: "
          << number () << ", tarrive " << o_x . str () << endl ;
    cerr << "Error: station_obj does not contain this train" << endl
         << "Error:   Car No. " << trptr_arg -> car_number () << ", CS No. "
         << trptr_arg -> cs_number () << endl
         << "Error:   Stnobj No. " << get_stnno () << ", to_station: "
         << number () << ", tarrive " << o_x . str () << endl ;
    exit ( 60 ) ;
  }
  return imove ;
}

// train_departure[ * ].do_not_depart õƤ֤
bool station_obj::do_not_depart
( const train* trptr_arg ) const {
    station_obj* stox = ( station_obj* ) this;	// const cast
    int nwhich = stox->which_in_train_departure( trptr_arg );
#ifdef DEBUG
    cerr << "departing voie: " << nwhich << "\n";
#endif
    return stox->train_departure[ nwhich ].do_not_depart;
}

// train_departure[ * ].tdept_delay õƤ֤
double station_obj::tdept_delay
( const train* trptr_arg ) const {
    station_obj* stox = ( station_obj* ) this;	// const cast
    return stox->train_departure
        [ stox->which_in_train_departure( trptr_arg ) ].tdept_delay;
}



// operator[]( * ).tarr_delay õƤ֤
double
station_obj :: tarr_delay
( train const * trptr_arg )
  const
{
  return operator[] ( which_in_to_station ( trptr_arg ) ) . tarr_delay ;
}



// to_station ֤夹٤ʤ
// true ֤ؿ
bool station_obj::voie_occupied
( const train* trptr_arg ) const {
    station_obj* stox = ( station_obj* ) this;	// const cast
    int nx_tostn = stox->which_in_to_station( trptr_arg );
    if ( nx_tostn != 0 ) {
        // to_station Ե!
        return true;
    }
    return stox->train_departure
        [ ( *stox )[ nx_tostn ].voie ].is_at_station;
}
